/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import com.vividsolutions.jts.geom.Geometry;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.DecoratingFeature;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.collection.AbstractFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;

class FeatureBoundsFeatureCollection
extends AbstractFeatureCollection {
    SimpleFeatureCollection wrapped;

    public FeatureBoundsFeatureCollection(SimpleFeatureCollection wrapped, SimpleFeatureType targetSchema) {
        super(targetSchema);
        this.wrapped = wrapped;
    }

    protected Iterator openIterator() {
        return new BoundsIterator(this.wrapped.features(), this.schema);
    }

    protected void closeIterator(Iterator close) {
        ((BoundsIterator)close).close();
    }

    public int size() {
        return this.wrapped.size();
    }

    public ReferencedEnvelope getBounds() {
        return this.wrapped.getBounds();
    }

    private static class BoundedFeature
    extends DecoratingFeature {
        private SimpleFeatureType type;

        public BoundedFeature(SimpleFeature wrapped, SimpleFeatureType type) {
            super(wrapped);
            this.type = type;
        }

        public Object getAttribute(int index) {
            return this.delegate.getAttribute(this.type.getDescriptor(index).getName());
        }

        public int getAttributeCount() {
            return this.type.getAttributeCount();
        }

        public Object getAttribute(String path) {
            if (this.type.getDescriptor(path) == null) {
                return null;
            }
            return this.delegate.getAttribute(path);
        }

        public Object[] getAttributes(Object[] attributes) {
            Object[] retval = attributes != null ? attributes : new Object[this.type.getAttributeCount()];
            for (int i = 0; i < retval.length; ++i) {
                retval[i] = this.delegate.getAttribute(this.type.getDescriptor(i).getName());
            }
            return retval;
        }

        public ReferencedEnvelope getBounds() {
            return new ReferencedEnvelope(this.delegate.getBounds());
        }

        public Geometry getDefaultGeometry() {
            return this.getPrimaryGeometry();
        }

        public Geometry getPrimaryGeometry() {
            GeometryDescriptor defaultGeometry = this.type.getGeometryDescriptor();
            if (defaultGeometry == null) {
                return null;
            }
            return (Geometry)this.delegate.getAttribute(defaultGeometry.getName());
        }

        public SimpleFeatureType getFeatureType() {
            return this.type;
        }

        public String getID() {
            return this.delegate.getID();
        }

        public int getNumberOfAttributes() {
            return this.type.getAttributeCount();
        }

        public void setAttribute(int position, Object val) throws IllegalAttributeException, ArrayIndexOutOfBoundsException {
            throw new UnsupportedOperationException("This feature wrapper is read only");
        }

        public void setAttribute(String path, Object attribute) throws IllegalAttributeException {
            throw new UnsupportedOperationException("This feature wrapper is read only");
        }

        public void setDefaultGeometry(Geometry geometry) throws IllegalAttributeException {
            this.setPrimaryGeometry(geometry);
        }

        public void setPrimaryGeometry(Geometry geometry) throws IllegalAttributeException {
            throw new UnsupportedOperationException("This feature wrapper is read only");
        }
    }

    private static class BoundsIterator
    implements Iterator<SimpleFeature> {
        SimpleFeatureIterator wrapped;
        SimpleFeatureType targetSchema;

        public BoundsIterator(SimpleFeatureIterator wrapped, SimpleFeatureType targetSchema) {
            this.wrapped = wrapped;
            this.targetSchema = targetSchema;
        }

        public void close() {
            this.wrapped.close();
        }

        @Override
        public boolean hasNext() {
            return this.wrapped.hasNext();
        }

        @Override
        public SimpleFeature next() throws NoSuchElementException {
            SimpleFeature base = (SimpleFeature)this.wrapped.next();
            return new BoundedFeature(base, this.targetSchema);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Removal is not supported");
        }
    }
}

