/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.KeywordInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ResourceErrorHandling;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.GMLInfo;
import org.geoserver.wfs.WFSGetFeatureOutputFormat;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.request.GetCapabilitiesRequest;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.NameImpl;
import org.geotools.filter.FunctionFactory;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.gml3.v3_2.GML;
import org.geotools.util.logging.Logging;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.geotools.xs.XS;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.Schema;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.capability.FunctionName;
import org.opengis.parameter.Parameter;
import org.vfny.geoserver.global.FeatureTypeInfoTitleComparator;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public abstract class CapabilitiesTransformer
extends TransformerBase {
    private static final Logger LOGGER = Logging.getLogger((String)CapabilitiesTransformer.class.getPackage().getName());
    private static final String HTTP_GET = "Get";
    private static final String HTTP_POST = "Post";
    protected static final String WFS_URI = "http://www.opengis.net/wfs";
    protected static final String XSI_PREFIX = "xsi";
    protected static final String XSI_URI = "http://www.w3.org/2001/XMLSchema-instance";
    protected static final String OGC_PREFIX = "ogc";
    protected static final String OGC_URI = "http://www.opengis.net/ogc";
    protected WFSInfo wfs;
    protected WFSInfo.Version version;
    protected Catalog catalog;

    public CapabilitiesTransformer(WFSInfo wfs, WFSInfo.Version version, Catalog catalog) {
        this.setNamespaceDeclarationEnabled(false);
        this.wfs = wfs;
        this.version = version;
        this.catalog = catalog;
    }

    public void verifyUpdateSequence(GetCapabilitiesRequest request) throws ServiceException {
        long geoUS;
        long reqUS = -1L;
        if (request.getUpdateSequence() != null) {
            try {
                reqUS = Long.parseLong(request.getUpdateSequence());
            }
            catch (NumberFormatException nfe) {
                throw new ServiceException("GeoServer only accepts numbers in the updateSequence parameter");
            }
        }
        if (reqUS > (geoUS = this.wfs.getGeoServer().getGlobal().getUpdateSequence())) {
            throw new ServiceException("Client supplied an updateSequence that is greater than the current sever updateSequence", "InvalidUpdateSequence");
        }
        if (reqUS == geoUS) {
            throw new ServiceException("WFS capabilities document is current (updateSequence = " + geoUS + ")", "CurrentUpdateSequence");
        }
    }

    Set<FunctionName> getAvailableFunctionNames() {
        TreeSet<FunctionName> sortedFunctions = new TreeSet<FunctionName>(new Comparator(){

            public int compare(Object o1, Object o2) {
                String n1 = ((FunctionName)o1).getName();
                String n2 = ((FunctionName)o2).getName();
                return n1.toLowerCase().compareTo(n2.toLowerCase());
            }
        });
        Set factories = CommonFactoryFinder.getFunctionFactories(null);
        for (FunctionFactory factory : factories) {
            sortedFunctions.addAll(factory.getFunctionNames());
        }
        return sortedFunctions;
    }

    String[] getAvailableOutputFormatNames(String first) {
        ArrayList<String> oflist = new ArrayList<String>();
        List featureProducers = GeoServerExtensions.extensions(WFSGetFeatureOutputFormat.class);
        for (WFSGetFeatureOutputFormat format : featureProducers) {
            Iterator f = format.getOutputFormats().iterator();
            while (f.hasNext()) {
                oflist.add(f.next().toString());
            }
        }
        Collections.sort(oflist);
        if (oflist.contains(first)) {
            oflist.remove(first);
            oflist.add(0, first);
        }
        return oflist.toArray(new String[oflist.size()]);
    }

    void updateSequence(AttributesImpl attributes) {
        attributes.addAttribute("", "updateSequence", "updateSequence", "", this.wfs.getGeoServer().getGlobal().getUpdateSequence() + "");
    }

    void registerNamespaces(AttributesImpl attributes) {
        List namespaces = this.catalog.getNamespaces();
        for (NamespaceInfo namespace : namespaces) {
            String prefix = namespace.getPrefix();
            String uri = namespace.getURI();
            if ("xml".equals(prefix)) continue;
            String prefixDef = "xmlns:" + prefix;
            attributes.addAttribute("", prefixDef, prefixDef, "", uri);
        }
    }

    AttributesImpl attributes(String[] nameValues) {
        AttributesImpl atts = new AttributesImpl();
        for (int i = 0; i < nameValues.length; i += 2) {
            String name = nameValues[i];
            String valu = nameValues[i + 1];
            atts.addAttribute(null, null, name, null, valu);
        }
        return atts;
    }

    Map.Entry parameter(final String name, final Object value) {
        return new Map.Entry(){

            public Object getKey() {
                return name;
            }

            public Object getValue() {
                return value;
            }

            public Object setValue(Object value2) {
                return null;
            }
        };
    }

    public static class WFS2_0
    extends CapabilitiesTransformer {
        static String WFS20_URI = "http://www.opengis.net/wfs/2.0";
        static final String GML32_FORMAT = "text/xml; subtype=gml/3.2";
        protected static final String FES_PREFIX = "fes";
        protected static final String FES_URI = "http://www.opengis.net/fes/2.0";

        public WFS2_0(WFSInfo wfs, Catalog catalog) {
            super(wfs, WFSInfo.Version.V_20, catalog);
        }

        public Translator createTranslator(ContentHandler handler) {
            return new CapabilitiesTranslator2_0(handler);
        }

        Name lookupTypeName(List<Schema> profiles, Parameter arg) {
            if ("geometry".equals(arg.getName())) {
                return new NameImpl(GML.AbstractGeometryType);
            }
            Class clazz = arg.getType();
            if (clazz == null || clazz == Object.class) {
                return new NameImpl(XS.STRING);
            }
            for (Schema profile : profiles) {
                for (Map.Entry e : profile.entrySet()) {
                    AttributeType at = (AttributeType)e.getValue();
                    if (at.getBinding() == null || !at.getBinding().equals(clazz)) continue;
                    return at.getName();
                }
                for (AttributeType at : profile.values()) {
                    if (!clazz.isAssignableFrom(at.getBinding())) continue;
                    return at.getName();
                }
            }
            return new NameImpl(XS.STRING);
        }

        class CapabilitiesTranslator2_0
        extends TransformerBase.TranslatorSupport {
            GetCapabilitiesRequest request;
            WFS1_1.CapabilitiesTranslator1_1 delegate;

            public CapabilitiesTranslator2_0(ContentHandler handler) {
                super(handler, null, null);
                this.getNamespaceSupport().declarePrefix("xs", "http://www.w3.org/2001/XMLSchema");
                this.getNamespaceSupport().declarePrefix("gml", "http://www.opengis.net/gml/3.2");
                this.delegate = (WFS1_1.CapabilitiesTranslator1_1)new WFS1_1(WFS2_0.this.wfs, WFS2_0.this.version, WFS2_0.this.catalog).createTranslator(handler);
            }

            public void encode(Object o) throws IllegalArgumentException {
                this.request = GetCapabilitiesRequest.adapt(o);
                AttributesImpl attributes = WFS2_0.this.attributes(new String[]{"version", "2.0.0", "xmlns:xsi", CapabilitiesTransformer.XSI_URI, "xmlns", WFS20_URI, "xmlns:wfs", WFS20_URI, "xmlns:ows", "http://www.opengis.net/ows/1.1", "xmlns:gml", "http://www.opengis.net/gml/3.2", "xmlns:fes", WFS2_0.FES_URI, "xmlns:xlink", "http://www.w3.org/1999/xlink", "xmlns:xs", "http://www.w3.org/2001/XMLSchema", "xsi:schemaLocation", WFS20_URI + " " + (WFS2_0.this.wfs.isCanonicalSchemaLocation() ? "http://schemas.opengis.net/wfs/2.0/wfs.xsd" : ResponseUtils.buildSchemaURL((String)this.request.getBaseUrl(), (String)"wfs/2.0/wfs.xsd"))});
                WFS2_0.this.registerNamespaces(attributes);
                WFS2_0.this.updateSequence(attributes);
                this.start("wfs:WFS_Capabilities", attributes);
                this.delegate.serviceIdentification("2.0.0");
                this.delegate.serviceProvider(WFS2_0.this.wfs.getGeoServer());
                this.operationsMetadata();
                this.featureTypeList();
                this.filterCapabilities();
                this.end("wfs:WFS_Capabilities");
            }

            void operationsMetadata() {
                this.start("ows:OperationsMetadata");
                this.getCapabilities();
                this.describeFeatureType();
                this.getFeature();
                this.getPropertyValue();
                this.listStoredQueries();
                this.describeStoredQueries();
                this.createStoredQuery();
                this.dropStoredQuery();
                if (WFS2_0.this.wfs.getServiceLevel().contains(WFSInfo.ServiceLevel.COMPLETE)) {
                    this.lockFeature();
                    this.getFeatureWithLock();
                }
                if (WFS2_0.this.wfs.getServiceLevel().contains(WFSInfo.ServiceLevel.TRANSACTIONAL)) {
                    this.transaction();
                }
                this.constraints();
                this.end("ows:OperationsMetadata");
            }

            void operation(String name, Map.Entry[] parameters, Map.Entry[] constraints, boolean get, boolean post) {
                int i;
                this.start("ows:Operation", WFS2_0.this.attributes(new String[]{"name", name}));
                String serviceURL = ResponseUtils.buildURL((String)this.request.getBaseUrl(), (String)"wfs", null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
                this.delegate.dcp(serviceURL, get, post);
                for (i = 0; parameters != null && i < parameters.length; ++i) {
                    String pname = (String)parameters[i].getKey();
                    String[] pvalues = (String[])parameters[i].getValue();
                    this.start("ows:Parameter", WFS2_0.this.attributes(new String[]{"name", pname}));
                    this.start("ows:AllowedValues");
                    for (int j = 0; j < pvalues.length; ++j) {
                        this.element("ows:Value", pvalues[j]);
                    }
                    this.end("ows:AllowedValues");
                    this.end("ows:Parameter");
                }
                for (i = 0; constraints != null && i < constraints.length; ++i) {
                    String cname = (String)constraints[i].getKey();
                    this.constraint(cname, constraints[i].getValue());
                }
                this.end("ows:Operation");
            }

            void operation(String name, Map.Entry[] parameters, boolean get, boolean post) {
                this.operation(name, parameters, null, get, post);
            }

            void getCapabilities() {
                Map.Entry[] parameters = new Map.Entry[]{WFS2_0.this.parameter("AcceptVersions", new String[]{"1.0.0", "1.1.0", "2.0.0"}), WFS2_0.this.parameter("AcceptFormats", new String[]{"text/xml"})};
                this.operation("GetCapabilities", parameters, true, true);
            }

            void describeFeatureType() {
                Map.Entry[] parameters = new Map.Entry[]{WFS2_0.this.parameter("outputFormat", new String[]{WFS2_0.GML32_FORMAT})};
                this.operation("DescribeFeatureType", parameters, true, true);
            }

            void getFeature() {
                String[] oflist = WFS2_0.this.getAvailableOutputFormatNames(WFS2_0.GML32_FORMAT);
                Map.Entry[] parameters = new Map.Entry[]{WFS2_0.this.parameter("resultType", new String[]{"results", "hits"}), WFS2_0.this.parameter("outputFormat", oflist)};
                this.operation("GetFeature", parameters, this.getFeatureConstraints(), true, true);
            }

            Map.Entry[] getFeatureConstraints() {
                return new Map.Entry[]{WFS2_0.this.parameter("PagingIsTransactionSafe", false), WFS2_0.this.parameter("CountDefault", WFS2_0.this.wfs.getMaxFeatures())};
            }

            void getFeatureWithLock() {
                String[] oflist = WFS2_0.this.getAvailableOutputFormatNames(WFS2_0.GML32_FORMAT);
                Map.Entry[] parameters = new Map.Entry[]{WFS2_0.this.parameter("resultType", new String[]{"results", "hits"}), WFS2_0.this.parameter("outputFormat", oflist)};
                this.operation("GetFeatureWithLock", parameters, this.getFeatureConstraints(), true, true);
            }

            void getPropertyValue() {
                Map.Entry[] parameters = new Map.Entry[]{WFS2_0.this.parameter("resolve", new String[]{"none"})};
                this.operation("GetPropertyValue", parameters, true, true);
            }

            void lockFeature() {
                Map.Entry[] parameters = new Map.Entry[]{WFS2_0.this.parameter("releaseAction", new String[]{"ALL", "SOME"})};
                this.operation("LockFeature", parameters, true, true);
            }

            void transaction() {
                Map.Entry[] parameters = new Map.Entry[]{WFS2_0.this.parameter("inputFormat", new String[]{WFS2_0.GML32_FORMAT}), WFS2_0.this.parameter("releaseAction", new String[]{"ALL", "SOME"})};
                this.operation("Transaction", parameters, true, true);
            }

            void listStoredQueries() {
                this.operation("ListStoredQueries", null, true, true);
            }

            void describeStoredQueries() {
                this.operation("DescribeStoredQueries", null, true, true);
            }

            void createStoredQuery() {
                this.operation("CreateStoredQuery", null, false, true);
            }

            void dropStoredQuery() {
                this.operation("DropStoredQuery", null, true, true);
            }

            void constraints() {
                this.constraint("ImplementsBasicWFS", true);
                this.constraint("ImplementsTransactionalWFS", true);
                this.constraint("ImplementsLockingWFS", true);
                this.constraint("KVPEncoding", true);
                this.constraint("XMLEncoding", true);
                this.constraint("SOAPEncoding", true);
                this.constraint("ImplementsInheritance", false);
                this.constraint("ImplementsRemoteResolve", false);
                this.constraint("ImplementsResultPaging", true);
                this.constraint("ImplementsStandardJoins", true);
                this.constraint("ImplementsSpatialJoins", true);
                this.constraint("ImplementsTemporalJoins", true);
                this.constraint("ImplementsFeatureVersioning", false);
                this.constraint("ManageStoredQueries", true);
                this.constraint("PagingIsTransactionSafe", false);
                this.constraint("QueryExpressions", new String[]{"wfs:Query", "wfs:StoredQuery"});
            }

            void constraint(String name, Object value) {
                if (value instanceof Boolean) {
                    this.constraint(name, (Boolean)value);
                } else {
                    this.constraint(name, value.toString());
                }
            }

            void constraint(String name, boolean value) {
                this.constraint(name, String.valueOf(value).toUpperCase());
            }

            void constraint(String name, String value) {
                this.start("ows:Constraint", WFS2_0.this.attributes(new String[]{"name", name}));
                this.element("ows:NoValues", null);
                this.element("ows:DefaultValue", value);
                this.end("ows:Constraint");
            }

            void constraint(String name, String[] values) {
                this.start("ows:Constraint", WFS2_0.this.attributes(new String[]{"name", name}));
                this.start("ows:AllowedValues");
                for (String v : values) {
                    this.element("ows:Value", v);
                }
                this.end("ows:AllowedValues");
                this.end("ows:Constraint");
            }

            void featureTypeList() {
                if (WFS2_0.this.catalog.getFeatureTypes().isEmpty()) {
                    return;
                }
                this.start("FeatureTypeList");
                this.delegate.featureTypes(true, this.request.getNamespace());
                this.end("FeatureTypeList");
            }

            void filterCapabilities() {
                this.start("fes:Filter_Capabilities");
                this.start("fes:Conformance");
                this.start("fes:Constraint", WFS2_0.this.attributes(new String[]{"name", "ImplementsQuery"}));
                this.element("ows:NoValues", null);
                this.element("ows:DefaultValue", "TRUE");
                this.end("fes:Constraint");
                this.start("fes:Constraint", WFS2_0.this.attributes(new String[]{"name", "ImplementsAdHocQuery"}));
                this.element("ows:NoValues", null);
                this.element("ows:DefaultValue", "TRUE");
                this.end("fes:Constraint");
                this.start("fes:Constraint", WFS2_0.this.attributes(new String[]{"name", "ImplementsFunctions"}));
                this.element("ows:NoValues", null);
                this.element("ows:DefaultValue", "TRUE");
                this.end("fes:Constraint");
                this.start("fes:Constraint", WFS2_0.this.attributes(new String[]{"name", "ImplementsMinStandardFilter"}));
                this.element("ows:NoValues", null);
                this.element("ows:DefaultValue", "TRUE");
                this.end("fes:Constraint");
                this.start("fes:Constraint", WFS2_0.this.attributes(new String[]{"name", "ImplementsStandardFilter"}));
                this.element("ows:NoValues", null);
                this.element("ows:DefaultValue", "FALSE");
                this.end("fes:Constraint");
                this.start("fes:Constraint", WFS2_0.this.attributes(new String[]{"name", "ImplementsMinSpatialFilter"}));
                this.element("ows:NoValues", null);
                this.element("ows:DefaultValue", "TRUE");
                this.end("fes:Constraint");
                this.start("fes:Constraint", WFS2_0.this.attributes(new String[]{"name", "ImplementsSpatialFilter"}));
                this.element("ows:NoValues", null);
                this.element("ows:DefaultValue", "FALSE");
                this.end("fes:Constraint");
                this.start("fes:Constraint", WFS2_0.this.attributes(new String[]{"name", "ImplementsMinTemporalFilter"}));
                this.element("ows:NoValues", null);
                this.element("ows:DefaultValue", "TRUE");
                this.end("fes:Constraint");
                this.start("fes:Constraint", WFS2_0.this.attributes(new String[]{"name", "ImplementsTemporalFilter"}));
                this.element("ows:NoValues", null);
                this.element("ows:DefaultValue", "TRUE");
                this.end("fes:Constraint");
                this.start("fes:Constraint", WFS2_0.this.attributes(new String[]{"name", "ImplementsVersionNav"}));
                this.element("ows:NoValues", null);
                this.element("ows:DefaultValue", "FALSE");
                this.end("fes:Constraint");
                this.start("fes:Constraint", WFS2_0.this.attributes(new String[]{"name", "ImplementsSorting"}));
                this.start("ows:AllowedValues");
                this.element("ows:Value", "ASC");
                this.element("ows:Value", "DESC");
                this.end("ows:AllowedValues");
                this.element("ows:DefaultValue", "ASC");
                this.end("fes:Constraint");
                this.start("fes:Constraint", WFS2_0.this.attributes(new String[]{"name", "ImplementsExtendedOperators"}));
                this.element("ows:NoValues", null);
                this.element("ows:DefaultValue", "FALSE");
                this.end("fes:Constraint");
                this.end("fes:Conformance");
                this.start("fes:Id_Capabilities");
                this.element("fes:ResourceIdentifier", null, WFS2_0.this.attributes(new String[]{"name", "fes:ResourceId"}));
                this.end("fes:Id_Capabilities");
                this.start("fes:Scalar_Capabilities");
                this.element("fes:LogicalOperators", null);
                this.start("fes:ComparisonOperators");
                this.element("fes:ComparisonOperator", null, WFS2_0.this.attributes(new String[]{"name", "PropertyIsLessThan"}));
                this.element("fes:ComparisonOperator", null, WFS2_0.this.attributes(new String[]{"name", "PropertyIsGreaterThan"}));
                this.element("fes:ComparisonOperator", null, WFS2_0.this.attributes(new String[]{"name", "PropertyIsLessThanOrEqualTo"}));
                this.element("fes:ComparisonOperator", null, WFS2_0.this.attributes(new String[]{"name", "PropertyIsGreaterThanOrEqualTo"}));
                this.element("fes:ComparisonOperator", null, WFS2_0.this.attributes(new String[]{"name", "PropertyIsEqualTo"}));
                this.element("fes:ComparisonOperator", null, WFS2_0.this.attributes(new String[]{"name", "PropertyIsNotEqualTo"}));
                this.element("fes:ComparisonOperator", null, WFS2_0.this.attributes(new String[]{"name", "PropertyIsLike"}));
                this.element("fes:ComparisonOperator", null, WFS2_0.this.attributes(new String[]{"name", "PropertyIsBetween"}));
                this.element("fes:ComparisonOperator", null, WFS2_0.this.attributes(new String[]{"name", "PropertyIsNull"}));
                this.element("fes:ComparisonOperator", null, WFS2_0.this.attributes(new String[]{"name", "PropertyIsNil"}));
                this.end("fes:ComparisonOperators");
                this.end("fes:Scalar_Capabilities");
                this.start("fes:Spatial_Capabilities");
                this.start("fes:GeometryOperands");
                this.element("fes:GeometryOperand", null, WFS2_0.this.attributes(new String[]{"name", "gml:Envelope"}));
                this.element("fes:GeometryOperand", null, WFS2_0.this.attributes(new String[]{"name", "gml:Point"}));
                this.element("fes:GeometryOperand", null, WFS2_0.this.attributes(new String[]{"name", "gml:MultiPoint"}));
                this.element("fes:GeometryOperand", null, WFS2_0.this.attributes(new String[]{"name", "gml:LineString"}));
                this.element("fes:GeometryOperand", null, WFS2_0.this.attributes(new String[]{"name", "gml:MultiLineString"}));
                this.element("fes:GeometryOperand", null, WFS2_0.this.attributes(new String[]{"name", "gml:Polygon"}));
                this.element("fes:GeometryOperand", null, WFS2_0.this.attributes(new String[]{"name", "gml:MultiPolygon"}));
                this.element("fes:GeometryOperand", null, WFS2_0.this.attributes(new String[]{"name", "gml:MultiGeometry"}));
                this.end("fes:GeometryOperands");
                this.start("fes:SpatialOperators");
                this.element("fes:SpatialOperator", null, WFS2_0.this.attributes(new String[]{"name", "Disjoint"}));
                this.element("fes:SpatialOperator", null, WFS2_0.this.attributes(new String[]{"name", "Equals"}));
                this.element("fes:SpatialOperator", null, WFS2_0.this.attributes(new String[]{"name", "DWithin"}));
                this.element("fes:SpatialOperator", null, WFS2_0.this.attributes(new String[]{"name", "Beyond"}));
                this.element("fes:SpatialOperator", null, WFS2_0.this.attributes(new String[]{"name", "Intersects"}));
                this.element("fes:SpatialOperator", null, WFS2_0.this.attributes(new String[]{"name", "Touches"}));
                this.element("fes:SpatialOperator", null, WFS2_0.this.attributes(new String[]{"name", "Crosses"}));
                this.element("fes:SpatialOperator", null, WFS2_0.this.attributes(new String[]{"name", "Within"}));
                this.element("fes:SpatialOperator", null, WFS2_0.this.attributes(new String[]{"name", "Contains"}));
                this.element("fes:SpatialOperator", null, WFS2_0.this.attributes(new String[]{"name", "Overlaps"}));
                this.element("fes:SpatialOperator", null, WFS2_0.this.attributes(new String[]{"name", "BBOX"}));
                this.end("fes:SpatialOperators");
                this.end("fes:Spatial_Capabilities");
                this.start("fes:Temporal_Capabilities");
                this.start("fes:TemporalOperands");
                this.element("fes:TemporalOperand", null, WFS2_0.this.attributes(new String[]{"name", "gml:TimeInstant"}));
                this.element("fes:TemporalOperand", null, WFS2_0.this.attributes(new String[]{"name", "gml:TimePeriod"}));
                this.end("fes:TemporalOperands");
                this.start("fes:TemporalOperators");
                this.element("fes:TemporalOperator", null, WFS2_0.this.attributes(new String[]{"name", "After"}));
                this.element("fes:TemporalOperator", null, WFS2_0.this.attributes(new String[]{"name", "Before"}));
                this.element("fes:TemporalOperator", null, WFS2_0.this.attributes(new String[]{"name", "Begins"}));
                this.element("fes:TemporalOperator", null, WFS2_0.this.attributes(new String[]{"name", "BegunBy"}));
                this.element("fes:TemporalOperator", null, WFS2_0.this.attributes(new String[]{"name", "TContains"}));
                this.element("fes:TemporalOperator", null, WFS2_0.this.attributes(new String[]{"name", "During"}));
                this.element("fes:TemporalOperator", null, WFS2_0.this.attributes(new String[]{"name", "TEquals"}));
                this.element("fes:TemporalOperator", null, WFS2_0.this.attributes(new String[]{"name", "TOverlaps"}));
                this.element("fes:TemporalOperator", null, WFS2_0.this.attributes(new String[]{"name", "Meets"}));
                this.element("fes:TemporalOperator", null, WFS2_0.this.attributes(new String[]{"name", "OverlappedBy"}));
                this.element("fes:TemporalOperator", null, WFS2_0.this.attributes(new String[]{"name", "MetBy"}));
                this.element("fes:TemporalOperator", null, WFS2_0.this.attributes(new String[]{"name", "EndedBy"}));
                this.end("fes:TemporalOperators");
                this.end("fes:Temporal_Capabilities");
                List typeMappingProfiles = GML.getInstance().getAllTypeMappingProfiles();
                this.start("fes:Functions");
                for (FunctionName fn : WFS2_0.this.getAvailableFunctionNames()) {
                    this.start("fes:Function", WFS2_0.this.attributes(new String[]{"name", fn.getName()}));
                    Name returnType = WFS2_0.this.lookupTypeName(typeMappingProfiles, fn.getReturn());
                    String prefix = this.getNamespaceSupport().getPrefix(returnType.getNamespaceURI());
                    if (prefix != null) {
                        this.element("fes:Returns", prefix + ":" + returnType.getLocalPart());
                    } else {
                        LOGGER.warning(String.format("Unable to map function return type to QName for function %s. No namespace mapping for %s.", fn.getName(), returnType.getNamespaceURI()));
                    }
                    if (!fn.getArgumentNames().isEmpty()) {
                        this.start("fes:Arguments");
                        for (Parameter arg : fn.getArguments()) {
                            this.start("fes:Argument", WFS2_0.this.attributes(new String[]{"name", arg.getName()}));
                            Name argType = WFS2_0.this.lookupTypeName(typeMappingProfiles, arg);
                            prefix = this.getNamespaceSupport().getPrefix(argType.getNamespaceURI());
                            if (prefix != null) {
                                this.element("fes:Type", prefix + ":" + argType.getLocalPart());
                            } else {
                                LOGGER.warning(String.format("Unable to map function argument type to QName for function %s. No namespace mapping for %s.", arg.getName(), argType.getNamespaceURI()));
                            }
                            this.end("fes:Argument");
                        }
                        this.end("fes:Arguments");
                    }
                    this.end("fes:Function");
                }
                this.end("fes:Functions");
                this.end("fes:Filter_Capabilities");
            }
        }
    }

    public static class WFS1_1
    extends CapabilitiesTransformer {
        private final boolean skipMisconfigured;

        public WFS1_1(WFSInfo wfs, Catalog catalog) {
            this(wfs, WFSInfo.Version.V_11, catalog);
        }

        public WFS1_1(WFSInfo wfs, WFSInfo.Version version, Catalog catalog) {
            super(wfs, version, catalog);
            this.skipMisconfigured = ResourceErrorHandling.SKIP_MISCONFIGURED_LAYERS.equals((Object)wfs.getGeoServer().getGlobal().getResourceErrorHandling());
        }

        public Translator createTranslator(ContentHandler handler) {
            return new CapabilitiesTranslator1_1(handler);
        }

        class CapabilitiesTranslator1_1
        extends TransformerBase.TranslatorSupport {
            private static final String GML_3_1_1_FORMAT = "text/xml; subtype=gml/3.1.1";
            GetCapabilitiesRequest request;

            public CapabilitiesTranslator1_1(ContentHandler handler) {
                super(handler, null, null);
            }

            public void encode(Object object) throws IllegalArgumentException {
                this.request = GetCapabilitiesRequest.adapt(object);
                WFS1_1.this.verifyUpdateSequence(this.request);
                AttributesImpl attributes = WFS1_1.this.attributes(new String[]{"version", "1.1.0", "xmlns:xsi", CapabilitiesTransformer.XSI_URI, "xmlns", CapabilitiesTransformer.WFS_URI, "xmlns:wfs", CapabilitiesTransformer.WFS_URI, "xmlns:ows", "http://www.opengis.net/ows", "xmlns:gml", "http://www.opengis.net/gml", "xmlns:ogc", CapabilitiesTransformer.OGC_URI, "xmlns:xlink", "http://www.w3.org/1999/xlink", "xsi:schemaLocation", "http://www.opengis.net/wfs " + (WFS1_1.this.wfs.isCanonicalSchemaLocation() ? "http://schemas.opengis.net/wfs/1.1.0/wfs.xsd" : ResponseUtils.buildSchemaURL((String)this.request.getBaseUrl(), (String)"wfs/1.1.0/wfs.xsd"))});
                WFS1_1.this.registerNamespaces(attributes);
                WFS1_1.this.updateSequence(attributes);
                this.start("wfs:WFS_Capabilities", attributes);
                this.serviceIdentification();
                this.serviceProvider(WFS1_1.this.wfs.getGeoServer());
                this.operationsMetadata();
                this.featureTypeList();
                this.filterCapabilities();
                this.end("wfs:WFS_Capabilities");
            }

            void serviceIdentification() {
                this.serviceIdentification("1.1.0");
            }

            void serviceIdentification(String version) {
                this.start("ows:ServiceIdentification");
                this.element("ows:Title", WFS1_1.this.wfs.getTitle());
                this.element("ows:Abstract", WFS1_1.this.wfs.getAbstract());
                this.keywords(WFS1_1.this.wfs.getKeywords());
                this.element("ows:ServiceType", "WFS");
                this.element("ows:ServiceTypeVersion", version);
                this.element("ows:Fees", WFS1_1.this.wfs.getFees());
                this.element("ows:AccessConstraints", WFS1_1.this.wfs.getAccessConstraints());
                this.end("ows:ServiceIdentification");
            }

            void serviceProvider(GeoServer gs) {
                ContactInfo contact = gs.getSettings().getContact();
                this.start("ows:ServiceProvider");
                this.element("ows:ProviderName", contact.getContactOrganization());
                this.start("ows:ServiceContact");
                this.element("ows:IndividualName", contact.getContactPerson());
                this.element("ows:PositionName", contact.getContactPosition());
                this.start("ows:ContactInfo");
                this.start("ows:Phone");
                this.element("ows:Voice", contact.getContactVoice());
                this.element("ows:Facsimile", contact.getContactFacsimile());
                this.end("ows:Phone");
                this.start("ows:Address");
                this.element("ows:City", contact.getAddressCity());
                this.element("ows:AdministrativeArea", contact.getAddressState());
                this.element("ows:PostalCode", contact.getAddressPostalCode());
                this.element("ows:Country", contact.getAddressCountry());
                this.end("ows:Address");
                this.end("ows:ContactInfo");
                this.end("ows:ServiceContact");
                this.end("ows:ServiceProvider");
            }

            void operationsMetadata() {
                this.start("ows:OperationsMetadata");
                this.getCapabilities();
                this.describeFeatureType();
                this.getFeature();
                this.getGmlObject();
                if (WFS1_1.this.wfs.getServiceLevel().contains(WFSInfo.ServiceLevel.COMPLETE)) {
                    this.lockFeature();
                    this.getFeatureWithLock();
                }
                if (WFS1_1.this.wfs.getServiceLevel().contains(WFSInfo.ServiceLevel.TRANSACTIONAL)) {
                    this.transaction();
                }
                this.end("ows:OperationsMetadata");
            }

            void getCapabilities() {
                Map.Entry[] parameters = new Map.Entry[]{WFS1_1.this.parameter("AcceptVersions", new String[]{"1.0.0", "1.1.0"}), WFS1_1.this.parameter("AcceptFormats", new String[]{"text/xml"})};
                this.operation("GetCapabilities", parameters, true, true);
            }

            void describeFeatureType() {
                Map.Entry[] parameters = new Map.Entry[]{WFS1_1.this.parameter("outputFormat", new String[]{GML_3_1_1_FORMAT})};
                this.operation("DescribeFeatureType", parameters, true, true);
            }

            void getFeature() {
                String[] oflist = this.getoutputFormatNames();
                Map.Entry[] parameters = new Map.Entry[]{WFS1_1.this.parameter("resultType", new String[]{"results", "hits"}), WFS1_1.this.parameter("outputFormat", oflist)};
                Map.Entry[] constraints = new Map.Entry[]{WFS1_1.this.parameter("LocalTraverseXLinkScope", new String[]{"2"})};
                this.operation("GetFeature", parameters, constraints, true, true);
            }

            private String[] getoutputFormatNames() {
                return WFS1_1.this.getAvailableOutputFormatNames(GML_3_1_1_FORMAT);
            }

            void getFeatureWithLock() {
                String[] oflist = this.getoutputFormatNames();
                Map.Entry[] parameters = new Map.Entry[]{WFS1_1.this.parameter("resultType", new String[]{"results", "hits"}), WFS1_1.this.parameter("outputFormat", oflist)};
                this.operation("GetFeatureWithLock", parameters, true, true);
            }

            void lockFeature() {
                Map.Entry[] parameters = new Map.Entry[]{WFS1_1.this.parameter("releaseAction", new String[]{"ALL", "SOME"})};
                this.operation("LockFeature", parameters, true, true);
            }

            void transaction() {
                Map.Entry[] parameters = new Map.Entry[]{WFS1_1.this.parameter("inputFormat", new String[]{GML_3_1_1_FORMAT}), WFS1_1.this.parameter("idgen", new String[]{"GenerateNew", "UseExisting", "ReplaceDuplicate"}), WFS1_1.this.parameter("releaseAction", new String[]{"ALL", "SOME"})};
                this.operation("Transaction", parameters, true, true);
            }

            void getGmlObject() {
                Map.Entry[] parameters = new Map.Entry[]{};
                this.operation("GetGmlObject", parameters, true, true);
            }

            void featureTypeList() {
                this.start("FeatureTypeList");
                this.start("Operations");
                if (WFS1_1.this.wfs.getServiceLevel().contains(WFSInfo.ServiceLevel.BASIC)) {
                    this.element("Operation", "Query");
                }
                if (WFS1_1.this.wfs.getServiceLevel().getOps().contains((Object)WFSInfo.Operation.TRANSACTION_INSERT)) {
                    this.element("Operation", "Insert");
                }
                if (WFS1_1.this.wfs.getServiceLevel().getOps().contains((Object)WFSInfo.Operation.TRANSACTION_UPDATE)) {
                    this.element("Operation", "Update");
                }
                if (WFS1_1.this.wfs.getServiceLevel().getOps().contains((Object)WFSInfo.Operation.TRANSACTION_DELETE)) {
                    this.element("Operation", "Delete");
                }
                if (WFS1_1.this.wfs.getServiceLevel().getOps().contains((Object)WFSInfo.Operation.LOCKFEATURE)) {
                    this.element("Operation", "Lock");
                }
                this.end("Operations");
                this.featureTypes();
                this.end("FeatureTypeList");
            }

            void featureTypes() {
                this.featureTypes(false, this.request.getNamespace());
            }

            void featureTypes(boolean crs, String namespace) {
                FeatureTypeInfo ft;
                ArrayList featureTypes = new ArrayList(WFS1_1.this.catalog.getFeatureTypes());
                Iterator it = featureTypes.iterator();
                while (it.hasNext()) {
                    ft = (FeatureTypeInfo)it.next();
                    if (ft.enabled()) continue;
                    it.remove();
                }
                if (namespace != null) {
                    it = featureTypes.iterator();
                    while (it.hasNext()) {
                        ft = (FeatureTypeInfo)it.next();
                        if (namespace.equals(ft.getNamespace().getPrefix())) continue;
                        it.remove();
                    }
                }
                Collections.sort(featureTypes, new FeatureTypeInfoTitleComparator());
                for (FeatureTypeInfo featureType : featureTypes) {
                    if (!featureType.enabled()) continue;
                    try {
                        this.mark();
                        this.featureType(featureType, crs);
                        this.commit();
                    }
                    catch (RuntimeException ex) {
                        if (WFS1_1.this.skipMisconfigured) {
                            this.reset();
                            LOGGER.log(Level.WARNING, "Couldn't encode WFS capabilities entry for featuretype: " + featureType.getPrefixedName(), ex);
                            continue;
                        }
                        throw ex;
                    }
                }
            }

            void featureType(FeatureTypeInfo featureType, boolean crs) {
                GMLInfo gml = WFS1_1.this.wfs.getGML().get((Object)WFS1_1.this.version);
                String prefix = featureType.getNamespace().getPrefix();
                String uri = featureType.getNamespace().getURI();
                this.start("FeatureType", WFS1_1.this.attributes(new String[]{"xmlns:" + prefix, uri}));
                this.element("Name", featureType.getPrefixedName());
                this.element("Title", featureType.getTitle());
                this.element("Abstract", featureType.getAbstract());
                this.keywords(featureType.getKeywords());
                String srs = featureType.getSRS();
                if (srs != null && srs.matches("(?ui)EPSG:[0-9]+")) {
                    srs = gml.getSrsNameStyle().getPrefix() + srs.substring(5);
                }
                if (crs) {
                    this.element("DefaultCRS", srs);
                } else {
                    this.element("DefaultSRS", srs);
                }
                ReferencedEnvelope bbox = null;
                bbox = featureType.getLatLonBoundingBox();
                this.start("ows:WGS84BoundingBox");
                this.element("ows:LowerCorner", bbox.getMinX() + " " + bbox.getMinY());
                this.element("ows:UpperCorner", bbox.getMaxX() + " " + bbox.getMaxY());
                this.end("ows:WGS84BoundingBox");
                this.end("FeatureType");
            }

            void supportsGMLObjectTypeList() {
                this.element("SupportsGMLObjectTypeList", null);
            }

            void filterCapabilities() {
                this.start("ogc:Filter_Capabilities");
                this.start("ogc:Spatial_Capabilities");
                this.start("ogc:GeometryOperands");
                this.element("ogc:GeometryOperand", "gml:Envelope");
                this.element("ogc:GeometryOperand", "gml:Point");
                this.element("ogc:GeometryOperand", "gml:LineString");
                this.element("ogc:GeometryOperand", "gml:Polygon");
                this.end("ogc:GeometryOperands");
                this.start("ogc:SpatialOperators");
                this.element("ogc:SpatialOperator", null, WFS1_1.this.attributes(new String[]{"name", "Disjoint"}));
                this.element("ogc:SpatialOperator", null, WFS1_1.this.attributes(new String[]{"name", "Equals"}));
                this.element("ogc:SpatialOperator", null, WFS1_1.this.attributes(new String[]{"name", "DWithin"}));
                this.element("ogc:SpatialOperator", null, WFS1_1.this.attributes(new String[]{"name", "Beyond"}));
                this.element("ogc:SpatialOperator", null, WFS1_1.this.attributes(new String[]{"name", "Intersects"}));
                this.element("ogc:SpatialOperator", null, WFS1_1.this.attributes(new String[]{"name", "Touches"}));
                this.element("ogc:SpatialOperator", null, WFS1_1.this.attributes(new String[]{"name", "Crosses"}));
                this.element("ogc:SpatialOperator", null, WFS1_1.this.attributes(new String[]{"name", "Within"}));
                this.element("ogc:SpatialOperator", null, WFS1_1.this.attributes(new String[]{"name", "Contains"}));
                this.element("ogc:SpatialOperator", null, WFS1_1.this.attributes(new String[]{"name", "Overlaps"}));
                this.element("ogc:SpatialOperator", null, WFS1_1.this.attributes(new String[]{"name", "BBOX"}));
                this.end("ogc:SpatialOperators");
                this.end("ogc:Spatial_Capabilities");
                this.start("ogc:Scalar_Capabilities");
                this.element("ogc:LogicalOperators", null);
                this.start("ogc:ComparisonOperators");
                this.element("ogc:ComparisonOperator", "LessThan");
                this.element("ogc:ComparisonOperator", "GreaterThan");
                this.element("ogc:ComparisonOperator", "LessThanEqualTo");
                this.element("ogc:ComparisonOperator", "GreaterThanEqualTo");
                this.element("ogc:ComparisonOperator", "EqualTo");
                this.element("ogc:ComparisonOperator", "NotEqualTo");
                this.element("ogc:ComparisonOperator", "Like");
                this.element("ogc:ComparisonOperator", "Between");
                this.element("ogc:ComparisonOperator", "NullCheck");
                this.end("ogc:ComparisonOperators");
                this.start("ogc:ArithmeticOperators");
                this.element("ogc:SimpleArithmetic", null);
                this.functions();
                this.end("ogc:ArithmeticOperators");
                this.end("ogc:Scalar_Capabilities");
                this.start("ogc:Id_Capabilities");
                this.element("ogc:FID", null);
                this.element("ogc:EID", null);
                this.end("ogc:Id_Capabilities");
                this.end("ogc:Filter_Capabilities");
            }

            void functions() {
                this.start("ogc:Functions");
                Set<FunctionName> functions = WFS1_1.this.getAvailableFunctionNames();
                if (!functions.isEmpty()) {
                    this.start("ogc:FunctionNames");
                    for (FunctionName fe : functions) {
                        this.element("ogc:FunctionName", fe.getName(), WFS1_1.this.attributes(new String[]{"nArgs", "" + fe.getArgumentCount()}));
                    }
                    this.end("ogc:FunctionNames");
                }
                this.end("ogc:Functions");
            }

            void keywords(KeywordInfo[] keywords) {
                if (keywords == null || keywords.length == 0) {
                    return;
                }
                this.start("ows:Keywords");
                for (int i = 0; i < keywords.length; ++i) {
                    this.element("ows:Keyword", keywords[i].getValue());
                }
                this.end("ows:Keywords");
            }

            void keywords(List keywords) {
                if (keywords != null) {
                    this.keywords(keywords.toArray(new KeywordInfo[keywords.size()]));
                }
            }

            void operation(String name, Map.Entry[] parameters, boolean get, boolean post) {
                this.operation(name, parameters, null, get, post);
            }

            void operation(String name, Map.Entry[] parameters, Map.Entry[] constraints, boolean get, boolean post) {
                int j;
                int i;
                this.start("ows:Operation", WFS1_1.this.attributes(new String[]{"name", name}));
                String serviceURL = ResponseUtils.buildURL((String)this.request.getBaseUrl(), (String)"wfs", null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
                this.dcp(serviceURL, get, post);
                for (i = 0; i < parameters.length; ++i) {
                    String pname = (String)parameters[i].getKey();
                    String[] pvalues = (String[])parameters[i].getValue();
                    this.start("ows:Parameter", WFS1_1.this.attributes(new String[]{"name", pname}));
                    for (j = 0; j < pvalues.length; ++j) {
                        this.element("ows:Value", pvalues[j]);
                    }
                    this.end("ows:Parameter");
                }
                for (i = 0; constraints != null && i < constraints.length; ++i) {
                    String cname = (String)constraints[i].getKey();
                    String[] cvalues = (String[])constraints[i].getValue();
                    this.start("ows:Constraint", WFS1_1.this.attributes(new String[]{"name", cname}));
                    for (j = 0; j < cvalues.length; ++j) {
                        this.element("ows:Value", cvalues[j]);
                    }
                    this.end("ows:Constraint");
                }
                this.end("ows:Operation");
            }

            void dcp(String serviceURL, boolean get, boolean post) {
                this.start("ows:DCP");
                this.start("ows:HTTP");
                if (get) {
                    this.element("ows:Get", null, WFS1_1.this.attributes(new String[]{"xlink:href", serviceURL}));
                }
                if (post) {
                    this.element("ows:Post", null, WFS1_1.this.attributes(new String[]{"xlink:href", serviceURL}));
                }
                this.end("ows:HTTP");
                this.end("ows:DCP");
            }
        }
    }

    public static class WFS1_0
    extends CapabilitiesTransformer {
        private final boolean skipMisconfigured;

        public WFS1_0(WFSInfo wfs, Catalog catalog) {
            super(wfs, WFSInfo.Version.V_10, catalog);
            this.skipMisconfigured = ResourceErrorHandling.SKIP_MISCONFIGURED_LAYERS.equals((Object)wfs.getGeoServer().getGlobal().getResourceErrorHandling());
        }

        public Translator createTranslator(ContentHandler handler) {
            return new CapabilitiesTranslator1_0(handler);
        }

        class CapabilitiesTranslator1_0
        extends TransformerBase.TranslatorSupport {
            GetCapabilitiesRequest request;

            public CapabilitiesTranslator1_0(ContentHandler handler) {
                super(handler, null, null);
            }

            public void encode(Object object) throws IllegalArgumentException {
                this.request = GetCapabilitiesRequest.adapt(object);
                AttributesImpl attributes = new AttributesImpl();
                attributes.addAttribute("", "version", "version", "", "1.0.0");
                attributes.addAttribute("", "xmlns", "xmlns", "", CapabilitiesTransformer.WFS_URI);
                List namespaces = WFS1_0.this.catalog.getNamespaces();
                for (NamespaceInfo namespace : namespaces) {
                    String prefix = namespace.getPrefix();
                    String uri = namespace.getURI();
                    if ("xml".equals(prefix)) continue;
                    String prefixDef = "xmlns:" + prefix;
                    attributes.addAttribute("", prefixDef, prefixDef, "", uri);
                }
                attributes.addAttribute("", "xmlns:ogc", "xmlns:ogc", "", CapabilitiesTransformer.OGC_URI);
                attributes.addAttribute("", "xmlns:xsi", "xmlns:xsi", "", CapabilitiesTransformer.XSI_URI);
                String locationAtt = "xsi:schemaLocation";
                String locationDef = "http://www.opengis.net/wfs " + (WFS1_0.this.wfs.isCanonicalSchemaLocation() ? "http://schemas.opengis.net/wfs/1.0.0/WFS-capabilities.xsd" : ResponseUtils.buildSchemaURL((String)this.request.getBaseUrl(), (String)"wfs/1.0.0/WFS-capabilities.xsd"));
                attributes.addAttribute("", locationAtt, locationAtt, "", locationDef);
                this.start("WFS_Capabilities", attributes);
                this.handleService();
                this.handleCapability();
                this.handleFeatureTypes();
                this.handleFilterCapabilities();
                this.end("WFS_Capabilities");
            }

            private void handleService() {
                this.start("Service");
                this.element("Name", WFS1_0.this.wfs.getName());
                this.element("Title", WFS1_0.this.wfs.getTitle());
                this.element("Abstract", WFS1_0.this.wfs.getAbstract());
                this.handleKeywords(WFS1_0.this.wfs.getKeywords());
                this.element("OnlineResource", ResponseUtils.buildURL((String)this.request.getBaseUrl(), (String)"wfs", null, (URLMangler.URLType)URLMangler.URLType.SERVICE));
                this.element("Fees", WFS1_0.this.wfs.getFees());
                this.element("AccessConstraints", WFS1_0.this.wfs.getAccessConstraints());
                this.end("Service");
            }

            private void handleKeywords(String[] kwlist) {
                if (kwlist == null) {
                    this.handleKeywords((List)null);
                } else {
                    this.handleKeywords(Arrays.asList(kwlist));
                }
            }

            private void handleKeywords(List kwlist) {
                StringBuffer kwds = new StringBuffer();
                for (int i = 0; kwlist != null && i < kwlist.size(); ++i) {
                    kwds.append(kwlist.get(i));
                    if (i == kwlist.size() - 1) continue;
                    kwds.append(", ");
                }
                this.element("Keywords", kwds.toString());
            }

            private void handleCapability() {
                this.start("Capability");
                this.start("Request");
                this.handleGetCapabilities();
                this.handleDescribeFT();
                this.handleGetFeature();
                if (WFS1_0.this.wfs.getServiceLevel().contains(WFSInfo.ServiceLevel.TRANSACTIONAL)) {
                    this.handleTransaction();
                }
                if (WFS1_0.this.wfs.getServiceLevel().contains(WFSInfo.ServiceLevel.COMPLETE)) {
                    this.handleLock();
                    this.handleFeatureWithLock();
                }
                this.end("Request");
                this.end("Capability");
            }

            private void handleGetCapabilities() {
                String capName = "GetCapabilities";
                this.start(capName);
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_GET);
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_POST);
                this.end(capName);
            }

            private void handleDescribeFT() {
                String capName = "DescribeFeatureType";
                this.start(capName);
                this.start("SchemaDescriptionLanguage");
                this.element("XMLSCHEMA", null);
                this.end("SchemaDescriptionLanguage");
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_GET);
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_POST);
                this.end(capName);
            }

            private void handleGetFeature() {
                String capName = "GetFeature";
                this.start(capName);
                String resultFormat = "ResultFormat";
                this.start(resultFormat);
                if (WFS1_0.this.wfs.isCiteCompliant()) {
                    this.element("GML2", null);
                } else {
                    List featureProducers = GeoServerExtensions.extensions(WFSGetFeatureOutputFormat.class);
                    HashMap<String, Object> dupes = new HashMap<String, Object>();
                    for (WFSGetFeatureOutputFormat format : featureProducers) {
                        if (dupes.containsKey(format.getCapabilitiesElementName())) continue;
                        this.element(format.getCapabilitiesElementName(), null);
                        dupes.put(format.getCapabilitiesElementName(), new Object());
                    }
                }
                this.end(resultFormat);
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_GET);
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_POST);
                this.end(capName);
            }

            private void handleTransaction() {
                String capName = "Transaction";
                this.start(capName);
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_GET);
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_POST);
                this.end(capName);
            }

            private void handleLock() {
                String capName = "LockFeature";
                this.start(capName);
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_GET);
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_POST);
                this.end(capName);
            }

            private void handleFeatureWithLock() {
                String capName = "GetFeatureWithLock";
                this.start(capName);
                this.start("ResultFormat");
                this.element("GML2", null);
                this.end("ResultFormat");
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_GET);
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_POST);
                this.end(capName);
            }

            private void handleDcpType(String capabilityName, String httpMethod) {
                String onlineResource;
                if (CapabilitiesTransformer.HTTP_GET.equals(httpMethod)) {
                    onlineResource = ResponseUtils.buildURL((String)this.request.getBaseUrl(), (String)"wfs", (Map)ResponseUtils.params((String[])new String[]{"request", capabilityName}), (URLMangler.URLType)URLMangler.URLType.SERVICE);
                } else {
                    onlineResource = ResponseUtils.buildURL((String)this.request.getBaseUrl(), (String)"wfs", null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
                    ResponseUtils.appendQueryString((String)onlineResource, (String)"");
                }
                this.start("DCPType");
                this.start("HTTP");
                AttributesImpl atts = new AttributesImpl();
                atts.addAttribute("", "onlineResource", "onlineResource", "", onlineResource);
                this.element(httpMethod, null, atts);
                this.end("HTTP");
                this.end("DCPType");
            }

            private void handleFeatureTypes() {
                if (!WFS1_0.this.wfs.isEnabled()) {
                    // empty if block
                }
                this.start("FeatureTypeList");
                this.start("Operations");
                if (WFS1_0.this.wfs.getServiceLevel().contains(WFSInfo.ServiceLevel.BASIC)) {
                    this.element("Query", null);
                }
                if (WFS1_0.this.wfs.getServiceLevel().getOps().contains((Object)WFSInfo.Operation.TRANSACTION_INSERT)) {
                    this.element("Insert", null);
                }
                if (WFS1_0.this.wfs.getServiceLevel().getOps().contains((Object)WFSInfo.Operation.TRANSACTION_UPDATE)) {
                    this.element("Update", null);
                }
                if (WFS1_0.this.wfs.getServiceLevel().getOps().contains((Object)WFSInfo.Operation.TRANSACTION_DELETE)) {
                    this.element("Delete", null);
                }
                if (WFS1_0.this.wfs.getServiceLevel().getOps().contains((Object)WFSInfo.Operation.LOCKFEATURE)) {
                    this.element("Lock", null);
                }
                this.end("Operations");
                ArrayList featureTypes = new ArrayList(WFS1_0.this.catalog.getFeatureTypes());
                Iterator it = featureTypes.iterator();
                while (it.hasNext()) {
                    FeatureTypeInfo ft = (FeatureTypeInfo)it.next();
                    if (ft.enabled()) continue;
                    it.remove();
                }
                if (this.request.getNamespace() != null) {
                    String namespace = this.request.getNamespace();
                    Iterator it2 = featureTypes.iterator();
                    while (it2.hasNext()) {
                        FeatureTypeInfo ft = (FeatureTypeInfo)it2.next();
                        if (namespace.equals(ft.getNamespace().getPrefix())) continue;
                        it2.remove();
                    }
                }
                Collections.sort(featureTypes, new FeatureTypeInfoTitleComparator());
                for (FeatureTypeInfo ftype : featureTypes) {
                    try {
                        this.mark();
                        this.handleFeatureType(ftype);
                        this.commit();
                    }
                    catch (RuntimeException e) {
                        if (WFS1_0.this.skipMisconfigured) {
                            this.reset();
                            LOGGER.log(Level.WARNING, "Couldn't encode WFS Capabilities entry for FeatureType: " + ftype.getPrefixedName(), e);
                            continue;
                        }
                        throw e;
                    }
                }
                this.end("FeatureTypeList");
            }

            private void handleFeatureType(FeatureTypeInfo info) {
                ReferencedEnvelope bbox = null;
                bbox = info.getLatLonBoundingBox();
                this.start("FeatureType");
                this.element("Name", info.getPrefixedName());
                this.element("Title", info.getTitle());
                this.element("Abstract", info.getAbstract());
                this.handleKeywords(info.getKeywords());
                this.element("SRS", info.getSRS());
                String minx = String.valueOf(bbox.getMinX());
                String miny = String.valueOf(bbox.getMinY());
                String maxx = String.valueOf(bbox.getMaxX());
                String maxy = String.valueOf(bbox.getMaxY());
                AttributesImpl bboxAtts = new AttributesImpl();
                bboxAtts.addAttribute("", "minx", "minx", "", minx);
                bboxAtts.addAttribute("", "miny", "miny", "", miny);
                bboxAtts.addAttribute("", "maxx", "maxx", "", maxx);
                bboxAtts.addAttribute("", "maxy", "maxy", "", maxy);
                this.element("LatLongBoundingBox", null, bboxAtts);
                this.end("FeatureType");
            }

            private void handleFilterCapabilities() {
                String ogc = "ogc:";
                this.start(ogc + "Filter_Capabilities");
                this.start(ogc + "Spatial_Capabilities");
                this.start(ogc + "Spatial_Operators");
                this.element(ogc + "Disjoint", null);
                this.element(ogc + "Equals", null);
                this.element(ogc + "DWithin", null);
                this.element(ogc + "Beyond", null);
                this.element(ogc + "Intersect", null);
                this.element(ogc + "Touches", null);
                this.element(ogc + "Crosses", null);
                this.element(ogc + "Within", null);
                this.element(ogc + "Contains", null);
                this.element(ogc + "Overlaps", null);
                this.element(ogc + "BBOX", null);
                this.end(ogc + "Spatial_Operators");
                this.end(ogc + "Spatial_Capabilities");
                this.start(ogc + "Scalar_Capabilities");
                this.element(ogc + "Logical_Operators", null);
                this.start(ogc + "Comparison_Operators");
                this.element(ogc + "Simple_Comparisons", null);
                this.element(ogc + "Between", null);
                this.element(ogc + "Like", null);
                this.element(ogc + "NullCheck", null);
                this.end(ogc + "Comparison_Operators");
                this.start(ogc + "Arithmetic_Operators");
                this.element(ogc + "Simple_Arithmetic", null);
                this.handleFunctions(ogc);
                this.end(ogc + "Arithmetic_Operators");
                this.end(ogc + "Scalar_Capabilities");
                this.end(ogc + "Filter_Capabilities");
            }

            private void handleFunctions(String prefix) {
                FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
                this.start(prefix + "Functions");
                this.start(prefix + "Function_Names");
                Set<FunctionName> functions = WFS1_0.this.getAvailableFunctionNames();
                for (FunctionName fname : functions) {
                    AttributesImpl atts = new AttributesImpl();
                    atts.addAttribute("", "nArgs", "nArgs", "", fname.getArgumentCount() + "");
                    this.element(prefix + "Function_Name", fname.getName(), atts);
                }
                this.end(prefix + "Function_Names");
                this.end(prefix + "Functions");
            }
        }
    }
}

