/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.util;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeIterator<T>
implements Iterator<T> {
    private Iterator<Iterator<T>> iterators;
    private Iterator<T> curr;

    public CompositeIterator(List<Iterator<T>> iterators) {
        this.iterators = iterators.iterator();
        this.curr = this.iterators.hasNext() ? this.iterators.next() : null;
    }

    @Override
    public boolean hasNext() {
        if (this.curr == null) {
            return false;
        }
        if (this.curr.hasNext()) {
            return true;
        }
        this.curr = this.iterators.hasNext() ? this.iterators.next() : null;
        return this.hasNext();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.curr.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

