/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage.metastore.jdbc;

import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.config.ConfigurationException;
import org.geowebcache.storage.BlobStore;
import org.geowebcache.storage.DefaultStorageFinder;
import org.geowebcache.storage.MetaStore;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.StorageObject;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.TileRange;
import org.geowebcache.storage.metastore.jdbc.JDBCMBIdCache;
import org.geowebcache.storage.metastore.jdbc.JDBCMBWrapper;
import org.springframework.util.Assert;

public class JDBCMetaBackend
implements MetaStore {
    private static Log log = LogFactory.getLog(JDBCMetaBackend.class);
    private JDBCMBWrapper wrpr;
    private final JDBCMBIdCache idCache;
    private long lockRetryDelay = 50L;
    private boolean enabled = true;

    @Deprecated
    public JDBCMetaBackend(String driverClass, String jdbcString, String username, String password) throws ConfigurationException {
        this(null, driverClass, jdbcString, username, password, false, -1);
    }

    @Deprecated
    public JDBCMetaBackend(String driverClass, String jdbcString, String username, String password, boolean useConnectionPooling, int maxConnections) throws ConfigurationException {
        this(null, driverClass, jdbcString, username, password, useConnectionPooling, maxConnections);
    }

    public JDBCMetaBackend(DefaultStorageFinder defStoreFind, String driverClass, String jdbcString, String username, String password) throws ConfigurationException {
        this(defStoreFind, driverClass, jdbcString, username, password, false, -1);
    }

    public JDBCMetaBackend(DefaultStorageFinder defStoreFind, String driverClass, String jdbcString, String username, String password, boolean useConnectionPooling, int maxConnections) throws ConfigurationException {
        if (useConnectionPooling && maxConnections <= 0) {
            throw new IllegalArgumentException("If connection pooling is enabled maxConnections shall be a positive integer: " + maxConnections);
        }
        if (defStoreFind != null && this.isMetaStoreDisabled(defStoreFind)) {
            this.enabled = false;
            this.wrpr = null;
            this.idCache = null;
        } else {
            try {
                this.wrpr = new JDBCMBWrapper(driverClass, jdbcString, username, password, useConnectionPooling, maxConnections);
            }
            catch (SQLException se) {
                this.enabled = false;
                throw new ConfigurationException(se.getMessage());
            }
            this.idCache = this.enabled ? new JDBCMBIdCache(this.wrpr) : null;
        }
    }

    private boolean isMetaStoreDisabled(DefaultStorageFinder defStoreFind) {
        String metaStoreDisabled = defStoreFind.findEnvVar("GWC_METASTORE_DISABLED");
        return metaStoreDisabled != null && Boolean.parseBoolean(metaStoreDisabled);
    }

    public JDBCMetaBackend(DefaultStorageFinder defStoreFind) throws ConfigurationException {
        this(defStoreFind, false, -1);
    }

    public JDBCMetaBackend(DefaultStorageFinder defStoreFind, boolean useConnectionPooling, int maxConnections) throws ConfigurationException {
        if (useConnectionPooling && maxConnections <= 0) {
            throw new IllegalArgumentException("If connection pooling is enabled maxConnections shall be a positive integer: " + maxConnections);
        }
        String metaStoreDisabled = defStoreFind.findEnvVar("GWC_METASTORE_DISABLED");
        if (metaStoreDisabled != null && Boolean.parseBoolean(metaStoreDisabled)) {
            this.enabled = false;
            this.wrpr = null;
            this.idCache = null;
        } else {
            try {
                this.wrpr = new JDBCMBWrapper(defStoreFind, useConnectionPooling, maxConnections);
            }
            catch (SQLException se) {
                log.error((Object)("Failed to start JDBC metastore: " + se.getMessage()));
                log.warn((Object)"Disabling JDBC metastore, not all functionality will be available!");
                this.enabled = false;
                this.wrpr = null;
            }
            this.idCache = this.enabled ? new JDBCMBIdCache(this.wrpr) : null;
        }
    }

    public boolean enabled() {
        return this.enabled;
    }

    public boolean delete(String layerName) throws StorageException {
        long layerId = this.idCache.getLayerId(layerName);
        try {
            this.wrpr.deleteLayer(layerId);
            return true;
        }
        catch (SQLException se) {
            log.error((Object)("Failed to delete layer '" + layerName + "'"), (Throwable)se);
            return false;
        }
    }

    public boolean deleteByGridsetId(String layerName, String gridsetName) throws StorageException {
        long layerId = this.idCache.getLayerId(layerName);
        long gridSetId = this.idCache.getGridSetsId(gridsetName);
        try {
            this.wrpr.deleteLayerGridSubset(layerId, gridSetId);
            return true;
        }
        catch (SQLException se) {
            log.error((Object)("Failed to delete layer gridset '" + layerName + "'" + "/'" + gridsetName + "'"), (Throwable)se);
            return false;
        }
    }

    public boolean rename(String oldLayerName, String newLayerName) throws StorageException {
        Assert.notNull((Object)oldLayerName, (String)"old layer name");
        Assert.notNull((Object)newLayerName, (String)"new layer name");
        long layerId = this.idCache.getLayerId(oldLayerName);
        try {
            this.wrpr.renameLayer(layerId, newLayerName);
            this.idCache.clear();
            return true;
        }
        catch (SQLException se) {
            log.error((Object)("Failed to rename layer '" + oldLayerName + "' to '" + newLayerName + "'"), (Throwable)se);
            return false;
        }
    }

    public boolean delete(TileObject stObj) throws StorageException {
        stObj.setLayerId(this.idCache.getLayerId(stObj.getLayerName()));
        stObj.setFormatId(this.idCache.getFormatId(stObj.getBlobFormat()));
        long parametersId = this.idCache.getParametersId(stObj.getParameters());
        stObj.setParamtersId(parametersId);
        try {
            this.wrpr.deleteTile(stObj);
            return true;
        }
        catch (SQLException se) {
            log.error((Object)("Failed to get tile: " + se.getMessage()));
            return false;
        }
    }

    public boolean delete(BlobStore blobStore, TileRange trObj) throws StorageException {
        long layerId = this.idCache.getLayerId(trObj.getLayerName());
        long formatId = this.idCache.getFormatId(trObj.getMimeType().getFormat());
        long parametersId = -1L;
        if (trObj.getParametersId() != null) {
            parametersId = trObj.getParametersId();
        } else if (trObj.getParameters() != null && -1L != (parametersId = this.idCache.getParametersId(trObj.getParameters()))) {
            trObj.setParametersId(parametersId);
        }
        long gridSetIdId = this.idCache.getGridSetsId(trObj.getGridSetId());
        for (int zoomLevel = trObj.getZoomStart(); zoomLevel <= trObj.getZoomStop(); ++zoomLevel) {
            this.wrpr.deleteRange(blobStore, trObj, zoomLevel, layerId, formatId, parametersId, gridSetIdId);
        }
        return true;
    }

    @Deprecated
    public boolean expire(TileRange trObj) throws StorageException {
        return false;
    }

    public boolean get(TileObject stObj) throws StorageException {
        stObj.setLayerId(this.idCache.getLayerId(stObj.getLayerName()));
        stObj.setFormatId(this.idCache.getFormatId(stObj.getBlobFormat()));
        stObj.setGridSetIdId(this.idCache.getGridSetsId(stObj.getGridSetId()));
        stObj.setParamtersId(this.idCache.getParametersId(stObj.getParameters()));
        try {
            boolean response = this.wrpr.getTile(stObj);
            while (stObj.getStatus().equals((Object)StorageObject.Status.LOCK)) {
                try {
                    Thread.sleep(this.lockRetryDelay);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                response = this.wrpr.getTile(stObj);
            }
            return response;
        }
        catch (SQLException se) {
            log.error((Object)("Failed to get tile: " + se.getMessage()));
            return false;
        }
    }

    public void put(TileObject stObj) throws StorageException {
        stObj.setLayerId(this.idCache.getLayerId(stObj.getLayerName()));
        stObj.setFormatId(this.idCache.getFormatId(stObj.getBlobFormat()));
        stObj.setGridSetIdId(this.idCache.getGridSetsId(stObj.getGridSetId()));
        stObj.setParamtersId(this.idCache.getParametersId(stObj.getParameters()));
        try {
            this.wrpr.deleteTile(stObj);
        }
        catch (SQLException se) {
            log.error((Object)("Failed to delete tile: " + se.getMessage()));
        }
        try {
            this.wrpr.putTile(stObj);
        }
        catch (SQLException se) {
            log.error((Object)("Failed to put tile: " + se.getMessage()));
        }
    }

    public boolean unlock(TileObject stObj) throws StorageException {
        try {
            return this.wrpr.unlockTile(stObj);
        }
        catch (SQLException se) {
            log.error((Object)("Failed to unlock tile: " + se.getMessage()));
            return false;
        }
    }

    public void clear() throws StorageException {
        if (this.wrpr.driverClass.equals("org.h2.Driver")) {
            throw new StorageException("clear() has not been implemented for " + this.wrpr.driverClass);
        }
    }

    public void destroy() {
        if (this.wrpr != null) {
            this.wrpr.destroy();
        }
    }

    public void setLockTimeout(long lockTimeout) {
        this.wrpr.lockTimeout = lockTimeout;
    }

    public void setLockRetryDelay(long lockRetryDelay) {
        this.lockRetryDelay = lockRetryDelay;
    }
}

