/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage.blobstore.file;

import java.io.File;
import org.geowebcache.mime.MimeType;

public class FilePathGenerator {
    public static File tilePath(String prefix, String layerName, long[] tileIndex, String gridSetId, MimeType mimeType, long parameters_id) {
        long x = tileIndex[0];
        long y = tileIndex[1];
        long z = tileIndex[2];
        StringBuilder path = new StringBuilder(256);
        long shift = z / 2L;
        long half = 2 << (int)shift;
        int digits = 1;
        if (half > 10L) {
            digits = (int)Math.log10(half) + 1;
        }
        long halfx = x / half;
        long halfy = y / half;
        String fileExtension = mimeType.getFileExtension();
        path.append(prefix);
        path.append(File.separatorChar);
        FilePathGenerator.appendFiltered(layerName, path);
        path.append(File.separatorChar);
        FilePathGenerator.appendGridsetZoomLevelDir(gridSetId, z, path);
        if (parameters_id != -1L) {
            path.append('_');
            path.append(Long.toHexString(parameters_id));
        }
        path.append(File.separatorChar);
        FilePathGenerator.zeroPadder(halfx, digits, path);
        path.append('_');
        FilePathGenerator.zeroPadder(halfy, digits, path);
        path.append(File.separatorChar);
        FilePathGenerator.zeroPadder(x, 2 * digits, path);
        path.append('_');
        FilePathGenerator.zeroPadder(y, 2 * digits, path);
        path.append('.');
        path.append(fileExtension);
        File tileFile = new File(path.toString());
        return tileFile;
    }

    public static String gridsetZoomLevelDir(String gridSetId, long zoomLevel) {
        String gridSetStr = FilePathGenerator.filteredGridSetId(gridSetId);
        StringBuilder sb = new StringBuilder(gridSetStr);
        sb.append('_');
        FilePathGenerator.zeroPadder(zoomLevel, 2, sb);
        return sb.toString();
    }

    private static void appendGridsetZoomLevelDir(String gridSetId, long z, StringBuilder path) {
        FilePathGenerator.appendFiltered(gridSetId, path);
        path.append('_');
        FilePathGenerator.zeroPadder(z, 2, path);
    }

    public static String zeroPadder(long number, int order) {
        StringBuilder sb = new StringBuilder();
        FilePathGenerator.zeroPadder(number, order, sb);
        return sb.toString();
    }

    private static void zeroPadder(long number, int order, StringBuilder padding) {
        int diffOrder;
        int numberOrder = 1;
        if (number > 9L) {
            numberOrder = number > 11L ? (int)Math.ceil(Math.log10(number) - 0.001) : 2;
        }
        if ((diffOrder = order - numberOrder) > 0) {
            while (diffOrder > 0) {
                padding.append('0');
                --diffOrder;
            }
            padding.append(number);
        } else {
            padding.append(number);
        }
    }

    public static String filteredGridSetId(String gridSetId) {
        return gridSetId.replace(':', '_');
    }

    public static String filteredLayerName(String layerName) {
        return layerName.replace(':', '_').replace(' ', '_');
    }

    private static void appendFiltered(String str, StringBuilder path) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (':' == c || ' ' == c) {
                c = '_';
            }
            path.append(c);
        }
    }

    public static int findZoomLevel(String gridsetPrefix, String dirName) {
        assert (dirName.startsWith(gridsetPrefix + "_"));
        String[] parts = dirName.substring(gridsetPrefix.length() + 1).split("_");
        return Integer.parseInt(parts[0]);
    }
}

