/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage.blobstore.file;

import java.io.File;
import java.io.FilenameFilter;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.TileRange;
import org.geowebcache.storage.blobstore.file.FilePathGenerator;

public class FilePathFilter
implements FilenameFilter {
    private final String gridSetPrefix;
    private String mimeExtension;
    private TileRange tr;

    public FilePathFilter(TileRange trObj) throws StorageException {
        this.tr = trObj;
        if (this.tr.getGridSetId() == null) {
            throw new StorageException("Specifying the grid set id is currently mandatory.");
        }
        this.gridSetPrefix = FilePathGenerator.filteredGridSetId(this.tr.getGridSetId());
        if (this.tr.getMimeType() != null) {
            this.mimeExtension = this.tr.getMimeType().getFileExtension();
        }
    }

    public boolean accept(File parent, String fileName) {
        boolean ret = fileName.startsWith(this.gridSetPrefix) ? this.acceptZoomLevelDir(fileName) : (fileName.contains(".") ? this.acceptFileName(parent, fileName) : this.acceptIntermediateDir(fileName));
        return ret;
    }

    private boolean acceptZoomLevelDir(String name) {
        if (!name.startsWith(this.gridSetPrefix)) {
            return false;
        }
        if (this.tr.getZoomStart() == -1 && this.tr.getZoomStop() == -1) {
            return true;
        }
        int tmp = FilePathGenerator.findZoomLevel(this.gridSetPrefix, name);
        return tmp >= this.tr.getZoomStart() && tmp <= this.tr.getZoomStop();
    }

    private boolean acceptIntermediateDir(String name) {
        return true;
    }

    private boolean acceptFileName(File parent, String name) {
        String[] parts = name.split("\\.");
        if (!parts[parts.length - 1].equalsIgnoreCase(this.mimeExtension)) {
            return false;
        }
        String[] coords = parts[0].split("_");
        int zoomLevel = FilePathGenerator.findZoomLevel(this.gridSetPrefix, parent.getParentFile().getName());
        long x = Long.parseLong(coords[0]);
        long y = Long.parseLong(coords[1]);
        boolean contains = this.tr.contains(x, y, zoomLevel);
        return contains;
    }
}

