/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage.blobstore.file;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.channels.FileChannel;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.config.ConfigurationException;
import org.geowebcache.io.FileResource;
import org.geowebcache.io.Resource;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.geowebcache.storage.BlobStore;
import org.geowebcache.storage.BlobStoreListener;
import org.geowebcache.storage.BlobStoreListenerList;
import org.geowebcache.storage.DefaultStorageFinder;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.TileRange;
import org.geowebcache.storage.blobstore.file.FilePathFilter;
import org.geowebcache.storage.blobstore.file.FilePathGenerator;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public class FileBlobStore
implements BlobStore {
    private static Log log = LogFactory.getLog(FileBlobStore.class);
    public static final int BUFFER_SIZE = 32768;
    private final File stagingArea;
    private final String path;
    private final BlobStoreListenerList listeners = new BlobStoreListenerList();
    private static ExecutorService deleteExecutorService;

    public FileBlobStore(DefaultStorageFinder defStoreFinder) throws ConfigurationException {
        this.path = defStoreFinder.getDefaultPath();
        this.stagingArea = new File(this.path, "_gwc_in_progress_deletes_");
        this.createDeleteExecutorService();
        this.issuePendingDeletes();
    }

    public FileBlobStore(String rootPath) throws StorageException {
        this.path = rootPath;
        File fh = new File(this.path);
        if (!(fh.exists() && fh.isDirectory() && fh.canWrite())) {
            throw new StorageException(this.path + " is not writable directory.");
        }
        this.stagingArea = new File(this.path, "_gwc_in_progress_deletes_");
        this.createDeleteExecutorService();
        this.issuePendingDeletes();
    }

    private void issuePendingDeletes() {
        File[] pendings;
        if (!this.stagingArea.exists()) {
            return;
        }
        if (!this.stagingArea.isDirectory() || !this.stagingArea.canWrite()) {
            throw new IllegalStateException("Staging area is not writable or is not a directory: " + this.stagingArea.getAbsolutePath());
        }
        for (File directory : pendings = this.stagingArea.listFiles()) {
            if (!directory.isDirectory()) continue;
            this.deletePending(directory);
        }
    }

    private void deletePending(File pendingDeleteDirectory) {
        deleteExecutorService.submit(new DefferredDirectoryDeleteTask(pendingDeleteDirectory));
    }

    private void createDeleteExecutorService() {
        CustomizableThreadFactory tf = new CustomizableThreadFactory("GWC FileStore delete directory thread-");
        tf.setDaemon(true);
        tf.setThreadPriority(1);
        deleteExecutorService = Executors.newFixedThreadPool(1);
    }

    public void destroy() {
        deleteExecutorService.shutdownNow();
    }

    public boolean delete(String layerName) throws StorageException {
        File source = this.getLayerPath(layerName);
        String target = FilePathGenerator.filteredLayerName(layerName);
        boolean ret = this.stageDelete(source, target);
        this.listeners.sendLayerDeleted(layerName);
        return ret;
    }

    private boolean stageDelete(File source, String targetName) throws StorageException {
        if (!source.exists() || !source.canWrite()) {
            log.info((Object)(source + " does not exist or is not writable"));
            return false;
        }
        if (!this.stagingArea.exists() && !this.stagingArea.mkdirs()) {
            throw new StorageException("Can't create staging directory for deletes: " + this.stagingArea.getAbsolutePath());
        }
        File tmpFolder = new File(this.stagingArea, targetName);
        int tries = 0;
        while (tmpFolder.exists()) {
            String dirName = FilePathGenerator.filteredLayerName(targetName + "." + ++tries);
            tmpFolder = new File(this.stagingArea, dirName);
        }
        boolean renamed = source.renameTo(tmpFolder);
        if (!renamed) {
            throw new IllegalStateException("Can't rename " + source.getAbsolutePath() + " to " + tmpFolder.getAbsolutePath() + " for deletion");
        }
        this.deletePending(tmpFolder);
        return true;
    }

    public boolean deleteByGridsetId(String layerName, String gridSetId) throws StorageException {
        File[] gridSubsetCaches;
        File layerPath = this.getLayerPath(layerName);
        if (!layerPath.exists() || !layerPath.canWrite()) {
            log.info((Object)(layerPath + " does not exist or is not writable"));
            return false;
        }
        final String filteredGridSetId = FilePathGenerator.filteredGridSetId(gridSetId);
        for (File gridSubsetCache : gridSubsetCaches = layerPath.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                if (!pathname.isDirectory()) {
                    return false;
                }
                String dirName = pathname.getName();
                return dirName.startsWith(filteredGridSetId);
            }
        })) {
            String target = FilePathGenerator.filteredLayerName(layerName) + "_" + gridSubsetCache.getName();
            this.stageDelete(gridSubsetCache, target);
        }
        this.listeners.sendGridSubsetDeleted(layerName, gridSetId);
        return true;
    }

    public boolean rename(String oldLayerName, String newLayerName) throws StorageException {
        File oldLayerPath = this.getLayerPath(oldLayerName);
        File newLayerPath = this.getLayerPath(newLayerName);
        if (newLayerPath.exists()) {
            throw new StorageException("Can't rename layer directory " + oldLayerPath + " to " + newLayerPath + ". Target directory already exists");
        }
        if (!oldLayerPath.exists()) {
            this.listeners.sendLayerRenamed(oldLayerName, newLayerName);
            return true;
        }
        if (!oldLayerPath.canWrite()) {
            log.info((Object)(oldLayerPath + " is not writable"));
            return false;
        }
        boolean renamed = oldLayerPath.renameTo(newLayerPath);
        if (!renamed) {
            throw new StorageException("Couldn't rename layer directory " + oldLayerPath + " to " + newLayerPath);
        }
        this.listeners.sendLayerRenamed(oldLayerName, newLayerName);
        return renamed;
    }

    private File getLayerPath(String layerName) {
        String prefix = this.path + File.separator + FilePathGenerator.filteredLayerName(layerName);
        File layerPath = new File(prefix);
        return layerPath;
    }

    public boolean delete(TileObject stObj) throws StorageException {
        boolean exists;
        File fh = this.getFileHandleTile(stObj, false);
        boolean ret = false;
        long length = fh.length();
        boolean bl = exists = length > 0L;
        if (exists) {
            if (!fh.delete()) {
                throw new StorageException("Unable to delete " + fh.getAbsolutePath());
            }
            stObj.setBlobSize((int)length);
            this.listeners.sendTileDeleted(stObj);
            ret = true;
        } else {
            log.trace((Object)("delete unexistant file " + fh.toString()));
        }
        File parentDir = fh.getParentFile();
        parentDir.delete();
        return ret;
    }

    public boolean delete(TileRange trObj) throws StorageException {
        int count = 0;
        String prefix = this.path + File.separator + FilePathGenerator.filteredLayerName(trObj.getLayerName());
        File layerPath = new File(prefix);
        if (!layerPath.exists()) {
            return true;
        }
        if (!layerPath.isDirectory() || !layerPath.canWrite()) {
            throw new StorageException(prefix + " does is not a directory or is not writable.");
        }
        FilePathFilter tileFinder = new FilePathFilter(trObj);
        String layerName = trObj.getLayerName();
        String gridSetId = trObj.getGridSetId();
        String blobFormat = trObj.getMimeType().getFormat();
        Long parametersId = trObj.getParametersId();
        File[] srsZoomDirs = layerPath.listFiles(tileFinder);
        String gridsetPrefix = FilePathGenerator.filteredGridSetId(gridSetId);
        for (File srsZoomParamId : srsZoomDirs) {
            File[] intermediates;
            int zoomLevel = FilePathGenerator.findZoomLevel(gridsetPrefix, srsZoomParamId.getName());
            for (File imd : intermediates = srsZoomParamId.listFiles(tileFinder)) {
                File[] tiles;
                for (File tile : tiles = imd.listFiles(tileFinder)) {
                    long length = tile.length();
                    boolean deleted = tile.delete();
                    if (!deleted) continue;
                    String[] coords = tile.getName().split("\\.")[0].split("_");
                    long x = Long.parseLong(coords[0]);
                    long y = Long.parseLong(coords[1]);
                    this.listeners.sendTileDeleted(layerName, gridSetId, blobFormat, parametersId, x, y, zoomLevel, length);
                    ++count;
                }
                if (!imd.delete()) continue;
            }
            if (!srsZoomParamId.delete()) continue;
            ++count;
        }
        log.info((Object)("Truncated " + count + " tiles"));
        return true;
    }

    public Resource get(TileObject stObj) throws StorageException {
        File fh = this.getFileHandleTile(stObj, false);
        Resource resource = this.readFile(fh);
        if (null != resource && 0L == stObj.getCreated()) {
            stObj.setCreated(resource.getLastModified());
        }
        return resource;
    }

    public void put(TileObject stObj) throws StorageException {
        File fh = this.getFileHandleTile(stObj, true);
        long oldSize = fh.length();
        boolean existed = oldSize > 0L;
        this.writeFile(fh, stObj.getBlob());
        stObj.setCreated(fh.lastModified());
        if (existed) {
            this.listeners.sendTileUpdated(stObj, oldSize);
        } else {
            this.listeners.sendTileStored(stObj);
        }
    }

    private File getFileHandleTile(TileObject stObj, boolean create) {
        MimeType mimeType;
        try {
            mimeType = MimeType.createFromFormat(stObj.getBlobFormat());
        }
        catch (MimeException me) {
            log.error((Object)me.getMessage());
            throw new RuntimeException(me);
        }
        String layerName = stObj.getLayerName();
        long[] xyz = stObj.getXYZ();
        String gridSetId = stObj.getGridSetId();
        long parametersId = stObj.getParametersId();
        File tilePath = FilePathGenerator.tilePath(this.path, layerName, xyz, gridSetId, mimeType, parametersId);
        if (create) {
            File parent = tilePath.getParentFile();
            this.mkdirs(parent, stObj);
        }
        return tilePath;
    }

    private Resource readFile(File fh) throws StorageException {
        if (!fh.exists()) {
            return null;
        }
        return new FileResource(fh);
    }

    private void writeFile(File target, Resource source) throws StorageException {
        FileOutputStream fos;
        try {
            fos = new FileOutputStream(target);
        }
        catch (FileNotFoundException ioe) {
            throw new StorageException(ioe.getMessage() + " for " + target.getAbsolutePath());
        }
        FileChannel channel = fos.getChannel();
        try {
            source.transferTo(channel);
        }
        catch (IOException ioe) {
            throw new StorageException(ioe.getMessage() + " for " + target.getAbsolutePath());
        }
        finally {
            try {
                channel.close();
            }
            catch (IOException ioe) {
                throw new StorageException(ioe.getMessage() + " for " + target.getAbsolutePath());
            }
        }
    }

    public void clear() throws StorageException {
        throw new StorageException("Not implemented yet!");
    }

    public void addListener(BlobStoreListener listener) {
        this.listeners.addListener(listener);
    }

    public boolean removeListener(BlobStoreListener listener) {
        return this.listeners.removeListener(listener);
    }

    private boolean mkdirs(File path, TileObject stObj) {
        if (path.exists()) {
            return false;
        }
        if (path.mkdir()) {
            return true;
        }
        String parentDir = path.getParent();
        if (parentDir == null) {
            return false;
        }
        this.mkdirs(new File(parentDir), stObj);
        return path.mkdir();
    }

    public String getLayerMetadata(String layerName, String key) {
        Properties metadata = this.getLayerMetadata(layerName);
        String value = metadata.getProperty(key);
        if (value != null) {
            try {
                value = URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putLayerMetadata(String layerName, String key, String value) {
        String lockObj;
        Properties metadata = this.getLayerMetadata(layerName);
        if (null == value) {
            metadata.remove(key);
        } else {
            try {
                metadata.setProperty(key, URLEncoder.encode(value, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        File metadataFile = this.getMetadataFile(layerName);
        String string = lockObj = metadataFile.getAbsolutePath().intern();
        synchronized (string) {
            FileOutputStream out;
            try {
                if (!metadataFile.getParentFile().exists()) {
                    metadataFile.getParentFile().mkdirs();
                }
                out = new FileOutputStream(metadataFile);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
            try {
                String comments = "auto generated file, do not edit by hand";
                metadata.store(out, comments);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException e) {
                    log.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getLayerMetadata(String layerName) {
        String lockObj;
        File metadataFile = this.getMetadataFile(layerName);
        Properties properties = new Properties();
        String string = lockObj = metadataFile.getAbsolutePath().intern();
        synchronized (string) {
            if (metadataFile.exists()) {
                FileInputStream in;
                try {
                    in = new FileInputStream(metadataFile);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
                try {
                    properties.load(in);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        log.warn((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        return properties;
    }

    private File getMetadataFile(String layerName) {
        File layerPath = this.getLayerPath(layerName);
        File metadataFile = new File(layerPath, "metadata.properties");
        return metadataFile;
    }

    private static class DefferredDirectoryDeleteTask
    implements Runnable {
        private final File directory;

        public DefferredDirectoryDeleteTask(File directory) {
            this.directory = directory;
        }

        public void run() {
            try {
                this.deleteDirectory(this.directory);
            }
            catch (IOException e) {
                log.warn((Object)("Exception occurred while deleting '" + this.directory.getAbsolutePath() + "'"), (Throwable)e);
            }
            catch (InterruptedException e) {
                log.info((Object)("FileStore delete background service interrupted while deleting '" + this.directory.getAbsolutePath() + "'. Process will be resumed at next start up"));
            }
        }

        private void deleteDirectory(File directory) throws IOException, InterruptedException {
            if (!directory.exists()) {
                return;
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            File[] files = directory.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                File file = files[i];
                if (file.isDirectory()) {
                    this.deleteDirectory(file);
                    continue;
                }
                if (file.delete()) continue;
                throw new IOException("Unable to delete " + file.getAbsolutePath());
            }
            if (!directory.delete()) {
                String message = "Unable to delete directory " + directory + ".";
                throw new IOException(message);
            }
        }
    }
}

