/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.geowebcache.io.ByteArrayResource;
import org.geowebcache.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransientCache {
    private final int maxTiles;
    private final int maxStorage;
    private long currentStorage;
    private Map<String, Resource> cache = new LinkedHashMap<String, Resource>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Resource> eldest) {
            return TransientCache.this.removeEntries(eldest);
        }
    };

    public TransientCache(int maxTiles, int maxStorageKB) {
        this.maxTiles = maxTiles;
        this.maxStorage = maxStorageKB * 1024;
    }

    public int size() {
        return this.cache.size();
    }

    public long storageSize() {
        return this.currentStorage;
    }

    public void put(String key, Resource r) {
        byte[] buf = new byte[(int)r.getSize()];
        try {
            r.getInputStream().read(buf);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        ByteArrayResource blob = new ByteArrayResource(buf);
        this.currentStorage += r.getSize();
        this.cache.put(key, blob);
    }

    public Resource get(String key) {
        Resource cached = this.cache.get(key);
        if (cached != null) {
            this.cache.remove(key);
            this.currentStorage -= cached.getSize();
        }
        return cached;
    }

    private void clean() {
        Resource r;
        Iterator<Resource> items = this.cache.values().iterator();
        long storage = this.currentStorage;
        while (items.hasNext() && (storage -= (r = items.next()).getSize()) >= (long)this.maxStorage) {
            items.remove();
        }
        this.currentStorage = storage;
    }

    private boolean removeEntries(Map.Entry<String, Resource> eldest) {
        boolean remove = false;
        if (this.currentStorage > (long)this.maxStorage) {
            this.clean();
        } else if (this.cache.size() > this.maxTiles) {
            remove = true;
        }
        return remove;
    }
}

