/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage;

import java.util.concurrent.atomic.AtomicLong;
import org.geowebcache.storage.DiscontinuousTileRange;
import org.geowebcache.storage.TileRange;

public class TileRangeIterator {
    private final TileRange tr;
    private final DiscontinuousTileRange dtr;
    private final int metaX;
    private final int metaY;
    private AtomicLong tilesSkippedCount = new AtomicLong();
    private AtomicLong tilesRenderedCount = new AtomicLong();
    private volatile long[] lastGridLoc;

    public TileRangeIterator(TileRange tr, int[] metaTilingFactors) {
        this.tr = tr;
        this.metaX = metaTilingFactors[0];
        this.metaY = metaTilingFactors[1];
        this.dtr = tr instanceof DiscontinuousTileRange ? (DiscontinuousTileRange)tr : null;
    }

    public TileRange getTileRange() {
        return this.tr;
    }

    public synchronized long[] nextMetaGridLocation(long[] gridLoc) {
        long y;
        long x;
        long[] levelBounds;
        int z;
        if (this.lastGridLoc == null) {
            z = this.tr.getZoomStart();
            levelBounds = this.tr.rangeBounds(z);
            x = levelBounds[0];
            y = levelBounds[1];
        } else {
            z = (int)this.lastGridLoc[2];
            levelBounds = this.tr.rangeBounds(z);
            x = this.lastGridLoc[0] + (long)this.metaX;
            y = this.lastGridLoc[1];
        }
        while (z <= this.tr.getZoomStop()) {
            while (y <= levelBounds[3]) {
                while (x <= levelBounds[2]) {
                    gridLoc[0] = x;
                    gridLoc[1] = y;
                    gridLoc[2] = z;
                    int tileCount = this.tilesForLocation(gridLoc, levelBounds);
                    if (this.checkGridLocation(gridLoc)) {
                        this.tilesRenderedCount.addAndGet(tileCount);
                        this.lastGridLoc = (long[])gridLoc.clone();
                        return gridLoc;
                    }
                    this.tilesSkippedCount.addAndGet(tileCount);
                    x += (long)this.metaX;
                }
                x = levelBounds[0];
                y += (long)this.metaY;
            }
            if (z < this.tr.getZoomStop()) {
                levelBounds = this.tr.rangeBounds(z + 1);
                x = levelBounds[0];
                y = levelBounds[1];
            }
            ++z;
        }
        return null;
    }

    private int tilesForLocation(long x, long y, long[] levelBounds) {
        long boundsMaxX = levelBounds[2];
        long boundsMaxY = levelBounds[3];
        return (int)Math.min((long)this.metaX, 1L + (boundsMaxX - x)) * (int)Math.min((long)this.metaY, 1L + (boundsMaxY - y));
    }

    private int tilesForLocation(long[] gridLoc, long[] levelBounds) {
        return this.tilesForLocation(gridLoc[0], gridLoc[1], levelBounds);
    }

    private boolean checkGridLocation(long[] gridLoc) {
        if (this.dtr == null) {
            return true;
        }
        long[] subIdx = new long[3];
        subIdx[2] = gridLoc[2];
        for (int i = 0; i < this.metaX; ++i) {
            for (int j = 0; j < this.metaY; ++j) {
                subIdx[0] = gridLoc[0] + (long)i;
                subIdx[1] = gridLoc[1] + (long)j;
                if (!this.dtr.contains(subIdx)) continue;
                return true;
            }
        }
        return false;
    }
}

