/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.io.Resource;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.geowebcache.storage.BlobStore;
import org.geowebcache.storage.BlobStoreListener;
import org.geowebcache.storage.DiscontinuousTileRange;
import org.geowebcache.storage.MetaStore;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.TileRange;
import org.geowebcache.storage.TransientCache;
import org.geowebcache.storage.blobstore.file.FilePathGenerator;

public class StorageBroker {
    private static Log log = LogFactory.getLog(StorageBroker.class);
    private BlobStore blobStore;
    private MetaStore metaStore;
    private boolean metaStoreEnabled = true;
    private boolean verifyFileSize = false;
    private TransientCache transientCache;

    public StorageBroker(MetaStore metaStore, BlobStore blobStore) {
        this.metaStore = metaStore;
        this.blobStore = blobStore;
        this.metaStoreEnabled = metaStore != null ? metaStore.enabled() : false;
        this.transientCache = new TransientCache(100, 1000);
    }

    public void addBlobStoreListener(BlobStoreListener listener) {
        this.blobStore.addListener(listener);
    }

    public boolean removeBlobStoreListener(BlobStoreListener listener) {
        return this.blobStore.removeListener(listener);
    }

    public void setVerifyFileSize(boolean verifyFileSize) {
        this.verifyFileSize = verifyFileSize;
    }

    public boolean delete(String layerName) throws StorageException {
        boolean ret = true;
        if (this.metaStoreEnabled) {
            ret = this.metaStore.delete(layerName);
        }
        ret = ret && this.blobStore.delete(layerName);
        return ret;
    }

    public boolean deleteByGridSetId(String layerName, String gridSetId) throws StorageException {
        boolean ret = true;
        if (this.metaStoreEnabled) {
            ret = this.metaStore.deleteByGridsetId(layerName, gridSetId);
        }
        ret = ret && this.blobStore.deleteByGridsetId(layerName, gridSetId);
        return ret;
    }

    public boolean rename(String oldLayerName, String newLayerName) throws StorageException {
        boolean ret = true;
        if (this.metaStoreEnabled) {
            ret = this.metaStore.rename(oldLayerName, newLayerName);
        }
        ret = ret && this.blobStore.rename(oldLayerName, newLayerName);
        return ret;
    }

    public boolean delete(TileRange trObj) throws StorageException {
        boolean deleted;
        if (this.metaStoreEnabled) {
            deleted = this.metaStore.delete(this.blobStore, trObj);
        } else {
            if (trObj instanceof DiscontinuousTileRange) {
                throw new StorageException("DiscontinuousTileRange currently requries a metastore.");
            }
            deleted = this.blobStore.delete(trObj);
        }
        return deleted;
    }

    @Deprecated
    public boolean expire(TileRange trObj) throws StorageException {
        return false;
    }

    public boolean get(TileObject tileObj) throws StorageException {
        if (!this.metaStoreEnabled) {
            boolean found = this.getBlobOnly(tileObj);
            return found;
        }
        if (!this.metaStore.get(tileObj)) {
            return false;
        }
        if (tileObj.getId() == -1L) {
            throw new StorageException("metaStore.get() returned true, but did not set an id on the object");
        }
        if (tileObj.blob_size > 0) {
            Resource blob = this.blobStore.get(tileObj);
            if (blob == null) {
                throw new StorageException("Blob for " + Arrays.toString(tileObj.xyz) + " was expected to have size " + tileObj.blob_size + " but was null.");
            }
            if (this.verifyFileSize && blob.getSize() != (long)tileObj.blob_size) {
                throw new StorageException("Blob was expected to have size " + tileObj.blob_size + " but was " + blob.getSize());
            }
            tileObj.blob = blob;
            return true;
        }
        return false;
    }

    private boolean getBlobOnly(TileObject tileObj) throws StorageException {
        if (tileObj.getParameters() == null || tileObj.getParameters().size() == 0) {
            Resource blob = this.blobStore.get(tileObj);
            if (blob == null) {
                return false;
            }
            tileObj.blob = blob;
            return true;
        }
        log.error((Object)"Cannot fetch tile with parameters if metastore is disabled!");
        return false;
    }

    public boolean put(TileObject tileObj) throws StorageException {
        if (!this.metaStoreEnabled) {
            boolean stored = this.putBlobOnly(tileObj);
            return stored;
        }
        try {
            this.metaStore.put(tileObj);
            this.blobStore.put(tileObj);
            this.metaStore.unlock(tileObj);
            return true;
        }
        catch (StorageException se) {
            log.error((Object)se.getMessage());
            return false;
        }
    }

    private boolean putBlobOnly(TileObject tileObj) {
        if (tileObj.getParameters() == null || tileObj.getParameters().size() == 0) {
            try {
                this.blobStore.put(tileObj);
            }
            catch (StorageException se) {
                log.error((Object)("Unable to save tile: " + se.getMessage()));
                return false;
            }
            return true;
        }
        log.debug((Object)"Cannot save tile with parameters if metastore is disabled!");
        return false;
    }

    public void destroy() {
        log.info((Object)"Destroying StorageBroker");
    }

    public String getLayerMetadata(String layerName, String key) {
        return this.blobStore.getLayerMetadata(layerName, key);
    }

    public void putLayerMetadata(String layerName, String key, String value) {
        this.blobStore.putLayerMetadata(layerName, key, value);
    }

    public static String computeTransientKey(TileObject tile) {
        try {
            MimeType mime = MimeType.createFromFormat(tile.getBlobFormat());
            return FilePathGenerator.tilePath("", tile.getLayerName(), tile.getXYZ(), tile.getGridSetId(), mime, tile.getParametersId()).getAbsolutePath();
        }
        catch (MimeException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getTransient(TileObject tile) {
        Resource resource;
        String key = StorageBroker.computeTransientKey(tile);
        TransientCache transientCache = this.transientCache;
        synchronized (transientCache) {
            resource = this.transientCache.get(key);
        }
        tile.setBlob(resource);
        return resource != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putTransient(TileObject tile) {
        String key = StorageBroker.computeTransientKey(tile);
        TransientCache transientCache = this.transientCache;
        synchronized (transientCache) {
            this.transientCache.put(key, tile.getBlob());
        }
    }
}

