/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.seed;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.filter.request.RequestFilter;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.seed.GWCTask;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.storage.TileRange;

class TruncateTask
extends GWCTask {
    private static Log log = LogFactory.getLog(TruncateTask.class);
    private final TileRange tr;
    private final TileLayer tl;
    private final boolean doFilterUpdate;
    private final StorageBroker storageBroker;

    public TruncateTask(StorageBroker sb, TileRange tr, TileLayer tl, boolean doFilterUpdate) {
        this.storageBroker = sb;
        this.tr = tr;
        this.tl = tl;
        this.doFilterUpdate = doFilterUpdate;
        this.parsedType = GWCTask.TYPE.TRUNCATE;
        this.layerName = tl.getName();
    }

    protected void doActionInternal() throws GeoWebCacheException, InterruptedException {
        this.state = GWCTask.STATE.RUNNING;
        this.checkInterrupted();
        try {
            this.storageBroker.delete(this.tr);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.state = GWCTask.STATE.DEAD;
            log.error((Object)("During truncate request: " + e.getMessage()));
        }
        this.checkInterrupted();
        if (this.doFilterUpdate) {
            this.runFilterUpdates();
        }
        if (this.state != GWCTask.STATE.DEAD) {
            this.state = GWCTask.STATE.DONE;
            log.debug((Object)"Completed truncate request.");
        }
    }

    private void runFilterUpdates() {
        List<RequestFilter> reqFilters = this.tl.getRequestFilters();
        if (reqFilters != null && !reqFilters.isEmpty()) {
            for (RequestFilter reqFilter : reqFilters) {
                if (reqFilter.update(this.tl, this.tr.getGridSetId())) {
                    log.debug((Object)("Updated request filter " + reqFilter.getName()));
                    continue;
                }
                log.debug((Object)("Request filter " + reqFilter.getName() + " returned false on update."));
            }
        }
    }

    protected void dispose() {
    }
}

