/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.seed;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.SRS;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.geowebcache.seed.GWCTask;
import org.geowebcache.seed.MTSeeder;
import org.geowebcache.seed.SeedRequest;
import org.geowebcache.seed.SeedTask;
import org.geowebcache.seed.SeederThreadPoolExecutor;
import org.geowebcache.seed.TruncateTask;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.storage.TileRange;
import org.geowebcache.storage.TileRangeIterator;
import org.geowebcache.util.GWCVars;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TileBreeder
implements ApplicationContextAware {
    private static final String GWC_SEED_ABORT_LIMIT = "GWC_SEED_ABORT_LIMIT";
    private static final String GWC_SEED_RETRY_WAIT = "GWC_SEED_RETRY_WAIT";
    private static final String GWC_SEED_RETRY_COUNT = "GWC_SEED_RETRY_COUNT";
    private static Log log = LogFactory.getLog(TileBreeder.class);
    private ThreadPoolExecutor threadPool;
    private TileLayerDispatcher layerDispatcher;
    private StorageBroker storageBroker;
    private int tileFailureRetryCount = 0;
    private long tileFailureRetryWaitTime = 100L;
    private long totalFailuresBeforeAborting = 1000L;
    private Map<Long, SubmittedTask> currentPool = new TreeMap<Long, SubmittedTask>();
    private AtomicLong currentId = new AtomicLong();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        String retryCount = GWCVars.findEnvVar(applicationContext, GWC_SEED_RETRY_COUNT);
        String retryWait = GWCVars.findEnvVar(applicationContext, GWC_SEED_RETRY_WAIT);
        String abortLimit = GWCVars.findEnvVar(applicationContext, GWC_SEED_ABORT_LIMIT);
        this.tileFailureRetryCount = (int)this.toLong(GWC_SEED_RETRY_COUNT, retryCount, 0L);
        this.tileFailureRetryWaitTime = this.toLong(GWC_SEED_RETRY_WAIT, retryWait, 100L);
        this.totalFailuresBeforeAborting = this.toLong(GWC_SEED_ABORT_LIMIT, abortLimit, 1000L);
        this.checkPositive(this.tileFailureRetryCount, GWC_SEED_RETRY_COUNT);
        this.checkPositive(this.tileFailureRetryWaitTime, GWC_SEED_RETRY_WAIT);
        this.checkPositive(this.totalFailuresBeforeAborting, GWC_SEED_ABORT_LIMIT);
    }

    private void checkPositive(long value, String variable) {
        if (value < 0L) {
            throw new BeanInitializationException("Invalid configuration value for environment variable " + variable + ". It should be a positive integer."){};
        }
    }

    private long toLong(String varName, String paramVal, long defaultVal) {
        if (paramVal == null) {
            return defaultVal;
        }
        try {
            return Long.valueOf(paramVal);
        }
        catch (NumberFormatException e) {
            log.warn((Object)("Invalid environment parameter for " + varName + ": '" + paramVal + "'. Using default value: " + defaultVal));
            return defaultVal;
        }
    }

    public void seed(String layerName, SeedRequest sr) throws GeoWebCacheException {
        TileLayer tl = this.findTileLayer(layerName);
        TileRange tr = TileBreeder.createTileRange(sr, tl);
        GWCTask[] tasks = this.createTasks(tr, tl, sr.getType(), sr.getThreadCount(), sr.getFilterUpdate());
        this.dispatchTasks(tasks);
    }

    public GWCTask[] createTasks(TileRange tr, GWCTask.TYPE type, int threadCount, boolean filterUpdate) throws GeoWebCacheException {
        String layerName = tr.getLayerName();
        TileLayer tileLayer = this.layerDispatcher.getTileLayer(layerName);
        return this.createTasks(tr, tileLayer, type, threadCount, filterUpdate);
    }

    public GWCTask[] createTasks(TileRange tr, TileLayer tl, GWCTask.TYPE type, int threadCount, boolean filterUpdate) throws GeoWebCacheException {
        if (type == GWCTask.TYPE.TRUNCATE || threadCount < 1) {
            log.trace((Object)"Forcing thread count to 1");
            threadCount = 1;
        }
        TileRangeIterator trIter = new TileRangeIterator(tr, tl.getMetaTilingFactors());
        GWCTask[] tasks = new GWCTask[threadCount];
        AtomicLong failureCounter = new AtomicLong();
        AtomicInteger sharedThreadCount = new AtomicInteger();
        for (int i = 0; i < threadCount; ++i) {
            if (type == GWCTask.TYPE.TRUNCATE) {
                tasks[i] = this.createTruncateTask(trIter, tl, filterUpdate);
            } else {
                SeedTask task = (SeedTask)this.createSeedTask(type, trIter, tl, filterUpdate);
                task.setFailurePolicy(this.tileFailureRetryCount, this.tileFailureRetryWaitTime, this.totalFailuresBeforeAborting, failureCounter);
                tasks[i] = task;
            }
            tasks[i].setThreadInfo(sharedThreadCount, i);
        }
        return tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchTasks(GWCTask[] tasks) {
        this.lock.writeLock().lock();
        try {
            for (int i = 0; i < tasks.length; ++i) {
                Long taskId = this.currentId.incrementAndGet();
                GWCTask task = tasks[i];
                task.setTaskId(taskId);
                Future<GWCTask> future = this.threadPool.submit(new MTSeeder(task));
                this.currentPool.put(taskId, new SubmittedTask(task, future));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public static TileRange createTileRange(SeedRequest req, TileLayer tl) throws GeoWebCacheException {
        GridSubset gridSubset;
        SRS srs;
        List<GridSubset> crsMatches;
        int zoomStart = req.getZoomStart();
        int zoomStop = req.getZoomStop();
        MimeType mimeType = null;
        String format = req.getMimeFormat();
        if (format == null) {
            mimeType = tl.getMimeTypes().get(0);
        } else {
            try {
                mimeType = MimeType.createFromFormat(format);
            }
            catch (MimeException e4) {
                e4.printStackTrace();
            }
        }
        String gridSetId = req.getGridSetId();
        if (gridSetId == null && !(crsMatches = tl.getGridSubsetsForSRS(srs = req.getSRS())).isEmpty()) {
            if (crsMatches.size() == 1) {
                gridSetId = crsMatches.get(0).getName();
            } else {
                throw new IllegalArgumentException("More than one GridSubet matches the requested SRS " + srs + ". gridSetId must be specified");
            }
        }
        if (gridSetId == null) {
            gridSetId = tl.getGridSubsets().iterator().next();
        }
        if ((gridSubset = tl.getGridSubset(gridSetId)) == null) {
            throw new GeoWebCacheException("Unknown grid set " + gridSetId);
        }
        BoundingBox bounds = req.getBounds();
        long[][] coveredGridLevels = bounds == null ? gridSubset.getCoverages() : gridSubset.getCoverageIntersections(bounds);
        int[] metaTilingFactors = tl.getMetaTilingFactors();
        coveredGridLevels = gridSubset.expandToMetaFactors(coveredGridLevels, metaTilingFactors);
        String layerName = tl.getName();
        Map<String, String> parameters = req.getParameters();
        return new TileRange(layerName, gridSetId, zoomStart, zoomStop, coveredGridLevels, mimeType, parameters);
    }

    private GWCTask createSeedTask(GWCTask.TYPE type, TileRangeIterator trIter, TileLayer tl, boolean doFilterUpdate) throws IllegalArgumentException {
        switch (type) {
            case SEED: {
                return new SeedTask(this.storageBroker, trIter, tl, false, doFilterUpdate);
            }
            case RESEED: {
                return new SeedTask(this.storageBroker, trIter, tl, true, doFilterUpdate);
            }
        }
        throw new IllegalArgumentException("Unknown request type " + (Object)((Object)type));
    }

    private GWCTask createTruncateTask(TileRangeIterator trIter, TileLayer tl, boolean doFilterUpdate) {
        return new TruncateTask(this.storageBroker, trIter.getTileRange(), tl, doFilterUpdate);
    }

    public long[][] getStatusList() {
        return this.getStatusList(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[][] getStatusList(String layerName) {
        ArrayList<long[]> list = new ArrayList<long[]>(this.currentPool.size());
        this.lock.readLock().lock();
        try {
            for (Map.Entry<Long, SubmittedTask> entry : this.currentPool.entrySet()) {
                GWCTask task = entry.getValue().task;
                if (layerName != null && !layerName.equals(task.getLayerName())) continue;
                long[] ret = new long[]{task.getTilesDone(), task.getTilesTotal(), task.getTimeRemaining(), task.getTaskId(), this.stateCode(task.getState())};
                list.add(ret);
            }
        }
        finally {
            this.lock.readLock().unlock();
            this.drain();
        }
        long[][] ret = (long[][])list.toArray((T[])new long[list.size()][]);
        return ret;
    }

    private long stateCode(GWCTask.STATE state) {
        switch (state) {
            case UNSET: 
            case READY: {
                return 0L;
            }
            case RUNNING: {
                return 1L;
            }
            case DONE: {
                return 2L;
            }
            case DEAD: {
                return -1L;
            }
        }
        throw new IllegalArgumentException("Unknown state: " + (Object)((Object)state));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drain() {
        this.lock.writeLock().lock();
        try {
            this.threadPool.purge();
            Iterator<Map.Entry<Long, SubmittedTask>> it = this.currentPool.entrySet().iterator();
            while (it.hasNext()) {
                if (!it.next().getValue().future.isDone()) continue;
                it.remove();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void setTileLayerDispatcher(TileLayerDispatcher tileLayerDispatcher) {
        this.layerDispatcher = tileLayerDispatcher;
    }

    public void setThreadPoolExecutor(SeederThreadPoolExecutor stpe) {
        this.threadPool = stpe;
    }

    public void setStorageBroker(StorageBroker sb) {
        this.storageBroker = sb;
    }

    public StorageBroker getStorageBroker() {
        return this.storageBroker;
    }

    public TileLayer findTileLayer(String layerName) throws GeoWebCacheException {
        TileLayer layer = null;
        layer = this.layerDispatcher.getTileLayer(layerName);
        if (layer == null) {
            throw new GeoWebCacheException("Uknown layer: " + layerName);
        }
        return layer;
    }

    public Iterator<GWCTask> getRunningTasks() {
        this.drain();
        return this.filterTasks(GWCTask.STATE.RUNNING);
    }

    public Iterator<GWCTask> getRunningAndPendingTasks() {
        this.drain();
        return this.filterTasks(GWCTask.STATE.READY, GWCTask.STATE.UNSET, GWCTask.STATE.RUNNING);
    }

    public Iterator<GWCTask> getPendingTasks() {
        this.drain();
        return this.filterTasks(GWCTask.STATE.READY, GWCTask.STATE.UNSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator<GWCTask> filterTasks(GWCTask.STATE ... filter) {
        HashSet<GWCTask.STATE> states = new HashSet<GWCTask.STATE>(Arrays.asList(filter));
        this.lock.readLock().lock();
        ArrayList<GWCTask> runningTasks = new ArrayList<GWCTask>(this.currentPool.size());
        try {
            Collection<SubmittedTask> values = this.currentPool.values();
            for (SubmittedTask t : values) {
                GWCTask task = t.task;
                if (!states.contains((Object)task.getState())) continue;
                runningTasks.add(task);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return runningTasks.iterator();
    }

    public boolean terminateGWCTask(long id) {
        SubmittedTask submittedTask = this.currentPool.remove(id);
        if (submittedTask == null) {
            return false;
        }
        submittedTask.task.terminateNicely();
        return true;
    }

    public Iterable<TileLayer> getLayers() {
        return this.layerDispatcher.getLayerList();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SubmittedTask {
        public final GWCTask task;
        public final Future<GWCTask> future;

        public SubmittedTask(GWCTask task, Future<GWCTask> future) {
            this.task = task;
            this.future = future;
        }
    }
}

