/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.seed;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public class SeederThreadPoolExecutor
extends ThreadPoolExecutor
implements DisposableBean {
    private static final Log log = LogFactory.getLog(SeederThreadPoolExecutor.class);
    private static final ThreadFactory tf = new CustomizableThreadFactory("GWC Seeder Thread-");

    public SeederThreadPoolExecutor(int corePoolSize, int maxPoolSize) {
        super(corePoolSize, maxPoolSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), tf);
    }

    public void destroy() throws Exception {
        log.info((Object)"Initiating shut down for running and pending seed tasks...");
        this.shutdownNow();
        while (!this.isTerminated()) {
            log.debug((Object)"Waiting for pending tasks to terminate....");
            Thread.sleep(500L);
        }
        log.info((Object)"Seeder thread pool executor shut down complete.");
    }
}

