/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.layer;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerListener;

public class LayerListenerList {
    private List<TileLayerListener> listeners = new CopyOnWriteArrayList<TileLayerListener>();

    public synchronized void addListener(TileLayerListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public synchronized boolean removeListener(TileLayerListener listener) {
        return this.listeners.remove(listener);
    }

    public void sendTileRequested(TileLayer layer, ConveyorTile tile) {
        if (this.listeners.size() > 0) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).tileRequested(layer, tile);
            }
        }
    }
}

