/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.grid;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetFactory;
import org.geowebcache.grid.SRS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridSetBroker {
    private static Log log = LogFactory.getLog(GridSetBroker.class);
    public final GridSet WORLD_EPSG4326;
    public final GridSet WORLD_EPSG3857;
    private Map<String, GridSet> gridSets = new HashMap<String, GridSet>();
    private Set<String> embeddedGridSets;

    public GridSetBroker(boolean useEPSG900913, boolean useGWC11xNames) {
        String unprojectedName = "GlobalCRS84Geometric";
        String mercatorName = "GoogleMapsCompatible";
        if (useGWC11xNames) {
            unprojectedName = "EPSG:4326";
            mercatorName = useEPSG900913 ? "EPSG:900913" : "EPSG:3857";
        }
        log.debug((Object)("Adding " + unprojectedName));
        this.WORLD_EPSG4326 = GridSetFactory.createGridSet(unprojectedName, SRS.getEPSG4326(), BoundingBox.WORLD4326, false, GridSetFactory.DEFAULT_LEVELS, null, 2.8E-4, 256, 256, true);
        this.WORLD_EPSG4326.setDescription("A default WGS84 tile matrix set where the first zoom level covers the world with two tiles on the horizonal axis and one tile over the vertical axis and each subsequent zoom level is calculated by half the resolution of its previous one.");
        this.gridSets.put(this.WORLD_EPSG4326.getName(), this.WORLD_EPSG4326);
        SRS googleMapsCompatibleSRS = useEPSG900913 ? SRS.getEPSG900913() : SRS.getEPSG3857();
        log.debug((Object)("Adding " + googleMapsCompatibleSRS + " grid set for Spherical Mercator / GoogleMapsCompatible"));
        this.WORLD_EPSG3857 = GridSetFactory.createGridSet(mercatorName, googleMapsCompatibleSRS, BoundingBox.WORLD3857, false, this.commonPractice900913Resolutions(), null, 1.0, 2.8E-4, null, 256, 256, false);
        this.WORLD_EPSG3857.setDescription("This well-known scale set has been defined to be compatible with Google Maps and Microsoft Live Map projections and zoom levels. Level 0 allows representing the whole world in a single 256x256 pixels. The next level represents the whole world in 2x2 tiles of 256x256 pixels and so on in powers of 2. Scale denominator is only accurate near the equator.");
        this.gridSets.put(this.WORLD_EPSG3857.getName(), this.WORLD_EPSG3857);
        log.debug((Object)"Adding GlobalCRS84Pixel");
        GridSet GlobalCRS84Pixel = GridSetFactory.createGridSet("GlobalCRS84Pixel", SRS.getEPSG4326(), BoundingBox.WORLD4326, true, this.scalesCRS84PixelResolutions(), null, null, 2.8E-4, null, 256, 256, true);
        GlobalCRS84Pixel.setDescription("This well-known scale set has been defined for global cartographic products. Rounded pixel sizes have been chosen for intuitive cartographic representation of raster data. Some values have been chosen to coincide with original pixel size of commonly used globalproducts like STRM (1\" and 3\"), GTOPO (30\") or ETOPO (2' and 5'). Scale denominatorand approximated pixel size in meters are only accurate near the equator.");
        this.gridSets.put(GlobalCRS84Pixel.getName(), GlobalCRS84Pixel);
        log.debug((Object)"Adding GlobalCRS84Scale");
        GridSet GlobalCRS84Scale = GridSetFactory.createGridSet("GlobalCRS84Scale", SRS.getEPSG4326(), BoundingBox.WORLD4326, true, null, this.scalesCRS84ScaleDenominators(), null, 2.8E-4, null, 256, 256, true);
        GlobalCRS84Scale.setDescription("This well-known scale set has been defined for global cartographic products. Rounded scales have been chosen for intuitive cartographic representation of vector data. Scale denominator is only accurate near the equator.");
        this.gridSets.put(GlobalCRS84Scale.getName(), GlobalCRS84Scale);
        log.debug((Object)"Adding GoogleCRS84Quad");
        GridSet GoogleCRS84Quad = GridSetFactory.createGridSet("GoogleCRS84Quad", SRS.getEPSG4326(), BoundingBox.WORLD4326, true, null, this.scalesCRS84QuadScaleDenominators(), null, 2.8E-4, null, 256, 256, true);
        GoogleCRS84Quad.setDescription("This well-known scale set has been defined to allow quadtree pyramids in CRS84. Level 0 allows representing the whole world in a single 256x256 pixels (where the first 64 and last 64 lines of the tile are left blank). The next level represents the whole world in 2x2 tiles of 256x256 pixels and so on in powers of 2. Scale denominator is only accurate near the equator.");
        this.gridSets.put(GoogleCRS84Quad.getName(), GoogleCRS84Quad);
        this.embeddedGridSets = Collections.unmodifiableSet(new HashSet<String>(this.gridSets.keySet()));
    }

    public GridSet get(String gridSetId) {
        return this.gridSets.get(gridSetId);
    }

    public Set<String> getEmbeddedNames() {
        return this.embeddedGridSets;
    }

    public Set<String> getNames() {
        return new TreeSet<String>(this.gridSets.keySet());
    }

    public List<GridSet> getGridSets() {
        return new ArrayList<GridSet>(this.gridSets.values());
    }

    public void put(GridSet gridSet) {
        if (this.gridSets.containsKey(gridSet.getName())) {
            log.warn((Object)("Duplicate grid set " + gridSet.getName() + ", " + "removing previous instance, but it may still be referenced by layers."));
            this.gridSets.remove(gridSet.getName());
        }
        log.debug((Object)("Adding " + gridSet.getName()));
        this.gridSets.put(gridSet.getName(), gridSet);
    }

    public GridSet remove(String gridSetName) {
        GridSet removed = this.gridSets.remove(gridSetName);
        return removed;
    }

    private double[] scalesCRS84PixelResolutions() {
        double[] scalesCRS84Pixel;
        scalesCRS84Pixel = new double[]{2.0, 1.0, 0.5, scalesCRS84Pixel[2] * 0.6666666666666666, scalesCRS84Pixel[2] / 3.0, scalesCRS84Pixel[4] / 2.0, scalesCRS84Pixel[4] / 5.0, scalesCRS84Pixel[4] / 10.0, 0.008333333333333333, scalesCRS84Pixel[8] / 2.0, scalesCRS84Pixel[9] / 3.0, scalesCRS84Pixel[9] / 5.0, scalesCRS84Pixel[11] / 3.0, scalesCRS84Pixel[12] / 2.0, scalesCRS84Pixel[13] * 0.6, scalesCRS84Pixel[14] / 3.0, scalesCRS84Pixel[15] * 0.3, scalesCRS84Pixel[16] / 3.0};
        return scalesCRS84Pixel;
    }

    private double[] scalesCRS84ScaleDenominators() {
        double[] scalesCRS84Pixel = new double[]{5.0E8, 2.5E8, 1.0E8, 5.0E7, 2.5E7, 1.0E7, 5000000.0, 2500000.0, 1000000.0, 500000.0, 250000.0, 100000.0, 50000.0, 25000.0, 10000.0, 5000.0, 2500.0, 1000.0, 500.0, 250.0, 100.0};
        return scalesCRS84Pixel;
    }

    private double[] scalesCRS84QuadScaleDenominators() {
        double[] scalesCRS84QuadScaleResolutions = new double[]{5.590822640287178E8, 2.795411320143589E8, 1.397705660071794E8, 6.988528300358972E7, 3.494264150179486E7, 1.747132075089743E7, 8735660.375448715, 4367830.187724357, 2183915.093862179, 1091957.546931089, 545978.7734655447, 272989.3867327723, 136494.6933663862, 68247.34668319309, 34123.67334159654, 17061.83667079827, 8530.918335399136, 4265.459167699568, 2132.729583849784};
        return scalesCRS84QuadScaleResolutions;
    }

    private double[] googleMapsCompatibleResolutions() {
        double[] scalesCRS84QuadScaleResolutions = new double[]{156543.033928041, 78271.51696402048, 39135.75848201023, 19567.87924100512, 9783.93962050256, 4891.96981025128, 2445.98490512564, 1222.99245256282, 611.49622628141, 305.7481131407048, 152.8740565703525, 76.43702828517624, 38.21851414258813, 19.10925707129406, 9.554628535647032, 4.777314267823516, 2.388657133911758, 1.194328566955879, 0.5971642834779395, 0.29858214173896974, 0.14929107086948487};
        return scalesCRS84QuadScaleResolutions;
    }

    private double[] commonPractice900913Resolutions() {
        return new double[]{156543.03390625, 78271.516953125, 39135.7584765625, 19567.87923828125, 9783.939619140625, 4891.9698095703125, 2445.9849047851562, 1222.9924523925781, 611.4962261962891, 305.74811309814453, 152.87405654907226, 76.43702827453613, 38.218514137268066, 19.109257068634033, 9.554628534317017, 4.777314267158508, 2.388657133579254, 1.194328566789627, 0.5971642833948135, 0.29858214169740677, 0.14929107084870338, 0.07464553542435169, 0.037322767712175846, 0.018661383856087923, 0.009330691928043961, 0.004665345964021981, 0.0023326729820109904, 0.0011663364910054952, 5.831682455027476E-4, 2.915841227513738E-4, 1.457920613756869E-4};
    }
}

