/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.filter.parameters;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.geowebcache.filter.parameters.ParameterException;
import org.geowebcache.filter.parameters.ParameterFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringParameterFilter
extends ParameterFilter {
    private static final long serialVersionUID = 7383381085250203901L;
    private List<String> values;

    public StringParameterFilter() {
        this.readResolve();
    }

    private StringParameterFilter readResolve() {
        if (this.values == null) {
            this.values = new ArrayList<String>(2);
        }
        return this;
    }

    @Override
    public String apply(String str) throws ParameterException {
        if (str == null || str.length() == 0) {
            return "";
        }
        Iterator<String> iter = this.values.iterator();
        while (iter.hasNext()) {
            if (!iter.next().equals(str)) continue;
            return str;
        }
        throw new ParameterException(str + " violates filter for parameter " + this.getKey());
    }

    public List<String> getValues() {
        return this.values;
    }

    @Override
    public List<String> getLegalValues() {
        return this.values;
    }

    @Override
    public boolean applies(String parameterValue) {
        return this.getLegalValues().contains(parameterValue);
    }

    @Override
    public StringParameterFilter clone() {
        StringParameterFilter clone = new StringParameterFilter();
        clone.setDefaultValue(this.getDefaultValue());
        clone.setKey(this.getKey());
        if (this.values != null) {
            clone.values = new ArrayList<String>(this.values);
        }
        return clone;
    }
}

