/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.filter.parameters;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geowebcache.filter.parameters.ParameterException;
import org.geowebcache.filter.parameters.ParameterFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexParameterFilter
extends ParameterFilter {
    private static final long serialVersionUID = -1496940509350980799L;
    private String regex;
    private transient Pattern pat;

    public synchronized Matcher getMatcher(String value) {
        if (this.pat == null) {
            this.pat = Pattern.compile(this.getRegex());
        }
        return this.pat.matcher(value);
    }

    @Override
    public String apply(String str) throws ParameterException {
        if (this.getMatcher(str).matches()) {
            return str;
        }
        throw new ParameterException(str + " violates filter for parameter " + this.getKey());
    }

    @Override
    public List<String> getLegalValues() {
        return null;
    }

    @Override
    public boolean applies(String parameterValue) {
        return this.getMatcher(parameterValue).matches();
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    @Override
    public RegexParameterFilter clone() {
        RegexParameterFilter clone = new RegexParameterFilter();
        clone.setDefaultValue(this.getDefaultValue());
        clone.setKey(this.getKey());
        clone.regex = this.regex;
        return clone;
    }
}

