/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.filter.parameters;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.geowebcache.filter.parameters.ParameterException;
import org.geowebcache.filter.parameters.ParameterFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatParameterFilter
extends ParameterFilter {
    private static final long serialVersionUID = 4186888723396139208L;
    private List<Float> values;
    private Float threshold;

    public FloatParameterFilter() {
        this.readResolve();
    }

    private FloatParameterFilter readResolve() {
        if (this.values == null) {
            this.values = new ArrayList<Float>(2);
        }
        if (this.threshold == null) {
            this.threshold = Float.valueOf(1.0E-6f);
        }
        return this;
    }

    public List<Float> getValues() {
        return this.values;
    }

    public Float getThreshold() {
        return this.threshold;
    }

    public void setThreshold(Float threshold) {
        this.threshold = threshold;
    }

    @Override
    public String apply(String str) throws ParameterException {
        if (str == null || str.length() == 0) {
            return "";
        }
        float val = Float.parseFloat(str);
        if (this.values.isEmpty()) {
            return String.valueOf(val);
        }
        float best = Float.MIN_VALUE;
        float bestMismatch = Float.MAX_VALUE;
        for (Float fl : this.getValues()) {
            float mismatch = Math.abs(fl.floatValue() - val);
            if (!(mismatch < bestMismatch)) continue;
            best = fl.floatValue();
            bestMismatch = mismatch;
        }
        if (this.threshold != null && this.threshold.floatValue() > 0.0f && Math.abs(bestMismatch) < this.threshold.floatValue()) {
            return Float.toString(best);
        }
        throw new ParameterException("Closest match for " + super.getKey() + "=" + str + " is " + Float.toString(best) + ", but this exceeds the threshold of " + Float.toString(this.threshold.floatValue()));
    }

    @Override
    public List<String> getLegalValues() {
        LinkedList<String> ret = new LinkedList<String>();
        Iterator<Float> iter = this.getValues().iterator();
        while (iter.hasNext()) {
            ret.add(Float.toString(iter.next().floatValue()));
        }
        return ret;
    }

    @Override
    public FloatParameterFilter clone() {
        FloatParameterFilter clone = new FloatParameterFilter();
        clone.setDefaultValue(this.getDefaultValue());
        clone.setKey(this.getKey());
        if (this.values != null) {
            clone.values = new ArrayList<Float>(this.values);
        }
        return clone;
    }
}

