/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.conveyor;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.Conveyor;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.io.ByteArrayResource;
import org.geowebcache.io.Resource;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileResponseReceiver;
import org.geowebcache.mime.MimeType;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.TileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConveyorTile
extends Conveyor
implements TileResponseReceiver {
    private static Log log = LogFactory.getLog(ConveyorTile.class);
    protected String gridSetId = null;
    protected GridSubset gridSubset = null;
    protected TileLayer tileLayer = null;
    TileObject stObj = null;
    private Map<String, String> fullParameters;
    private boolean isMetaTileCacheOnly;

    public ConveyorTile(StorageBroker sb, String layerId, HttpServletRequest servletReq, HttpServletResponse servletResp) {
        super(layerId, sb, servletReq, servletResp);
    }

    @Deprecated
    public ConveyorTile(StorageBroker sb, String layerId, String gridSetId, long[] tileIndex, MimeType mimeType, Map<String, String> fullParameters, Map<String, String> modifiedParameters, HttpServletRequest servletReq, HttpServletResponse servletResp) {
        this(sb, layerId, gridSetId, tileIndex, mimeType, fullParameters, servletReq, servletResp);
    }

    public ConveyorTile(StorageBroker sb, String layerId, String gridSetId, long[] tileIndex, MimeType mimeType, Map<String, String> filteringParameters, HttpServletRequest servletReq, HttpServletResponse servletResp) {
        super(layerId, sb, servletReq, servletResp);
        this.gridSetId = gridSetId;
        long[] idx = new long[3];
        if (tileIndex != null) {
            idx[0] = tileIndex[0];
            idx[1] = tileIndex[1];
            idx[2] = tileIndex[2];
        }
        this.mimeType = mimeType;
        this.fullParameters = filteringParameters;
        this.stObj = TileObject.createQueryTileObject(layerId, idx, gridSetId, mimeType.getFormat(), filteringParameters);
    }

    public Map<String, String> getFullParameters() {
        if (this.fullParameters == null) {
            return Collections.emptyMap();
        }
        return this.fullParameters;
    }

    public TileLayer getLayer() {
        return this.tileLayer;
    }

    public void setTileLayer(TileLayer layer) {
        this.tileLayer = layer;
    }

    public TileLayer getTileLayer() {
        return this.tileLayer;
    }

    public long getTSCreated() {
        return this.stObj.getCreated();
    }

    @Override
    public int getStatus() {
        return (int)this.status;
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMsg;
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        this.errorMsg = errorMessage;
    }

    public Map<String, String> getParameters() {
        return this.stObj.getParameters();
    }

    public long[] getTileIndex() {
        return this.stObj.getXYZ();
    }

    public synchronized GridSubset getGridSubset() {
        if (this.gridSubset == null) {
            this.gridSubset = this.tileLayer.getGridSubset(this.gridSetId);
        }
        return this.gridSubset;
    }

    public String getGridSetId() {
        return this.gridSetId;
    }

    public void setGridSetId(String gridSetId) {
        this.gridSetId = gridSetId;
    }

    @Deprecated
    public byte[] getContent() {
        Resource blob = this.getBlob();
        if (blob instanceof ByteArrayResource) {
            return ((ByteArrayResource)blob).getContents();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream((int)blob.getSize());
        try {
            blob.transferTo(Channels.newChannel(out));
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Resource getBlob() {
        return this.stObj.getBlob();
    }

    @Deprecated
    public void setContent(byte[] payload) {
        this.setBlob(new ByteArrayResource(payload));
    }

    public void setBlob(Resource payload) {
        this.stObj.setBlob(payload);
    }

    public TileObject getStorageObject() {
        return this.stObj;
    }

    public boolean persist() throws GeoWebCacheException {
        try {
            return this.storageBroker.put(this.stObj);
        }
        catch (StorageException e) {
            throw new GeoWebCacheException(e);
        }
    }

    public boolean retrieve(long maxAge) throws GeoWebCacheException {
        try {
            if (this.isMetaTileCacheOnly) {
                boolean cached = this.storageBroker.getTransient(this.stObj);
                this.setCacheResult(cached ? Conveyor.CacheResult.HIT : Conveyor.CacheResult.MISS);
                return cached;
            }
            boolean ret = this.storageBroker.get(this.stObj);
            if (ret && maxAge > 0L && this.stObj.getCreated() + maxAge < System.currentTimeMillis()) {
                ret = false;
            }
            if (ret) {
                this.setCacheResult(Conveyor.CacheResult.HIT);
            } else {
                this.setCacheResult(Conveyor.CacheResult.MISS);
            }
            return ret;
        }
        catch (StorageException se) {
            log.warn((Object)se.getMessage());
            return false;
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("ConveyorTile[");
        long[] idx = this.stObj.getXYZ();
        if (idx != null && idx.length == 3) {
            str.append("{" + idx[0] + "," + idx[1] + "," + idx[2] + "} ");
        }
        if (this.getLayer() != null) {
            str.append(this.getLayerId()).append(" ");
        }
        if (this.gridSetId != null) {
            str.append(this.gridSetId).append(" ");
        }
        if (this.mimeType != null) {
            str.append(this.mimeType.getFormat());
        }
        str.append(']');
        return str.toString();
    }

    public long getParametersId() {
        return this.stObj.getParametersId();
    }

    public void setMetaTileCacheOnly(boolean b) {
        this.isMetaTileCacheOnly = b;
    }

    public boolean isMetaTileCacheOnly() {
        return this.isMetaTileCacheOnly;
    }
}

