/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.config;

import java.io.Serializable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.Grid;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetFactory;
import org.geowebcache.grid.SRS;

public class XMLGridSet
implements Serializable {
    private static final long serialVersionUID = 2684804068163933728L;
    private String name;
    private String description;
    private SRS srs;
    private BoundingBox extent;
    private Boolean alignTopLeft;
    private double[] resolutions;
    private double[] scaleDenominators;
    private Integer levels;
    private Double metersPerUnit;
    private Double pixelSize;
    private String[] scaleNames;
    private Integer tileHeight;
    private Integer tileWidth;
    private Boolean yCoordinateFirst;

    public XMLGridSet() {
    }

    public XMLGridSet(XMLGridSet orig) {
        this.setAlignTopLeft(orig.getAlignTopLeft());
        this.setExtent(orig.getExtent() == null ? null : new BoundingBox(orig.getExtent()));
        this.setResolutions(orig.getResolutions() == null ? null : (double[])orig.getResolutions().clone());
        this.setLevels(orig.getLevels());
        this.setScaleDenominators(orig.getScaleDenominators() == null ? null : (double[])orig.getScaleDenominators().clone());
        this.setMetersPerUnit(orig.getMetersPerUnit());
        this.setName(orig.getName());
        this.setDescription(orig.getDescription());
        this.setPixelSize(orig.getPixelSize());
        this.setScaleNames(orig.getScaleNames() == null ? null : (String[])orig.getScaleNames().clone());
        this.setSrs(orig.getSrs());
        this.setTileWidth(orig.getTileWidth());
        this.setTileHeight(orig.getTileHeight());
    }

    public XMLGridSet(GridSet gset) {
        this.setAlignTopLeft(gset.isTopLeftAligned());
        this.setYCoordinateFirst(gset.isyCoordinateFirst());
        this.setExtent(gset.getOriginalExtent());
        this.setLevels(null);
        if (gset.isResolutionsPreserved()) {
            this.setResolutions(XMLGridSet.resolutions(gset.getGridLevels()));
            this.setScaleDenominators(null);
        } else {
            this.setResolutions(null);
            this.setScaleDenominators(XMLGridSet.scaleDenominators(gset.getGridLevels()));
        }
        this.setMetersPerUnit(gset.getMetersPerUnit());
        this.setName(gset.getName());
        this.setDescription(gset.getDescription());
        this.setPixelSize(gset.getPixelSize());
        this.setScaleNames(XMLGridSet.scaleNames(gset.getGridLevels()));
        this.setSrs(gset.getSrs());
        this.setTileWidth(gset.getTileWidth());
        this.setTileHeight(gset.getTileHeight());
    }

    private static double[] resolutions(Grid[] grids) {
        double[] resolutions = new double[grids.length];
        for (int i = 0; i < resolutions.length; ++i) {
            resolutions[i] = grids[i].getResolution();
        }
        return resolutions;
    }

    private static double[] scaleDenominators(Grid[] grids) {
        double[] scales = new double[grids.length];
        for (int i = 0; i < scales.length; ++i) {
            scales[i] = grids[i].getScaleDenominator();
        }
        return scales;
    }

    private static String[] scaleNames(Grid[] grids) {
        String[] scaleNames = new String[grids.length];
        for (int i = 0; i < scaleNames.length; ++i) {
            scaleNames[i] = grids[i].getName();
        }
        return scaleNames;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public GridSet makeGridSet() {
        GridSet gridSet;
        if (this.getTileWidth() == null) {
            this.setTileWidth(256);
        }
        if (this.getTileHeight() == null) {
            this.setTileHeight(256);
        }
        if (this.getAlignTopLeft() == null) {
            this.setAlignTopLeft(false);
        }
        if (this.getPixelSize() == null) {
            this.setPixelSize(2.8E-4);
        }
        if (this.getYCoordinateFirst() == null) {
            this.setYCoordinateFirst(false);
        }
        String name = this.getName();
        SRS srs = this.getSrs();
        BoundingBox extent = this.getExtent();
        Boolean alignTopLeft = this.getAlignTopLeft();
        double[] resolutions = this.getResolutions();
        double[] scaleDenominators = this.getScaleDenominators();
        Double metersPerUnit = this.getMetersPerUnit();
        Double pixelSize = this.getPixelSize();
        String[] scaleNames = this.getScaleNames();
        Integer tileWidth = this.getTileWidth();
        Integer tileHeight = this.getTileHeight();
        Boolean yCoordinateFirst = this.getYCoordinateFirst();
        if (this.getResolutions() != null || this.getScaleDenominators() != null) {
            gridSet = GridSetFactory.createGridSet(name, srs, extent, alignTopLeft, resolutions, scaleDenominators, metersPerUnit, pixelSize, scaleNames, tileWidth, tileHeight, yCoordinateFirst);
        } else {
            if (this.getLevels() == null) {
                this.setLevels(18);
            }
            Integer levels = this.getLevels();
            gridSet = GridSetFactory.createGridSet(name, srs, extent, alignTopLeft, levels, metersPerUnit, pixelSize, tileWidth, tileHeight, yCoordinateFirst);
        }
        gridSet.setDescription(this.getDescription());
        return gridSet;
    }

    SRS getSrs() {
        return this.srs;
    }

    void setSrs(SRS srs) {
        this.srs = srs;
    }

    public BoundingBox getExtent() {
        return this.extent;
    }

    public void setExtent(BoundingBox extent) {
        this.extent = extent;
    }

    public Boolean getAlignTopLeft() {
        return this.alignTopLeft;
    }

    public void setAlignTopLeft(Boolean alignTopLeft) {
        this.alignTopLeft = alignTopLeft;
    }

    public double[] getResolutions() {
        return this.resolutions;
    }

    public void setResolutions(double[] resolutions) {
        this.resolutions = resolutions;
    }

    public double[] getScaleDenominators() {
        return this.scaleDenominators;
    }

    public void setScaleDenominators(double[] scaleDenominators) {
        this.scaleDenominators = scaleDenominators;
    }

    public Integer getLevels() {
        return this.levels;
    }

    public void setLevels(Integer levels) {
        this.levels = levels;
    }

    public Double getMetersPerUnit() {
        return this.metersPerUnit;
    }

    public void setMetersPerUnit(Double metersPerUnit) {
        this.metersPerUnit = metersPerUnit;
    }

    public Double getPixelSize() {
        return this.pixelSize;
    }

    public void setPixelSize(Double pixelSize) {
        this.pixelSize = pixelSize;
    }

    public String[] getScaleNames() {
        return this.scaleNames;
    }

    public void setScaleNames(String[] scaleNames) {
        this.scaleNames = scaleNames;
    }

    public Integer getTileHeight() {
        return this.tileHeight;
    }

    public void setTileHeight(Integer tileHeight) {
        this.tileHeight = tileHeight;
    }

    public Integer getTileWidth() {
        return this.tileWidth;
    }

    public void setTileWidth(Integer tileWidth) {
        this.tileWidth = tileWidth;
    }

    public Boolean getYCoordinateFirst() {
        return this.yCoordinateFirst;
    }

    public void setYCoordinateFirst(Boolean yCoordinateFirst) {
        this.yCoordinateFirst = yCoordinateFirst;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
    }
}

