/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.config;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.xml.DomReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.GeoWebCacheExtensions;
import org.geowebcache.config.Configuration;
import org.geowebcache.config.ConfigurationException;
import org.geowebcache.config.GeoWebCacheConfiguration;
import org.geowebcache.config.XMLConfigurationProvider;
import org.geowebcache.config.XMLGridSet;
import org.geowebcache.config.XMLGridSubset;
import org.geowebcache.config.XMLOldGrid;
import org.geowebcache.config.meta.ServiceInformation;
import org.geowebcache.filter.parameters.FloatParameterFilter;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.filter.parameters.RegexParameterFilter;
import org.geowebcache.filter.parameters.StringParameterFilter;
import org.geowebcache.filter.request.CircularExtentFilter;
import org.geowebcache.filter.request.FileRasterFilter;
import org.geowebcache.filter.request.WMSRasterFilter;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.SRS;
import org.geowebcache.layer.ExpirationRule;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.meta.ContactInformation;
import org.geowebcache.layer.meta.LayerMetaInformation;
import org.geowebcache.layer.updatesource.GeoRSSFeedDefinition;
import org.geowebcache.layer.wms.WMSHttpHelper;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.mime.FormatModifier;
import org.geowebcache.seed.SeedRequest;
import org.geowebcache.storage.DefaultStorageFinder;
import org.geowebcache.util.ApplicationContextProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLConfiguration
implements Configuration {
    private static Log log = LogFactory.getLog(XMLConfiguration.class);
    private static final String DEFAULT_CONFIGURATION_FILE_NAME = "geowebcache.xml";
    private final WebApplicationContext context;
    private final File configDirectory;
    private final String configFileName;
    private GeoWebCacheConfiguration gwcConfig;
    private transient Map<String, TileLayer> layers;
    private String templateLocation;
    private GridSetBroker gridSetBroker;

    public XMLConfiguration(ApplicationContextProvider appCtx, GridSetBroker gridSetBroker, DefaultStorageFinder storageDirFinder) throws ConfigurationException {
        this(appCtx, storageDirFinder);
        log.warn((Object)"This constructor is deprecated");
    }

    public XMLConfiguration(ApplicationContextProvider appCtx, DefaultStorageFinder storageDirFinder) throws ConfigurationException {
        Assert.notNull((Object)storageDirFinder);
        if (appCtx == null) {
            log.warn((Object)"No application context provider given, configuration extensions won't be available");
        }
        this.context = appCtx == null ? null : appCtx.getApplicationContext();
        this.configFileName = DEFAULT_CONFIGURATION_FILE_NAME;
        this.configDirectory = new File(storageDirFinder.getDefaultPath());
        this.templateLocation = "/geowebcache.xml";
        log.info((Object)("Will look for geowebcache.xml in '" + this.configDirectory + "'"));
    }

    public XMLConfiguration(ApplicationContextProvider appCtx, GridSetBroker gridSetBroker, String configFileDirectory) throws ConfigurationException {
        this(appCtx, configFileDirectory);
        log.warn((Object)"This constructor is deprecated");
    }

    public XMLConfiguration(ApplicationContextProvider appCtx, String configFileDirectory) throws ConfigurationException {
        Assert.notNull((Object)configFileDirectory);
        if (appCtx == null) {
            log.warn((Object)"No application context provider given, configuration extensions won't be available");
        }
        this.context = appCtx == null ? null : appCtx.getApplicationContext();
        this.configFileName = DEFAULT_CONFIGURATION_FILE_NAME;
        this.templateLocation = "/geowebcache.xml";
        if (configFileDirectory.startsWith("/") || configFileDirectory.contains(":\\") || configFileDirectory.startsWith("\\\\")) {
            log.info((Object)("Provided configuration directory as absolute path '" + configFileDirectory + "'"));
            this.configDirectory = new File(configFileDirectory);
        } else {
            String baseDir = this.context.getServletContext().getRealPath("");
            log.info((Object)("Provided configuration directory relative to servlet context '" + baseDir + "': " + configFileDirectory));
            this.configDirectory = new File(baseDir, configFileDirectory);
        }
        log.info((Object)("Will look for geowebcache.xml in '" + configFileDirectory + "'"));
    }

    public XMLConfiguration(InputStream in) throws ConfigurationException {
        this.configDirectory = null;
        this.configFileName = null;
        this.context = null;
        this.templateLocation = "/geowebcache.xml";
        try {
            this.gwcConfig = this.loadConfiguration(in);
        }
        catch (IOException e) {
            throw new ConfigurationException("Error parsing config file", e);
        }
    }

    public void setTemplate(String templateLocation) {
        this.templateLocation = templateLocation;
    }

    private File findConfigFile() throws ConfigurationException {
        if (null == this.configDirectory) {
            throw new IllegalStateException();
        }
        if (!this.configDirectory.exists() && !this.configDirectory.mkdirs()) {
            throw new ConfigurationException("Configuration directory does not exist and cannot be created: '" + this.configDirectory.getAbsolutePath() + "'");
        }
        if (!this.configDirectory.canWrite()) {
            throw new ConfigurationException("Configuration directory is not writable: '" + this.configDirectory.getAbsolutePath() + "'");
        }
        File xmlFile = new File(this.configDirectory, this.configFileName);
        return xmlFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File findOrCreateConfFile() throws ConfigurationException {
        File xmlFile = this.findConfigFile();
        if (xmlFile.exists()) {
            log.info((Object)("Found configuration file in " + this.configDirectory.getAbsolutePath()));
        } else {
            log.warn((Object)("Found no configuration file in config directory, will create one at '" + xmlFile.getAbsolutePath() + "' from template " + this.getClass().getResource(this.templateLocation).toExternalForm()));
            try {
                InputStream templateStream = this.getClass().getResourceAsStream(this.templateLocation);
                try {
                    FileOutputStream output = new FileOutputStream(xmlFile);
                    try {
                        IOUtils.copy((InputStream)templateStream, (OutputStream)output);
                    }
                    finally {
                        output.flush();
                        ((OutputStream)output).close();
                    }
                }
                finally {
                    templateStream.close();
                }
            }
            catch (IOException e) {
                throw new ConfigurationException("Error copying template config to " + xmlFile.getAbsolutePath(), e);
            }
        }
        return xmlFile;
    }

    @Override
    public boolean isRuntimeStatsEnabled() {
        if (this.gwcConfig == null || this.gwcConfig.getRuntimeStats() == null) {
            return true;
        }
        return this.gwcConfig.getRuntimeStats();
    }

    @Override
    public synchronized ServiceInformation getServiceInformation() {
        return this.gwcConfig.getServiceInformation();
    }

    private void setDefaultValues(TileLayer layer) {
        if (layer.isCacheBypassAllowed() == null) {
            if (this.gwcConfig.getCacheBypassAllowed() != null) {
                layer.setCacheBypassAllowed(this.gwcConfig.getCacheBypassAllowed());
            } else {
                layer.setCacheBypassAllowed(false);
            }
        }
        if (layer.getBackendTimeout() == null) {
            if (this.gwcConfig.getBackendTimeout() != null) {
                layer.setBackendTimeout(this.gwcConfig.getBackendTimeout());
            } else {
                layer.setBackendTimeout(120);
            }
        }
        if (layer.getFormatModifiers() == null && this.gwcConfig.getFormatModifiers() != null) {
            layer.setFormatModifiers(this.gwcConfig.getFormatModifiers());
        }
        if (layer instanceof WMSLayer) {
            WMSHttpHelper sourceHelper;
            WMSLayer wl = (WMSLayer)layer;
            URL proxyUrl = null;
            try {
                if (this.gwcConfig.getProxyUrl() != null) {
                    proxyUrl = new URL(this.gwcConfig.getProxyUrl());
                    log.debug((Object)("Using proxy " + proxyUrl.getHost() + ":" + proxyUrl.getPort()));
                } else if (wl.getProxyUrl() != null) {
                    proxyUrl = new URL(wl.getProxyUrl());
                    log.debug((Object)("Using proxy " + proxyUrl.getHost() + ":" + proxyUrl.getPort()));
                }
            }
            catch (MalformedURLException e) {
                log.error((Object)("could not parse proxy URL " + wl.getProxyUrl() + " ! continuing WITHOUT proxy!"), (Throwable)e);
            }
            if (wl.getHttpUsername() != null) {
                sourceHelper = new WMSHttpHelper(wl.getHttpUsername(), wl.getHttpPassword(), proxyUrl);
                log.debug((Object)("Using per-layer HTTP credentials for " + wl.getName() + ", " + "username " + wl.getHttpUsername()));
            } else if (this.gwcConfig.getHttpUsername() != null) {
                sourceHelper = new WMSHttpHelper(this.gwcConfig.getHttpUsername(), this.gwcConfig.getHttpPassword(), proxyUrl);
                log.debug((Object)("Using global HTTP credentials for " + wl.getName()));
            } else {
                sourceHelper = new WMSHttpHelper(null, null, proxyUrl);
                log.debug((Object)("Not using HTTP credentials for " + wl.getName()));
            }
            wl.setSourceHelper(sourceHelper);
        }
    }

    private GeoWebCacheConfiguration loadConfiguration() throws ConfigurationException {
        File xmlFile = this.findOrCreateConfFile();
        Assert.notNull((Object)xmlFile);
        GeoWebCacheConfiguration config = this.loadConfiguration(xmlFile);
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GeoWebCacheConfiguration loadConfiguration(File xmlFile) throws ConfigurationException {
        GeoWebCacheConfiguration geoWebCacheConfiguration;
        FileInputStream in = new FileInputStream(xmlFile);
        try {
            geoWebCacheConfiguration = this.loadConfiguration(in);
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)in).close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ConfigurationException("Error parsing config file " + xmlFile.getAbsolutePath(), e);
            }
        }
        ((InputStream)in).close();
        return geoWebCacheConfiguration;
    }

    private GeoWebCacheConfiguration loadConfiguration(InputStream xmlFile) throws IOException, ConfigurationException {
        Node rootNode = XMLConfiguration.loadDocument(xmlFile);
        XStream xs = this.getConfiguredXStream(new XStream());
        GeoWebCacheConfiguration config = (GeoWebCacheConfiguration)xs.unmarshal((HierarchicalStreamReader)new DomReader((Element)rootNode));
        return config;
    }

    @Override
    public synchronized void save() throws IOException {
        File xmlFile;
        try {
            xmlFile = this.findOrCreateConfFile();
        }
        catch (IllegalStateException e) {
            return;
        }
        catch (ConfigurationException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        try {
            this.backUpConfig(xmlFile);
        }
        catch (Exception e) {
            log.warn((Object)("Error creating back up of configuration file " + this.configFileName), (Throwable)e);
        }
        this.persistToFile(xmlFile);
    }

    private void backUpConfig(File xmlFile) throws IOException {
        String timeStamp = new SimpleDateFormat("yyyy-MM-dd'T'HHmmss").format(new Date());
        String backUpFileName = "geowebcache_" + timeStamp + ".bak";
        File parentFile = xmlFile.getParentFile();
        log.debug((Object)("Backing up config file " + xmlFile.getName() + " to " + backUpFileName));
        Object[] previousBackUps = parentFile.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                if (XMLConfiguration.this.configFileName.equals(name)) {
                    return false;
                }
                return name.startsWith(XMLConfiguration.this.configFileName) && name.endsWith(".bak");
            }
        });
        int maxBackups = 10;
        if (previousBackUps.length > 10) {
            Arrays.sort(previousBackUps);
            Object oldest = previousBackUps[0];
            log.debug((Object)("Deleting oldest config backup " + (String)oldest + " to keep a maximum of " + 10 + " backups."));
            new File(parentFile, (String)oldest).delete();
        }
        File backUpFile = new File(parentFile, backUpFileName);
        FileUtils.copyFile((File)xmlFile, (File)backUpFile);
        log.debug((Object)"Config backup done");
    }

    public XStream getConfiguredXStream(XStream xs) {
        return XMLConfiguration.getConfiguredXStream(xs, this.context);
    }

    public static XStream getConfiguredXStream(XStream xs, WebApplicationContext context) {
        xs.setMode(1001);
        xs.addDefaultImplementation(ArrayList.class, List.class);
        xs.alias("gwcConfiguration", GeoWebCacheConfiguration.class);
        xs.useAttributeFor(GeoWebCacheConfiguration.class, "xmlns_xsi");
        xs.aliasField("xmlns:xsi", GeoWebCacheConfiguration.class, "xmlns_xsi");
        xs.useAttributeFor(GeoWebCacheConfiguration.class, "xsi_schemaLocation");
        xs.aliasField("xsi:schemaLocation", GeoWebCacheConfiguration.class, "xsi_schemaLocation");
        xs.useAttributeFor(GeoWebCacheConfiguration.class, "xmlns");
        xs.alias("wmsLayer", WMSLayer.class);
        xs.alias("grids", new ArrayList().getClass());
        xs.alias("grid", XMLOldGrid.class);
        xs.alias("gridSet", XMLGridSet.class);
        xs.alias("gridSubset", XMLGridSubset.class);
        xs.alias("mimeFormats", new ArrayList().getClass());
        xs.alias("formatModifiers", new ArrayList().getClass());
        xs.alias("srs", SRS.class);
        xs.alias("parameterFilters", new ArrayList().getClass());
        xs.alias("parameterFilter", ParameterFilter.class);
        xs.alias("seedRequest", SeedRequest.class);
        xs.alias("floatParameterFilter", FloatParameterFilter.class);
        xs.alias("regexParameterFilter", RegexParameterFilter.class);
        xs.alias("stringParameterFilter", StringParameterFilter.class);
        xs.alias("formatModifier", FormatModifier.class);
        xs.alias("circularExtentFilter", CircularExtentFilter.class);
        xs.alias("wmsRasterFilter", WMSRasterFilter.class);
        xs.alias("fileRasterFilter", FileRasterFilter.class);
        xs.alias("expirationRule", ExpirationRule.class);
        xs.useAttributeFor(ExpirationRule.class, "minZoom");
        xs.useAttributeFor(ExpirationRule.class, "expiration");
        xs.alias("geoRssFeed", GeoRSSFeedDefinition.class);
        xs.alias("metaInformation", LayerMetaInformation.class);
        xs.alias("serviceInformation", ServiceInformation.class);
        xs.alias("contactInformation", ContactInformation.class);
        if (context != null) {
            List<XMLConfigurationProvider> configExtensions = GeoWebCacheExtensions.extensions(XMLConfigurationProvider.class, (ApplicationContext)context);
            for (XMLConfigurationProvider extension : configExtensions) {
                xs = extension.getConfiguredXStream(xs);
            }
        }
        return xs;
    }

    private void persistToFile(File xmlFile) throws IOException {
        XStream xs = this.getConfiguredXStream(new XStream());
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(xmlFile), "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace();
            throw new IOException(uee.getMessage());
        }
        catch (FileNotFoundException fnfe) {
            throw fnfe;
        }
        try {
            String currentSchemaVersion = XMLConfiguration.getCurrentSchemaVersion();
            this.gwcConfig.setVersion(currentSchemaVersion);
            writer.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
            xs.toXML((Object)this.gwcConfig, (Writer)writer);
        }
        catch (IOException e) {
            throw (IOException)new IOException("Error writing to " + xmlFile.getAbsolutePath() + ": " + e.getMessage()).initCause(e);
        }
        log.info((Object)("Wrote configuration to " + xmlFile.getAbsolutePath()));
    }

    @Override
    public boolean canSave(TileLayer tl) {
        return tl instanceof WMSLayer;
    }

    @Override
    public synchronized void addLayer(TileLayer tl) throws IllegalArgumentException {
        if (tl == null) {
            throw new NullPointerException();
        }
        if (!(tl instanceof WMSLayer)) {
            throw new IllegalArgumentException("Can't add layers of type " + tl.getClass().getName());
        }
        if (null != this.getTileLayer(tl.getName())) {
            throw new IllegalArgumentException("Layer '" + tl.getName() + "' already exists");
        }
        this.initialize(tl);
        this.gwcConfig.getLayers().add(tl);
        this.updateLayers();
    }

    @Override
    public synchronized void modifyLayer(TileLayer tl) throws NoSuchElementException {
        TileLayer previous = this.getTileLayer(tl.getName());
        if (null == previous) {
            throw new NoSuchElementException("Layer " + tl.getName() + " does not exist");
        }
        this.gwcConfig.getLayers().remove(previous);
        this.initialize(tl);
        this.gwcConfig.getLayers().add(tl);
        this.updateLayers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean removeLayer(String layerName) {
        TileLayer tileLayer = this.getTileLayer(layerName);
        if (tileLayer == null) {
            return false;
        }
        boolean removed = false;
        tileLayer.acquireLayerLock();
        try {
            removed = this.gwcConfig.getLayers().remove(tileLayer);
            if (removed) {
                this.updateLayers();
            }
        }
        finally {
            tileLayer.releaseLayerLock();
        }
        return removed;
    }

    public synchronized void addOrReplaceGridSet(XMLGridSet gridSet) throws IllegalArgumentException {
        String gridsetName = gridSet.getName();
        List<XMLGridSet> gridSets = this.gwcConfig.getGridSets();
        Iterator<XMLGridSet> it = gridSets.iterator();
        while (it.hasNext()) {
            XMLGridSet gset = it.next();
            if (!gridsetName.equals(gset.getName())) continue;
            it.remove();
        }
        gridSets.add(gridSet);
    }

    public synchronized XMLGridSet removeGridset(String gridsetName) {
        List<XMLGridSet> gridSets = this.gwcConfig.getGridSets();
        Iterator<XMLGridSet> it = gridSets.iterator();
        while (it.hasNext()) {
            XMLGridSet gset = it.next();
            if (!gridsetName.equals(gset.getName())) continue;
            it.remove();
            return gset;
        }
        return null;
    }

    static Node loadDocument(InputStream xmlFile) throws ConfigurationException, IOException {
        Node topNode = null;
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            topNode = XMLConfiguration.checkAndTransform(docBuilder.parse(xmlFile));
        }
        catch (Exception e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        return topNode;
    }

    private static Node checkAndTransform(Document doc) throws ConfigurationException {
        Node rootNode = doc.getDocumentElement();
        if (!rootNode.getNodeName().equals("gwcConfiguration")) {
            log.info((Object)"The configuration file is of the pre 1.0 type, trying to convert.");
            rootNode = XMLConfiguration.applyTransform(rootNode, "geowebcache_pre10.xsl").getFirstChild();
        }
        if (rootNode.getNamespaceURI().equals("http://geowebcache.org/schema/1.0.0")) {
            log.info((Object)"Updating configuration from 1.0.0 to 1.0.1");
            rootNode = XMLConfiguration.applyTransform(rootNode, "geowebcache_100.xsl").getFirstChild();
        }
        if (rootNode.getNamespaceURI().equals("http://geowebcache.org/schema/1.0.1")) {
            log.info((Object)"Updating configuration from 1.0.1 to 1.0.2");
            rootNode = XMLConfiguration.applyTransform(rootNode, "geowebcache_101.xsl").getFirstChild();
        }
        if (rootNode.getNamespaceURI().equals("http://geowebcache.org/schema/1.0.2")) {
            log.info((Object)"Updating configuration from 1.0.2 to 1.1.0");
            rootNode = XMLConfiguration.applyTransform(rootNode, "geowebcache_102.xsl").getFirstChild();
        }
        if (rootNode.getNamespaceURI().equals("http://geowebcache.org/schema/1.1.0")) {
            log.info((Object)"Updating configuration from 1.1.0 to 1.1.3");
            rootNode = XMLConfiguration.applyTransform(rootNode, "geowebcache_110.xsl").getFirstChild();
        }
        if (rootNode.getNamespaceURI().equals("http://geowebcache.org/schema/1.1.3")) {
            log.info((Object)"Updating configuration from 1.1.3 to 1.1.4");
            rootNode = XMLConfiguration.applyTransform(rootNode, "geowebcache_113.xsl").getFirstChild();
        }
        if (rootNode.getNamespaceURI().equals("http://geowebcache.org/schema/1.1.4")) {
            log.info((Object)"Updating configuration from 1.1.4 to 1.1.5");
            rootNode = XMLConfiguration.applyTransform(rootNode, "geowebcache_114.xsl").getFirstChild();
        }
        if (rootNode.getNamespaceURI().equals("http://geowebcache.org/schema/1.1.5")) {
            log.info((Object)"Updating configuration from 1.1.5 to 1.2.0");
            rootNode = XMLConfiguration.applyTransform(rootNode, "geowebcache_115.xsl").getFirstChild();
        }
        if (rootNode.getNamespaceURI().equals("http://geowebcache.org/schema/1.2.0")) {
            log.info((Object)"Updating configuration from 1.2.0 to 1.2.1");
            rootNode = XMLConfiguration.applyTransform(rootNode, "geowebcache_120.xsl").getFirstChild();
        }
        if (rootNode.getNamespaceURI().equals("http://geowebcache.org/schema/1.2.1")) {
            log.info((Object)"Updating configuration from 1.2.1 to 1.2.2");
            rootNode = XMLConfiguration.applyTransform(rootNode, "geowebcache_121.xsl").getFirstChild();
        }
        if (rootNode.getNamespaceURI().equals("http://geowebcache.org/schema/1.2.2")) {
            log.info((Object)"Updating configuration from 1.2.2 to 1.2.4");
            rootNode = XMLConfiguration.applyTransform(rootNode, "geowebcache_122.xsl").getFirstChild();
        }
        if (rootNode.getNamespaceURI().equals("http://geowebcache.org/schema/1.2.4")) {
            log.info((Object)"Updating configuration from 1.2.4 to 1.2.5");
            rootNode = XMLConfiguration.applyTransform(rootNode, "geowebcache_124.xsl").getFirstChild();
        }
        if (rootNode.getNamespaceURI().equals("http://geowebcache.org/schema/1.2.5")) {
            log.info((Object)"Updating configuration from 1.2.5 to 1.2.6");
            rootNode = XMLConfiguration.applyTransform(rootNode, "geowebcache_125.xsl").getFirstChild();
        }
        if (rootNode.getNamespaceURI().equals("http://geowebcache.org/schema/1.2.6")) {
            log.info((Object)"Updating configuration from 1.2.6 to 1.3.0");
            rootNode = XMLConfiguration.applyTransform(rootNode, "geowebcache_126.xsl").getFirstChild();
        }
        if (!rootNode.getNodeName().equals("gwcConfiguration")) {
            log.error((Object)"Unable to parse file, expected gwcConfiguration at root after transform.");
            throw new ConfigurationException("Unable to parse after transform.");
        }
        try {
            XMLConfiguration.validate(rootNode);
            log.info((Object)"Configuration file validated fine.");
        }
        catch (SAXException e) {
            String msg = "*** GWC configuration validation error: " + e.getMessage();
            char[] c = new char[4 + msg.length()];
            Arrays.fill(c, '*');
            String warndecoration = new String(c).substring(0, 80);
            log.warn((Object)warndecoration);
            log.warn((Object)msg);
            log.warn((Object)"*** Will try to use configuration anyway. Please check the order of declared elements against the schema.");
            log.warn((Object)warndecoration);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return rootNode;
    }

    static void validate(Node rootNode) throws SAXException, IOException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        InputStream is = XMLConfiguration.class.getResourceAsStream("geowebcache.xsd");
        Schema schema = factory.newSchema(new StreamSource(is));
        Validator validator = schema.newValidator();
        DOMSource domSrc = new DOMSource(rootNode);
        validator.validate(domSrc);
    }

    static String getCurrentSchemaVersion() {
        Document dom;
        InputStream is = XMLConfiguration.class.getResourceAsStream("geowebcache.xsd");
        try {
            dom = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        String version = dom.getDocumentElement().getAttribute("version");
        if (null == version || version.trim().length() == 0) {
            throw new IllegalStateException("Schema doesn't define version");
        }
        return version.trim();
    }

    private static Node applyTransform(Node oldRootNode, String xslFilename) {
        DOMResult result = new DOMResult();
        InputStream is = XMLConfiguration.class.getResourceAsStream(xslFilename);
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(is));
            transformer.transform(new DOMSource(oldRootNode), result);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerFactoryConfigurationError e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return result.getNode();
    }

    @Override
    public int initialize(GridSetBroker gridSetBroker) throws GeoWebCacheException {
        this.gridSetBroker = gridSetBroker;
        if (this.configFileName != null) {
            this.gwcConfig = this.loadConfiguration();
        }
        log.info((Object)("Initializing GridSets from " + this.getIdentifier()));
        this.contributeGridSets(gridSetBroker);
        log.info((Object)("Initializing layers from " + this.getIdentifier()));
        for (TileLayer layer : this.gwcConfig.getLayers()) {
            if (layer == null) {
                throw new IllegalStateException(this.getIdentifier() + " contains a null layer");
            }
            this.initialize(layer);
        }
        this.updateLayers();
        return this.getTileLayerCount();
    }

    private void updateLayers() {
        HashMap<String, TileLayer> buff = new HashMap<String, TileLayer>();
        for (TileLayer layer : this.gwcConfig.getLayers()) {
            buff.put(layer.getName(), layer);
        }
        this.layers = buff;
    }

    private void contributeGridSets(GridSetBroker gridSetBroker) {
        if (this.gwcConfig.getGridSets() != null) {
            for (XMLGridSet xmlGridSet : this.gwcConfig.getGridSets()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Reading " + xmlGridSet.getName()));
                }
                GridSet gridSet = xmlGridSet.makeGridSet();
                log.info((Object)("Read GridSet " + gridSet.getName()));
                gridSetBroker.put(gridSet);
            }
        }
    }

    private void initialize(TileLayer layer) {
        log.info((Object)("Initializing TileLayer '" + layer.getName() + "'"));
        this.setDefaultValues(layer);
        layer.initialize(this.gridSetBroker);
    }

    @Override
    public String getIdentifier() {
        if (this.configDirectory != null) {
            return this.configDirectory.getAbsolutePath();
        }
        return "mockConfig";
    }

    public void setRelativePath(String relPath) {
        log.error((Object)"Specifying the relative path as a property is deprecated. Please pass it as the 4th argument to the constructor.");
    }

    public void setAbsolutePath(String absPath) {
        log.error((Object)"Specifying the absolute path as a property is deprecated. Please pass it as the 4th argument to the constructor.");
    }

    public List<TileLayer> getTileLayers() {
        return Collections.unmodifiableList(this.gwcConfig.getLayers());
    }

    public Iterable<TileLayer> getLayers() {
        return Collections.unmodifiableList(this.gwcConfig.getLayers());
    }

    @Override
    public TileLayer getTileLayer(String layerName) {
        return this.layers.get(layerName);
    }

    @Override
    public TileLayer getTileLayerById(String layerId) {
        return this.layers.get(layerId);
    }

    @Override
    public boolean containsLayer(String layerId) {
        return this.layers.containsKey(layerId);
    }

    @Override
    public int getTileLayerCount() {
        return this.layers.size();
    }

    @Override
    public Set<String> getTileLayerNames() {
        Set<String> names = Collections.unmodifiableSet(this.layers.keySet());
        return names;
    }

    public String getVersion() {
        return this.gwcConfig.getVersion();
    }
}

