/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.util.DateParseException;
import org.apache.commons.httpclient.util.DateUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCache;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.GeoWebCacheExtensions;
import org.geowebcache.config.Configuration;
import org.geowebcache.conveyor.Conveyor;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.demo.Demo;
import org.geowebcache.filter.request.RequestFilterException;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.OutsideCoverageException;
import org.geowebcache.io.ByteArrayResource;
import org.geowebcache.io.Resource;
import org.geowebcache.layer.BadTileException;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.mime.ImageMime;
import org.geowebcache.service.HttpErrorCodeException;
import org.geowebcache.service.OWSException;
import org.geowebcache.service.Service;
import org.geowebcache.stats.RuntimeStats;
import org.geowebcache.storage.DefaultStorageFinder;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.util.ServletUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoWebCacheDispatcher
extends AbstractController {
    private static Log log = LogFactory.getLog(GeoWebCacheDispatcher.class);
    public static final String TYPE_SERVICE = "service";
    public static final String TYPE_DEMO = "demo";
    public static final String TYPE_HOME = "home";
    private TileLayerDispatcher tileLayerDispatcher = null;
    private DefaultStorageFinder defaultStorageFinder = null;
    private GridSetBroker gridSetBroker = null;
    private StorageBroker storageBroker;
    private RuntimeStats runtimeStats;
    private Map<String, Service> services = null;
    private Resource blankTile = null;
    private String servletPrefix = null;

    public GeoWebCacheDispatcher(TileLayerDispatcher tileLayerDispatcher, GridSetBroker gridSetBroker, StorageBroker storageBroker, Configuration mainConfiguration, RuntimeStats runtimeStats) {
        this.tileLayerDispatcher = tileLayerDispatcher;
        this.gridSetBroker = gridSetBroker;
        this.runtimeStats = runtimeStats;
        this.storageBroker = storageBroker;
        if (mainConfiguration.isRuntimeStatsEnabled()) {
            this.runtimeStats.start();
        } else {
            runtimeStats = null;
        }
    }

    public void setStorageBroker() {
        log.debug((Object)("GeoWebCacheDispatcher received StorageBroker : " + this.storageBroker.toString()));
    }

    public void setDefaultStorageFinder(DefaultStorageFinder defaultStorageFinder) {
        this.defaultStorageFinder = defaultStorageFinder;
    }

    public void setServletPrefix(String servletPrefix) {
        this.servletPrefix = !servletPrefix.startsWith("/") ? "/" + servletPrefix : servletPrefix;
        log.info((Object)("Invoked setServletPrefix(" + servletPrefix + ")"));
    }

    private Map<String, Service> loadServices() {
        log.info((Object)"Loading GWC Service extensions...");
        List<Service> plugins = GeoWebCacheExtensions.extensions(Service.class);
        HashMap<String, Service> services = new HashMap<String, Service>();
        for (Service aService : plugins) {
            services.put(aService.getPathName(), aService);
        }
        log.info((Object)("Done loading GWC Service extensions. Found : " + new ArrayList(services.keySet())));
        return services;
    }

    private void loadBlankTile() {
        String blankTilePath = this.defaultStorageFinder.findEnvVar("GWC_BLANK_TILE_PATH");
        if (blankTilePath != null) {
            File fh = new File(blankTilePath);
            if (fh.exists() && fh.canRead() && fh.isFile()) {
                long fileSize = fh.length();
                this.blankTile = new ByteArrayResource(new byte[(int)fileSize]);
                try {
                    this.loadBlankTile(this.blankTile, fh.toURI().toURL());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (fileSize == this.blankTile.getSize()) {
                    log.info((Object)("Loaded blank tile from " + blankTilePath));
                } else {
                    log.error((Object)("Failed to load blank tile from " + blankTilePath));
                }
                return;
            }
            log.error((Object)("" + blankTilePath + " does not exist or is not readable."));
        }
        try {
            URL url = GeoWebCacheDispatcher.class.getResource("blank.png");
            this.blankTile = new ByteArrayResource();
            this.loadBlankTile(this.blankTile, url);
            int ret = (int)this.blankTile.getSize();
            log.info((Object)("Read " + ret + " from blank PNG file (expected 425)."));
        }
        catch (IOException ioe) {
            log.error((Object)ioe.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBlankTile(Resource blankTile, URL source) throws IOException {
        InputStream inputStream = source.openStream();
        ReadableByteChannel ch = Channels.newChannel(inputStream);
        try {
            blankTile.transferFrom(ch);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            ch.close();
        }
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        block15: {
            String[] requestComps = null;
            try {
                String normalizedURI = request.getRequestURI().replaceFirst(request.getContextPath(), "");
                if (this.servletPrefix != null) {
                    normalizedURI = normalizedURI.replaceFirst(this.servletPrefix, "");
                }
                requestComps = this.parseRequest(normalizedURI);
            }
            catch (GeoWebCacheException gwce) {
                this.writeError(response, 400, gwce.getMessage());
                return null;
            }
            try {
                if (requestComps == null || requestComps[0].equalsIgnoreCase(TYPE_HOME)) {
                    this.handleFrontPage(request, response);
                } else if (requestComps[0].equalsIgnoreCase(TYPE_SERVICE)) {
                    this.handleServiceRequest(requestComps[1], request, response);
                } else if (requestComps[0].equalsIgnoreCase(TYPE_DEMO) || requestComps[0].equalsIgnoreCase("demos")) {
                    this.handleDemoRequest(requestComps[1], request, response);
                } else {
                    this.writeError(response, 404, "Unknown path: " + requestComps[0]);
                }
            }
            catch (HttpErrorCodeException e) {
                this.writeFixedResponse(response, e.getErrorCode(), "text/plain", new ByteArrayResource(e.getMessage().getBytes()), Conveyor.CacheResult.OTHER);
            }
            catch (RequestFilterException e) {
                RequestFilterException reqE = e;
                reqE.setHttpInfoHeader(response);
                this.writeFixedResponse(response, reqE.getResponseCode(), reqE.getContentType(), reqE.getResponse(), Conveyor.CacheResult.OTHER);
            }
            catch (OWSException e) {
                OWSException owsE = e;
                this.writeFixedResponse(response, owsE.getResponseCode(), owsE.getContentType(), owsE.getResponse(), Conveyor.CacheResult.OTHER);
            }
            catch (Exception e) {
                if (!(e instanceof BadTileException) || log.isDebugEnabled()) {
                    log.error((Object)(e.getMessage() + " " + request.getRequestURL().toString()));
                }
                this.writeError(response, 400, e.getMessage());
                if (e instanceof GeoWebCacheException && !log.isDebugEnabled()) break block15;
                e.printStackTrace();
            }
        }
        return null;
    }

    public void destroy() {
        log.info((Object)"GeoWebCacheDispatcher.destroy() was invoked, shutting down.");
    }

    private String[] parseRequest(String servletPath) throws GeoWebCacheException {
        String[] retStrs = new String[2];
        String[] splitStr = servletPath.split("/");
        if (splitStr == null || splitStr.length < 2) {
            return null;
        }
        retStrs[0] = splitStr[1];
        if (splitStr.length > 2) {
            retStrs[1] = splitStr[2];
        }
        return retStrs;
    }

    private void handleServiceRequest(String serviceStr, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Conveyor conv = null;
        Service service = this.findService(serviceStr);
        conv = service.getConveyor(request, response);
        String layerName = conv.getLayerId();
        if (layerName != null && !this.tileLayerDispatcher.getTileLayer(layerName).isEnabled()) {
            throw new OWSException(400, "InvalidParameterValue", "LAYERS", "Layer '" + layerName + "' is disabled");
        }
        if (conv.reqHandler == Conveyor.RequestHandler.SERVICE) {
            service.handleRequest(conv);
        } else {
            ConveyorTile convTile = (ConveyorTile)conv;
            TileLayer layer = this.tileLayerDispatcher.getTileLayer(layerName);
            convTile.setTileLayer(layer);
            layer.applyRequestFilters(convTile);
            try {
                convTile = layer.getTile(convTile);
                this.writeData(convTile);
            }
            catch (OutsideCoverageException e) {
                this.writeEmpty(convTile, e.getMessage());
            }
        }
    }

    private void handleDemoRequest(String action, HttpServletRequest request, HttpServletResponse response) throws GeoWebCacheException {
        Demo.makeMap(this.tileLayerDispatcher, this.gridSetBroker, action, request, response);
    }

    private Service findService(String serviceStr) throws GeoWebCacheException {
        Service service;
        if (this.services == null) {
            this.services = this.loadServices();
            this.loadBlankTile();
        }
        if ((service = this.services.get(serviceStr)) == null) {
            serviceStr = serviceStr == null || serviceStr.length() == 0 ? ", try service/&lt;name of service&gt;" : " \"" + serviceStr + "\"";
            throw new GeoWebCacheException("Unable to find handler for service" + serviceStr);
        }
        return service;
    }

    private void handleFrontPage(HttpServletRequest request, HttpServletResponse response) {
        String baseUrl = null;
        if (request.getRequestURL().toString().endsWith("/") || request.getRequestURL().toString().endsWith(TYPE_HOME)) {
            baseUrl = "";
        } else {
            String[] strs = request.getRequestURL().toString().split("/");
            baseUrl = strs[strs.length - 1] + "/";
        }
        StringBuilder str = new StringBuilder();
        String version = GeoWebCache.getVersion();
        String commitId = GeoWebCache.getBuildRevision();
        if (version == null) {
            version = "{NO VERSION INFO IN MANIFEST}";
        }
        if (commitId == null) {
            commitId = "{NO BUILD INFO IN MANIFEST}";
        }
        str.append("<html>\n" + ServletUtils.gwcHtmlHeader("GWC Home") + "<body>\n" + ServletUtils.gwcHtmlLogoLink(baseUrl));
        str.append("<h3>Welcome to GeoWebCache version " + version + ", build " + commitId + "</h3>\n");
        str.append("<p><a href=\"http://geowebcache.org\">GeoWebCache</a> is an advanced tile cache for WMS servers.");
        str.append("It supports a large variety of protocols and formats, including WMS-C, WMTS, KML, Google Maps and Virtual Earth.</p>");
        str.append("<h3>Automatically Generated Demos:</h3>\n");
        str.append("<ul><li><a href=\"" + baseUrl + "demo\">A list of all the layers and automatic demos</a></li></ul>\n");
        str.append("<h3>GetCapabilities:</h3>\n");
        str.append("<ul><li><a href=\"" + baseUrl + "service/wmts?REQUEST=getcapabilities\">WMTS 1.0.0 GetCapabilities document</a></li>");
        str.append("<li><a href=\"" + baseUrl + "service/wms?SERVICE=WMS&VERSION=1.1.1&REQUEST=getcapabilities&TILED=true\">WMS 1.1.1 GetCapabilities document</a></li>");
        str.append("<li><a href=\"" + baseUrl + "service/tms/1.0.0\">TMS 1.0.0 document</a></li>");
        str.append("<li>Note that the latter will only work with clients that are ");
        str.append("<a href=\"http://wiki.osgeo.org/wiki/WMS_Tiling_Client_Recommendation\">WMS-C capable</a>.</li>\n");
        str.append("<li>Omitting tiled=true from the URL will omit the TileSet elements.</li></ul>\n");
        if (this.runtimeStats != null) {
            str.append("<h3>Runtime Statistics</h3>\n");
            str.append(this.runtimeStats.getHTMLStats());
        }
        str.append("</body></html>\n");
        this.writePage(response, 200, str.toString());
    }

    private void writeError(HttpServletResponse response, int httpCode, String errorMsg) {
        log.debug((Object)errorMsg);
        errorMsg = "<html>\n" + ServletUtils.gwcHtmlHeader("GWC Error") + "<body>\n" + ServletUtils.gwcHtmlLogoLink("../") + "<h4>" + httpCode + ": " + ServletUtils.disableHTMLTags(errorMsg) + "</h4>" + "</body></html>\n";
        this.writePage(response, httpCode, errorMsg);
    }

    private void writePage(HttpServletResponse response, int httpCode, String message) {
        ByteArrayResource res = new ByteArrayResource(message.getBytes());
        this.writeFixedResponse(response, httpCode, "text/html", res, Conveyor.CacheResult.OTHER);
    }

    private void writeData(ConveyorTile tile) throws IOException {
        long tileTimeStamp;
        int contentLength;
        Resource blob;
        String mimeType;
        int httpCode;
        Conveyor.CacheResult cacheResult;
        HttpServletRequest servletReq;
        HttpServletResponse servletResp;
        block6: {
            servletResp = tile.servletResp;
            servletReq = tile.servletReq;
            cacheResult = tile.getCacheResult();
            httpCode = 200;
            mimeType = tile.getMimeType().getMimeType();
            blob = tile.getBlob();
            contentLength = (int)(blob == null ? -1L : blob.getSize());
            servletResp.setHeader("geowebcache-cache-result", String.valueOf((Object)cacheResult));
            servletResp.setHeader("geowebcache-tile-index", Arrays.toString(tile.getTileIndex()));
            long[] tileIndex = tile.getTileIndex();
            TileLayer layer = tile.getLayer();
            GridSubset gridSubset = layer.getGridSubset(tile.getGridSetId());
            BoundingBox tileBounds = gridSubset.boundsFromIndex(tileIndex);
            servletResp.setHeader("geowebcache-tile-bounds", tileBounds.toString());
            servletResp.setHeader("geowebcache-gridset", gridSubset.getName());
            servletResp.setHeader("geowebcache-crs", gridSubset.getSRS().toString());
            tileTimeStamp = tile.getTSCreated();
            String ifModSinceHeader = servletReq.getHeader("If-Modified-Since");
            String lastModified = DateUtil.formatDate((Date)new Date(tileTimeStamp));
            servletResp.setHeader("Last-Modified", lastModified);
            if (ifModSinceHeader != null && ifModSinceHeader.length() > 0) {
                try {
                    Date ifModifiedSince = DateUtil.parseDate((String)ifModSinceHeader);
                    long ifModSinceSeconds = 1000L * (ifModifiedSince.getTime() / 1000L);
                    long tileTimeStampSeconds = 1000L * (tileTimeStamp / 1000L);
                    if (ifModSinceSeconds >= tileTimeStampSeconds) {
                        httpCode = 304;
                        blob = null;
                    }
                }
                catch (DateParseException e) {
                    if (!log.isDebugEnabled()) break block6;
                    log.debug((Object)("Can't parse client's If-Modified-Since header: '" + ifModSinceHeader + "'"));
                }
            }
        }
        if (httpCode == 200 && tile.getLayer().useETags()) {
            String ifNoneMatch = servletReq.getHeader("If-None-Match");
            String hexTag = Long.toHexString(tileTimeStamp);
            if (ifNoneMatch != null && ifNoneMatch.equals(hexTag)) {
                httpCode = 304;
                blob = null;
            }
            servletResp.setHeader("ETag", hexTag);
        }
        this.writeFixedResponse(servletResp, httpCode, mimeType, blob, cacheResult, contentLength);
    }

    private void writeEmpty(ConveyorTile tile, String message) {
        tile.servletResp.setHeader("geowebcache-message", message);
        TileLayer layer = tile.getLayer();
        if (layer != null) {
            layer.setExpirationHeader(tile.servletResp, (int)tile.getTileIndex()[2]);
            if (layer.useETags()) {
                String ifNoneMatch = tile.servletReq.getHeader("If-None-Match");
                if (ifNoneMatch != null && ifNoneMatch.equals("gwc-blank-tile")) {
                    tile.servletResp.setStatus(304);
                    return;
                }
                tile.servletResp.setHeader("ETag", "gwc-blank-tile");
            }
        }
        this.writeFixedResponse(tile.servletResp, 200, ImageMime.png.getMimeType(), this.blankTile, Conveyor.CacheResult.OTHER);
    }

    private void writeFixedResponse(HttpServletResponse response, int httpCode, String contentType, Resource resource, Conveyor.CacheResult cacheRes) {
        int contentLength = (int)(resource == null ? -1L : resource.getSize());
        this.writeFixedResponse(response, httpCode, contentType, resource, cacheRes, contentLength);
    }

    private void writeFixedResponse(HttpServletResponse response, int httpCode, String contentType, Resource resource, Conveyor.CacheResult cacheRes, int contentLength) {
        response.setStatus(httpCode);
        response.setContentType(contentType);
        response.setContentLength(contentLength);
        if (resource != null) {
            try {
                ServletOutputStream os = response.getOutputStream();
                resource.transferTo(Channels.newChannel((OutputStream)os));
                this.runtimeStats.log(contentLength, cacheRes);
            }
            catch (IOException ioe) {
                log.debug((Object)("Caught IOException: " + ioe.getMessage() + "\n\n" + ioe.toString()));
            }
        }
    }
}

