/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.jdbc;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.security.GeoServerAuthenticationProvider;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerSecurityProvider;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.jdbc.JDBCConnectAuthProvider;
import org.geoserver.security.jdbc.JDBCRoleService;
import org.geoserver.security.jdbc.JDBCUserGroupService;
import org.geoserver.security.jdbc.JdbcSecurityConfigValidator;
import org.geoserver.security.jdbc.config.JDBCRoleServiceConfig;
import org.geoserver.security.jdbc.config.JDBCSecurityServiceConfig;
import org.geoserver.security.jdbc.config.JDBCUserGroupServiceConfig;
import org.geoserver.security.validation.SecurityConfigValidator;

public class JDBCSecurityProvider
extends GeoServerSecurityProvider {
    public void configure(XStreamPersister xp) {
        super.configure(xp);
        xp.getXStream().alias("jdbcusergroupservice", JDBCUserGroupServiceConfig.class);
        xp.getXStream().alias("jdbcroleservice", JDBCRoleServiceConfig.class);
    }

    public Map<Class<?>, Set<String>> getFieldsForEncryption() {
        HashMap map = new HashMap();
        HashSet<String> fields = new HashSet<String>();
        fields.add("password");
        map.put(JDBCSecurityServiceConfig.class, fields);
        return map;
    }

    public Class<? extends GeoServerUserGroupService> getUserGroupServiceClass() {
        return JDBCUserGroupService.class;
    }

    public GeoServerUserGroupService createUserGroupService(SecurityNamedServiceConfig config) throws IOException {
        return new JDBCUserGroupService();
    }

    public Class<? extends GeoServerRoleService> getRoleServiceClass() {
        return JDBCRoleService.class;
    }

    public GeoServerRoleService createRoleService(SecurityNamedServiceConfig config) throws IOException {
        return new JDBCRoleService();
    }

    public SecurityConfigValidator createConfigurationValidator(GeoServerSecurityManager securityManager) {
        return new JdbcSecurityConfigValidator(securityManager);
    }

    public Class<JDBCConnectAuthProvider> getAuthenticationProviderClass() {
        return JDBCConnectAuthProvider.class;
    }

    public GeoServerAuthenticationProvider createAuthenticationProvider(SecurityNamedServiceConfig config) {
        return new JDBCConnectAuthProvider();
    }
}

