/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.jdbc;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.io.FileUtils;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.impl.AbstractGeoServerSecurityService;
import org.geoserver.security.jdbc.config.JDBCSecurityServiceConfig;
import org.geotools.util.logging.Logging;

public abstract class AbstractJDBCService
extends AbstractGeoServerSecurityService {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security.jdbc");
    protected Properties ddlProps;
    protected Properties dmlProps;
    protected DataSource datasource;
    static final int DEFAULT_ISOLATION_LEVEL = 2;

    protected AbstractJDBCService() {
    }

    public void initializeDSFromConfig(SecurityNamedServiceConfig namedConfig) throws IOException {
        JDBCSecurityServiceConfig config = (JDBCSecurityServiceConfig)namedConfig;
        if (config.isJndi()) {
            String jndiName = config.getJndiName();
            try {
                InitialContext initialContext = new InitialContext();
                this.datasource = (DataSource)initialContext.lookup(jndiName);
            }
            catch (NamingException e) {
                throw new IOException(e);
            }
        } else {
            BasicDataSource bds = new BasicDataSource();
            bds.setDriverClassName(config.getDriverClassName());
            bds.setUrl(config.getConnectURL());
            bds.setUsername(config.getUserName());
            bds.setPassword(config.getPassword());
            bds.setDefaultAutoCommit(false);
            bds.setDefaultTransactionIsolation(2);
            bds.setMaxActive(10);
            this.datasource = bds;
        }
    }

    protected DataSource getDataSource() {
        return this.datasource;
    }

    protected Connection getConnection() throws SQLException {
        Connection con = this.getDataSource().getConnection();
        if (con.getAutoCommit()) {
            con.setAutoCommit(false);
        }
        if (con.getTransactionIsolation() != 2) {
            con.setTransactionIsolation(2);
        }
        return con;
    }

    protected void closeConnection(Connection con) throws SQLException {
        con.close();
    }

    protected void closeFinally(Connection con, PreparedStatement ps, ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException ex) {
            // empty catch block
        }
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException ex) {
            // empty catch block
        }
        try {
            if (con != null) {
                this.closeConnection(con);
            }
        }
        catch (SQLException ex) {
            // empty catch block
        }
    }

    protected PreparedStatement getDMLStatement(String key, Connection con) throws IOException, SQLException {
        return this.getJDBCStatement(key, this.dmlProps, con);
    }

    protected PreparedStatement getJDBCStatement(String key, Properties props, Connection con) throws IOException, SQLException {
        String statementString = props.getProperty(key);
        if (statementString == null || statementString.trim().length() == 0) {
            throw new IOException("No sql statement for key : " + key);
        }
        return con.prepareStatement(statementString.trim());
    }

    protected PreparedStatement getDDLStatement(String key, Connection con) throws IOException, SQLException {
        return this.getJDBCStatement(key, this.ddlProps, con);
    }

    protected boolean convertFromString(String booleanString) {
        if (booleanString == null) {
            return false;
        }
        return "y".equalsIgnoreCase(booleanString);
    }

    protected String convertToString(boolean b) {
        return b ? "Y" : "N";
    }

    protected abstract String[] getOrderedNamesForCreate();

    protected abstract String[] getOrderedNamesForDrop();

    public void createTablesIfRequired(JDBCSecurityServiceConfig config) throws IOException {
        if (!this.canCreateStore()) {
            return;
        }
        if (!config.isCreatingTables()) {
            return;
        }
        if (this.tablesAlreadyCreated()) {
            return;
        }
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.datasource.getConnection();
            if (con.getAutoCommit()) {
                con.setAutoCommit(false);
            }
            con = this.getConnection();
            for (String stmt : this.getOrderedNamesForCreate()) {
                ps = this.getDDLStatement(stmt, con);
                ps.execute();
                ps.close();
            }
            con.commit();
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
        finally {
            this.closeFinally(con, ps, null);
        }
    }

    public void createTables() throws IOException {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            for (String stmt : this.getOrderedNamesForCreate()) {
                ps = this.getDDLStatement(stmt, con);
                ps.execute();
                ps.close();
            }
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
        finally {
            this.closeFinally(con, ps, null);
        }
    }

    public void dropTables() throws IOException {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            for (String stmt : this.getOrderedNamesForDrop()) {
                ps = this.getDDLStatement(stmt, con);
                ps.execute();
                ps.close();
            }
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
        finally {
            this.closeFinally(con, ps, null);
        }
    }

    public Map<String, SQLException> checkDMLStatements() throws IOException {
        return this.checkSQLStatements(this.dmlProps);
    }

    public Map<String, SQLException> checkDDLStatements() throws IOException {
        return this.checkSQLStatements(this.ddlProps);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean tablesAlreadyCreated() throws IOException {
        ResultSet rs = null;
        Connection con = null;
        try {
            con = this.getConnection();
            DatabaseMetaData md = con.getMetaData();
            String schemaName = null;
            String tableName = this.ddlProps.getProperty("check.table");
            if (tableName.contains(".")) {
                StringTokenizer tok = new StringTokenizer(tableName, ".");
                schemaName = tok.nextToken();
                tableName = tok.nextToken();
            }
            if ((rs = md.getTables(null, schemaName, tableName, null)).next()) {
                boolean bl = true;
                return bl;
            }
            rs.close();
            schemaName = schemaName == null ? null : schemaName.toUpperCase();
            tableName = tableName.toUpperCase();
            rs = md.getTables(null, schemaName, tableName, null);
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
            rs.close();
            schemaName = schemaName == null ? null : schemaName.toLowerCase();
            tableName = tableName.toLowerCase();
            rs = md.getTables(null, schemaName, tableName, null);
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (con != null) {
                    this.closeConnection(con);
                }
            }
            catch (SQLException e) {}
        }
    }

    protected Map<String, SQLException> checkSQLStatements(Properties props) throws IOException {
        HashMap<String, SQLException> reportMap = new HashMap<String, SQLException>();
        Connection con = null;
        try {
            con = this.getConnection();
            for (Object key : props.keySet()) {
                String stmt = props.getProperty(key.toString()).trim();
                try {
                    con.prepareStatement(stmt.trim());
                }
                catch (SQLException ex) {
                    reportMap.put(key.toString() + "|" + stmt, ex);
                }
            }
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
        finally {
            this.closeFinally(con, null, null);
        }
        return reportMap;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass() + " : " + this.getName();
    }

    protected File checkORCreateJDBCPropertyFile(String fileName, File namedRoot, String defaultResource) throws IOException {
        File file = new File(fileName = fileName != null ? fileName : defaultResource);
        if (!file.isAbsolute()) {
            file = new File(namedRoot, fileName);
        }
        if (file.exists()) {
            return file;
        }
        URL url = ((Object)((Object)this)).getClass().getResource(fileName);
        if (url != null) {
            FileUtils.copyURLToFile((URL)url, (File)file);
        } else {
            FileUtils.copyURLToFile((URL)((Object)((Object)this)).getClass().getResource(defaultResource), (File)file);
        }
        return file;
    }
}

