/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.demo;

import com.vividsolutions.jts.geom.Geometry;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.basic.MultiLineLabel;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.geoserver.web.GeoServerBasePage;
import org.geoserver.web.wicket.CRSPanel;
import org.geoserver.web.wicket.GeoServerAjaxFormLink;
import org.geoserver.web.wicket.GeometryTextArea;
import org.geoserver.web.wicket.SRSToCRSModel;
import org.geoserver.web.wicket.SimpleAjaxLink;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class ReprojectPage
extends GeoServerBasePage {
    String sourceCRS;
    String targetCRS;
    GeometryTextArea sourceGeom;
    GeometryTextArea targetGeom;
    ModalWindow popupWindow;
    GeoServerAjaxFormLink wktLink;
    SimpleAjaxLink<Void> sourceDetails;
    SimpleAjaxLink<Void> targetDetails;

    public ReprojectPage(PageParameters params) {
        if (params != null) {
            this.sourceCRS = params.getString("fromSRS");
            this.targetCRS = params.getString("toSRS");
        }
        this.popupWindow = new ModalWindow("popup");
        this.add(new Component[]{this.popupWindow});
        Form form = new Form("form");
        this.add(new Component[]{form});
        CRSPanel sourcePanel = new CRSPanel("sourceCRS", (IModel)new SRSToCRSModel((IModel)new PropertyModel((Object)this, "sourceCRS"))){

            protected void onSRSUpdated(String srs, AjaxRequestTarget target) {
                ReprojectPage.this.sourceCRS = srs;
                ReprojectPage.this.updateTransformation(target);
            }
        };
        sourcePanel.setRequired(true);
        form.add(new Component[]{sourcePanel});
        CRSPanel targetPanel = new CRSPanel("targetCRS", (IModel)new SRSToCRSModel((IModel)new PropertyModel((Object)this, "targetCRS"))){

            protected void onSRSUpdated(String srs, AjaxRequestTarget target) {
                ReprojectPage.this.targetCRS = srs;
                ReprojectPage.this.updateTransformation(target);
            }
        };
        targetPanel.setRequired(true);
        form.add(new Component[]{targetPanel});
        this.wktLink = new GeoServerAjaxFormLink("wkt", form){

            public void onClick(AjaxRequestTarget target, Form form) {
                ReprojectPage.this.popupWindow.setInitialHeight(525);
                ReprojectPage.this.popupWindow.setInitialWidth(525);
                ReprojectPage.this.popupWindow.setContent((Component)new WKTPanel(ReprojectPage.this.popupWindow.getContentId()));
                ReprojectPage.this.popupWindow.setTitle(ReprojectPage.this.sourceCRS + " -> " + ReprojectPage.this.targetCRS);
                ReprojectPage.this.popupWindow.show(target);
            }
        };
        this.wktLink.setEnabled(false);
        form.add(new Component[]{this.wktLink});
        this.sourceGeom = new GeometryTextArea("sourceGeom");
        form.add(new Component[]{this.sourceGeom});
        this.sourceGeom.setOutputMarkupId(true);
        this.targetGeom = new GeometryTextArea("targetGeom");
        this.targetGeom.setOutputMarkupId(true);
        form.add(new Component[]{this.targetGeom});
        AjaxSubmitLink forward = new AjaxSubmitLink("forward", form){

            protected void onSubmit(AjaxRequestTarget at, Form<?> form) {
                Geometry source = (Geometry)ReprojectPage.this.sourceGeom.getModelObject();
                if (source == null) {
                    this.error((Serializable)((Object)"Source point is not specified"));
                } else {
                    MathTransform mt = ReprojectPage.this.getTransform();
                    if (mt != null) {
                        try {
                            Geometry target = JTS.transform((Geometry)source, (MathTransform)mt);
                            ReprojectPage.this.targetGeom.setModelObject((Object)target);
                            at.addComponent((Component)ReprojectPage.this.targetGeom);
                        }
                        catch (Exception e) {
                            this.error((Serializable)((Object)e.getMessage()));
                        }
                    }
                }
                at.addComponent((Component)ReprojectPage.this.feedbackPanel);
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                target.addComponent((Component)ReprojectPage.this.feedbackPanel);
            }
        };
        form.add(new Component[]{forward});
        AjaxSubmitLink backward = new AjaxSubmitLink("backward", form){

            protected void onSubmit(AjaxRequestTarget at, Form<?> form) {
                Geometry target = (Geometry)ReprojectPage.this.targetGeom.getModelObject();
                if (target == null) {
                    this.error((Serializable)((Object)"Target point is not specified"));
                } else {
                    MathTransform mt = ReprojectPage.this.getTransform();
                    if (mt != null) {
                        try {
                            Geometry source = JTS.transform((Geometry)target, (MathTransform)mt.inverse());
                            ReprojectPage.this.sourceGeom.setModelObject((Object)source);
                            at.addComponent((Component)ReprojectPage.this.sourceGeom);
                        }
                        catch (Exception e) {
                            this.error((Serializable)((Object)e.getMessage()));
                        }
                    }
                }
                at.addComponent((Component)ReprojectPage.this.feedbackPanel);
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                target.addComponent((Component)ReprojectPage.this.feedbackPanel);
            }
        };
        form.add(new Component[]{backward});
    }

    protected void updateTransformation(AjaxRequestTarget ajaxTarget) {
        MathTransform mt;
        if (this.sourceCRS != null && this.targetCRS != null && (mt = this.getTransform()) != null) {
            this.wktLink.setEnabled(true);
            ajaxTarget.addComponent((Component)this.wktLink);
        }
    }

    protected MathTransform getTransform() {
        try {
            CoordinateReferenceSystem source = CRS.decode((String)this.sourceCRS);
            CoordinateReferenceSystem target = CRS.decode((String)this.targetCRS);
            return CRS.findMathTransform((CoordinateReferenceSystem)source, (CoordinateReferenceSystem)target, (boolean)true);
        }
        catch (Exception e) {
            this.error((Serializable)((Object)e.getMessage()));
            return null;
        }
    }

    class WKTPanel
    extends Panel {
        public WKTPanel(String id) {
            super(id);
            MultiLineLabel wktLabel = new MultiLineLabel("wkt");
            this.add(new Component[]{wktLabel});
            MathTransform mt = ReprojectPage.this.getTransform();
            if (mt != null) {
                wktLabel.setDefaultModel((IModel)new Model((Serializable)((Object)mt.toString())));
            }
        }
    }
}

