/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.demo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxCallDecorator;
import org.apache.wicket.ajax.calldecorator.AjaxCallDecorator;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.protocol.http.WebRequest;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.web.GeoServerBasePage;
import org.geoserver.web.demo.DemoRequest;
import org.geoserver.web.demo.DemoRequestResponse;
import org.geoserver.web.wicket.CodeMirrorEditor;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.global.ConfigurationException;
import org.vfny.geoserver.global.GeoserverDataDirectory;

public class DemoRequestsPage
extends GeoServerBasePage {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geoserver.web.demo");
    private final File demoDir;
    private TextField urlTextField;
    private CodeMirrorEditor body;
    private TextField username;
    private PasswordTextField password;

    public DemoRequestsPage() {
        try {
            this.demoDir = GeoserverDataDirectory.findCreateConfigDir((String)"demo/");
        }
        catch (ConfigurationException e) {
            throw new WicketRuntimeException("Can't access demo requests directory: " + e.getMessage());
        }
        DemoRequest model = new DemoRequest(this.demoDir);
        this.setDefaultModel((IModel)new Model((Serializable)model));
        this.setUpDemoRequestsForm(this.demoDir);
    }

    DemoRequestsPage(File demoDir) {
        this.demoDir = demoDir;
        DemoRequest model = new DemoRequest(demoDir);
        this.setDefaultModel((IModel)new Model((Serializable)model));
        this.setUpDemoRequestsForm(demoDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFileContents(String reqFileName) throws IOException {
        File file = new File(this.demoDir, reqFileName);
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
        }
        finally {
            reader.close();
        }
        return sb.toString();
    }

    private void setUpDemoRequestsForm(File demoDir) {
        final IModel requestModel = this.getDefaultModel();
        Form demoRequestsForm = new Form("demoRequestsForm");
        demoRequestsForm.setOutputMarkupId(true);
        demoRequestsForm.setModel(requestModel);
        this.add(new Component[]{demoRequestsForm});
        List<String> demoList = this.getDemoList(demoDir);
        PropertyModel reqFileNameModel = new PropertyModel((Object)requestModel, "requestFileName");
        final DropDownChoice demoRequestsList = new DropDownChoice("demoRequestsList", (IModel)reqFileNameModel, demoList, new IChoiceRenderer(){

            public String getIdValue(Object obj, int index) {
                return String.valueOf(obj);
            }

            public Object getDisplayValue(Object obj) {
                return obj;
            }
        });
        demoRequestsForm.add(new Component[]{demoRequestsList});
        demoRequestsList.add(new IBehavior[]{new AjaxFormSubmitBehavior(demoRequestsForm, "onchange"){

            protected void onSubmit(AjaxRequestTarget target) {
                String contents;
                String reqFileName = demoRequestsList.getModelValue();
                WebRequest request = (WebRequest)DemoRequestsPage.this.getRequest();
                HttpServletRequest httpServletRequest = request.getHttpServletRequest();
                String baseUrl = ResponseUtils.baseURL((HttpServletRequest)httpServletRequest);
                try {
                    contents = DemoRequestsPage.this.getFileContents(reqFileName);
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Can't load demo file " + reqFileName, e);
                    throw new WicketRuntimeException("Can't load demo file " + reqFileName, (Throwable)e);
                }
                boolean demoRequestIsHttpGet = reqFileName.endsWith(".url");
                String service = reqFileName.substring(0, reqFileName.indexOf(95)).toLowerCase();
                String serviceUrl = baseUrl + service;
                if (demoRequestIsHttpGet) {
                    String url = baseUrl + contents;
                    DemoRequestsPage.this.urlTextField.setModelObject((Object)url);
                    DemoRequestsPage.this.body.setModelObject((Object)"");
                } else {
                    DemoRequestsPage.this.urlTextField.setModelObject((Object)serviceUrl);
                    DemoRequestsPage.this.body.setModelObject((Object)contents);
                }
                DemoRequestsPage.this.setResponsePage((Page)DemoRequestsPage.this);
            }

            protected void onError(AjaxRequestTarget target) {
            }
        }});
        this.urlTextField = new TextField("url", (IModel)new PropertyModel((Object)requestModel, "requestUrl"));
        this.urlTextField.setMarkupId("requestUrl");
        this.urlTextField.setOutputMarkupId(true);
        demoRequestsForm.add(new Component[]{this.urlTextField});
        this.body = new CodeMirrorEditor("body", (IModel)new PropertyModel((Object)requestModel, "requestBody"));
        this.body.setTextAreaMarkupId("requestBody");
        demoRequestsForm.add(new Component[]{this.body});
        this.username = new TextField("username", (IModel)new PropertyModel((Object)requestModel, "userName"));
        demoRequestsForm.add(new Component[]{this.username});
        this.password = new PasswordTextField("password", (IModel)new PropertyModel((Object)requestModel, "password"));
        this.password.setRequired(false);
        demoRequestsForm.add(new Component[]{this.password});
        final ModalWindow responseWindow = new ModalWindow("responseWindow");
        this.add(new Component[]{responseWindow});
        responseWindow.setPageMapName("demoResponse");
        responseWindow.setCookieName("demoResponse");
        responseWindow.setPageCreator(new ModalWindow.PageCreator(){

            public Page createPage() {
                return new DemoRequestResponse(requestModel);
            }
        });
        demoRequestsForm.add(new Component[]{new AjaxSubmitLink("submit", demoRequestsForm){

            public void onSubmit(AjaxRequestTarget target, Form testWfsPostForm) {
                responseWindow.show(target);
            }

            protected IAjaxCallDecorator getAjaxCallDecorator() {
                return new AjaxCallDecorator(){

                    public CharSequence decorateScript(CharSequence script) {
                        return "document.getElementById('requestBody').value = document.gsEditors.requestBody.getCode();" + script;
                    }
                };
            }
        }});
    }

    private List<String> getDemoList(File demoDir) {
        ArrayList<String> demoList = new ArrayList<String>();
        for (File file : demoDir.listFiles()) {
            if (file.isDirectory()) continue;
            String name = file.getName();
            if (name.endsWith(".url") || name.endsWith(".xml")) {
                demoList.add(name);
                continue;
            }
            LOGGER.warning("Ignoring file " + name + " in demo requests directory, only .url and .xml files allowed");
        }
        Collections.sort(demoList);
        return demoList;
    }
}

