/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service.wms;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.Conveyor;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.filter.request.RequestFilterException;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.OutsideCoverageException;
import org.geowebcache.grid.SRS;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.mime.ImageMime;
import org.geowebcache.mime.MimeType;
import org.geowebcache.stats.RuntimeStats;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.util.AccountingOutputStream;
import org.geowebcache.util.ServletUtils;

public class WMSTileFuser {
    private static Log log = LogFactory.getLog(WMSTileFuser.class);
    final StorageBroker sb;
    final GridSubset gridSubset;
    final TileLayer layer;
    final ImageMime outputFormat;
    ImageMime srcFormat;
    int reqHeight;
    int reqWidth;
    final BoundingBox reqBounds;
    double xResolution;
    double yResolution;
    double srcResolution;
    int srcIdx;
    long[] srcRectangle;
    BoundingBox srcBounds;
    BoundingBox canvasBounds;
    int[] canvasSize = new int[2];
    int[] canvOfs = new int[4];
    double[] boundOfs = new double[4];
    BufferedImage canvas;
    Graphics2D gfx;
    private Map<String, String> fullParameters;

    protected WMSTileFuser(TileLayerDispatcher tld, StorageBroker sb, HttpServletRequest servReq) throws GeoWebCacheException {
        this.sb = sb;
        String[] keys = new String[]{"layers", "format", "srs", "bbox", "width", "height", "transparent", "bgcolor"};
        Map values = ServletUtils.selectedStringsFromMap((Map)servReq.getParameterMap(), (String)servReq.getCharacterEncoding(), (String[])keys);
        String layerName = (String)values.get("layers");
        this.layer = tld.getTileLayer(layerName);
        List ml = this.layer.getMimeTypes();
        for (MimeType mt : ml) {
            if (!mt.getInternalName().equalsIgnoreCase("png")) continue;
            this.srcFormat = (ImageMime)mt;
        }
        this.gridSubset = this.layer.getGridSubsetForSRS(SRS.getSRS((String)((String)values.get("srs"))));
        this.outputFormat = (ImageMime)ImageMime.createFromFormat((String)((String)values.get("format")));
        this.reqBounds = new BoundingBox((String)values.get("bbox"));
        this.reqWidth = Integer.valueOf((String)values.get("width"));
        this.reqHeight = Integer.valueOf((String)values.get("height"));
        this.fullParameters = this.layer.getModifiableParameters(servReq.getParameterMap(), servReq.getCharacterEncoding());
    }

    protected WMSTileFuser(TileLayer layer, GridSubset gridSubset, BoundingBox bounds, int width, int height) {
        this.sb = null;
        this.outputFormat = ImageMime.png;
        this.layer = layer;
        this.gridSubset = gridSubset;
        this.reqBounds = bounds;
        this.reqWidth = width;
        this.reqHeight = height;
        this.fullParameters = Collections.emptyMap();
    }

    protected void determineSourceResolution() {
        this.xResolution = this.reqBounds.getWidth() / (double)this.reqWidth;
        this.yResolution = this.reqBounds.getHeight() / (double)this.reqHeight;
        double tmpResolution = this.yResolution < this.xResolution ? this.yResolution : this.xResolution;
        log.debug((Object)("x res: " + this.xResolution + " y res: " + this.yResolution + " tmpResolution: " + tmpResolution));
        double compResolution = 1.005 * tmpResolution;
        double[] resArray = this.gridSubset.getResolutions();
        this.srcIdx = 0;
        while (this.srcIdx < resArray.length) {
            this.srcResolution = resArray[this.srcIdx];
            if (this.srcResolution < compResolution) break;
            ++this.srcIdx;
        }
        if (this.srcIdx >= resArray.length) {
            this.srcIdx = resArray.length - 1;
        }
        log.debug((Object)("z: " + this.srcIdx + " , resolution: " + this.srcResolution + " (" + tmpResolution + ")"));
    }

    protected void determineCanvasLayout() {
        this.srcRectangle = this.gridSubset.getCoverageIntersection(this.srcIdx, this.reqBounds);
        this.srcBounds = this.gridSubset.boundsFromRectangle(this.srcRectangle);
        this.boundOfs[0] = this.srcBounds.getMinX() - this.reqBounds.getMinX();
        this.boundOfs[1] = this.srcBounds.getMinY() - this.reqBounds.getMinY();
        this.boundOfs[2] = this.reqBounds.getMaxX() - this.srcBounds.getMaxX();
        this.boundOfs[3] = this.reqBounds.getMaxY() - this.srcBounds.getMaxY();
        this.canvasSize[0] = (int)Math.round(this.reqBounds.getWidth() / this.srcResolution);
        this.canvasSize[1] = (int)Math.round(this.reqBounds.getHeight() / this.srcResolution);
        for (int i = 0; i < 4; ++i) {
            this.canvOfs[i] = (int)Math.round(this.boundOfs[i] / this.srcResolution);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("intersection rectangle: " + Arrays.toString(this.srcRectangle)));
            log.debug((Object)("intersection bounds: " + this.srcBounds + " (" + this.reqBounds + ")"));
            log.debug((Object)("Bound offsets: " + Arrays.toString(this.boundOfs)));
            log.debug((Object)("Canvas size: " + Arrays.toString(this.canvasSize) + "(" + this.reqWidth + "," + this.reqHeight + ")"));
            log.debug((Object)("Canvas offsets: " + Arrays.toString(this.canvOfs)));
        }
    }

    protected void createCanvas() {
        int canvasType;
        Color bgColor = null;
        boolean transparent = true;
        if (this.layer instanceof WMSLayer) {
            WMSLayer wmsLayer = (WMSLayer)this.layer;
            int[] colorAr = wmsLayer.getBackgroundColor();
            if (colorAr != null) {
                bgColor = new Color(colorAr[0], colorAr[1], colorAr[2]);
            }
            transparent = wmsLayer.getTransparent();
        }
        if (bgColor == null && transparent && (this.outputFormat.supportsAlphaBit() || this.outputFormat.supportsAlphaChannel())) {
            canvasType = 2;
        } else {
            canvasType = 1;
            if (bgColor == null) {
                bgColor = Color.WHITE;
            }
        }
        this.canvas = new BufferedImage(this.canvasSize[0], this.canvasSize[1], canvasType);
        this.gfx = (Graphics2D)this.canvas.getGraphics();
        if (bgColor != null) {
            this.gfx.setColor(bgColor);
            this.gfx.fillRect(0, 0, this.canvasSize[0], this.canvasSize[1]);
        }
    }

    protected void renderCanvas() throws OutsideCoverageException, GeoWebCacheException, IOException {
        long starty;
        for (long gridy = starty = this.srcRectangle[1]; gridy <= this.srcRectangle[3]; ++gridy) {
            long startx;
            int tiley = 0;
            int canvasy = (int)(this.srcRectangle[3] - gridy) * this.gridSubset.getTileHeight();
            int tileHeight = this.gridSubset.getTileHeight();
            if (this.canvOfs[3] > 0) {
                canvasy += this.canvOfs[3];
            } else if (gridy == this.srcRectangle[3]) {
                tileHeight += this.canvOfs[3];
                tiley = -this.canvOfs[3];
            } else {
                canvasy += this.canvOfs[3];
            }
            if (gridy == this.srcRectangle[1] && this.canvOfs[1] < 0) {
                tileHeight += this.canvOfs[1];
            }
            for (long gridx = startx = this.srcRectangle[0]; gridx <= this.srcRectangle[2]; ++gridx) {
                long[] gridLoc = new long[]{gridx, gridy, this.srcIdx};
                ConveyorTile tile = new ConveyorTile(this.sb, this.layer.getName(), this.gridSubset.getName(), gridLoc, (MimeType)ImageMime.png, this.fullParameters, null, null);
                try {
                    this.layer.applyRequestFilters(tile);
                }
                catch (RequestFilterException e) {
                    log.debug((Object)e.getMessage());
                    continue;
                }
                this.layer.getTile(tile);
                BufferedImage tileImg = ImageIO.read(tile.getBlob().getInputStream());
                int tilex = 0;
                int canvasx = (int)(gridx - startx) * this.gridSubset.getTileWidth();
                int tileWidth = this.gridSubset.getTileWidth();
                if (this.canvOfs[0] > 0) {
                    canvasx += this.canvOfs[0];
                } else if (gridx == this.srcRectangle[0]) {
                    tileWidth += this.canvOfs[0];
                    tilex = -this.canvOfs[0];
                } else {
                    canvasx += this.canvOfs[0];
                }
                if (gridx == this.srcRectangle[2] && this.canvOfs[2] < 0) {
                    tileWidth += this.canvOfs[2];
                }
                if (tileWidth == 0 || tileHeight == 0) {
                    log.debug((Object)("tileWidth: " + tileWidth + " tileHeight: " + tileHeight));
                    continue;
                }
                if (tileWidth != this.gridSubset.getTileWidth() || tileHeight != this.gridSubset.getTileHeight()) {
                    log.debug((Object)("tileImg.getSubimage(" + tilex + "," + tiley + "," + tileWidth + "," + tileHeight + ")"));
                    tileImg = tileImg.getSubimage(tilex, tiley, tileWidth, tileHeight);
                }
                log.debug((Object)("drawImage(subtile," + canvasx + "," + canvasy + ",null) " + Arrays.toString(gridLoc)));
                this.gfx.drawImage((Image)tileImg, canvasx, canvasy, null);
            }
        }
        this.gfx.dispose();
    }

    protected void scaleRaster() {
        if (this.canvasSize[0] != this.reqWidth || this.canvasSize[1] != this.reqHeight) {
            BufferedImage preTransform = this.canvas;
            this.canvas = new BufferedImage(this.reqWidth, this.reqHeight, preTransform.getType());
            Graphics2D gfx = this.canvas.createGraphics();
            AffineTransform affineTrans = AffineTransform.getScaleInstance((double)this.reqWidth / (double)preTransform.getWidth(), (double)this.reqHeight / (double)preTransform.getHeight());
            log.debug((Object)("AffineTransform: " + (double)this.reqWidth / (double)preTransform.getWidth() + "," + (double)this.reqHeight / (double)preTransform.getHeight()));
            gfx.drawRenderedImage(preTransform, affineTrans);
            gfx.dispose();
        }
    }

    protected void writeResponse(HttpServletResponse response, RuntimeStats stats) throws IOException, OutsideCoverageException, GeoWebCacheException {
        this.determineSourceResolution();
        this.determineCanvasLayout();
        this.createCanvas();
        this.renderCanvas();
        this.scaleRaster();
        response.setStatus(200);
        response.setContentType(this.outputFormat.getMimeType());
        response.setCharacterEncoding("UTF-8");
        ServletOutputStream os = response.getOutputStream();
        AccountingOutputStream aos = new AccountingOutputStream(os);
        try {
            ImageIO.write((RenderedImage)this.canvas, this.outputFormat.getInternalName(), (OutputStream)aos);
            aos.close();
        }
        catch (IOException ioe) {
            log.debug((Object)("IOException writing untiled response to client: " + ioe.getMessage()));
        }
        log.debug((Object)("WMS response size: " + aos.getCount() + "bytes."));
        stats.log(aos.getCount(), Conveyor.CacheResult.WMS);
    }
}

