/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.security.ldap;

import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxCheckBox;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.security.ldap.LDAPSecurityServiceConfig;
import org.geoserver.security.web.auth.AuthenticationProviderPanel;
import org.geoserver.security.web.usergroup.UserGroupServiceChoice;
import org.geoserver.web.GeoServerBasePage;
import org.geoserver.web.util.MapModel;

public class LDAPAuthProviderPanel
extends AuthenticationProviderPanel<LDAPSecurityServiceConfig> {
    public LDAPAuthProviderPanel(String id, IModel<LDAPSecurityServiceConfig> model) {
        super(id, model);
        this.add(new Component[]{new TextField("serverURL").setRequired(true)});
        this.add(new Component[]{new CheckBox("useTLS")});
        this.add(new Component[]{new TextField("userDnPattern")});
        boolean useLdapAuth = ((LDAPSecurityServiceConfig)((Object)model.getObject())).getUserGroupServiceName() == null;
        this.add(new Component[]{new AjaxCheckBox("useLdapAuthorization", (IModel)new Model((Serializable)Boolean.valueOf(useLdapAuth))){

            protected void onUpdate(AjaxRequestTarget target) {
                WebMarkupContainer c = (WebMarkupContainer)LDAPAuthProviderPanel.this.get("authorizationPanelContainer");
                ((AuthorizationPanel)c.get("authorizationPanel")).resetModel();
                c.remove("authorizationPanel");
                c.add(new Component[]{LDAPAuthProviderPanel.this.createAuthorizationPanel("authorizationPanel", (Boolean)this.getModelObject())});
                target.addComponent((Component)c);
            }
        }});
        this.add(new Component[]{new WebMarkupContainer("authorizationPanelContainer").add(new Component[]{this.createAuthorizationPanel("authorizationPanel", useLdapAuth)}).setOutputMarkupId(true)});
        this.add(new Component[]{new TestLDAPConnectionPanel("testCx")});
    }

    AuthorizationPanel createAuthorizationPanel(String id, boolean useLDAP) {
        return useLDAP ? new LDAPAuthorizationPanel(id) : new UserGroupAuthorizationPanel(id);
    }

    class TestLDAPConnectionPanel
    extends FormComponentPanel {
        public TestLDAPConnectionPanel(String id) {
            super(id, (IModel)new Model(new HashMap()));
            this.add(new Component[]{new TextField("username", (IModel)new MapModel(this.getModel(), "username"))});
            this.add(new Component[]{new PasswordTextField("password", (IModel)new MapModel(this.getModel(), "password")).setRequired(false)});
            this.add(new Component[]{new AjaxSubmitLink("test"){

                protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                    ((FormComponent)TestLDAPConnectionPanel.this.get("username")).processInput();
                    ((FormComponent)TestLDAPConnectionPanel.this.get("password")).processInput();
                    ((FormComponent)LDAPAuthProviderPanel.this.get("serverURL")).processInput();
                    ((FormComponent)LDAPAuthProviderPanel.this.get("useTLS")).processInput();
                    ((FormComponent)LDAPAuthProviderPanel.this.get("userDnPattern")).processInput();
                    Map map = (Map)TestLDAPConnectionPanel.this.getDefaultModelObject();
                    String username = (String)map.get("username");
                    String password = (String)map.get("password");
                    LDAPSecurityServiceConfig ldapConfig = (LDAPSecurityServiceConfig)((Object)this.getForm().getModelObject());
                    this.doTest(ldapConfig, username, password);
                    target.addComponent(((GeoServerBasePage)this.getPage()).get("feedback"));
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                void doTest(LDAPSecurityServiceConfig ldapConfig, String username, String password) {
                    Context ctx = null;
                    try {
                        Hashtable<String, String> env = new Hashtable<String, String>(11);
                        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
                        env.put("java.naming.provider.url", ldapConfig.getServerURL());
                        env.put("java.naming.security.authentication", "simple");
                        URI url = new URI(ldapConfig.getServerURL());
                        if (ldapConfig.getUserDnPattern() == null) {
                            this.error((Serializable)((Object)"No user dn pattern specified"));
                            return;
                        }
                        String p = ldapConfig.getUserDnPattern().replaceAll("\\{0\\}", username) + "," + url.getPath().substring(1);
                        env.put("java.naming.security.principal", p);
                        env.put("java.naming.security.credentials", password);
                        ctx = new InitialLdapContext(env, null);
                        this.info((String)new StringResourceModel(LDAPAuthProviderPanel.class.getSimpleName() + ".connectionSuccessful", null).getObject());
                    }
                    catch (Exception e) {
                        this.error(e);
                        LOGGER.log(Level.WARNING, e.getMessage(), e);
                    }
                    finally {
                        if (ctx != null) {
                            try {
                                ctx.close();
                            }
                            catch (NamingException e) {}
                        }
                    }
                }
            }.setDefaultFormProcessing(false)});
        }
    }

    class LDAPAuthorizationPanel
    extends AuthorizationPanel {
        public LDAPAuthorizationPanel(String id) {
            super(id);
            this.add(new Component[]{new TextField("groupSearchBase")});
            this.add(new Component[]{new TextField("groupSearchFilter")});
        }

        @Override
        public void resetModel() {
            this.get("groupSearchBase").setDefaultModelObject(null);
            this.get("groupSearchFilter").setDefaultModelObject(null);
        }
    }

    class UserGroupAuthorizationPanel
    extends AuthorizationPanel {
        public UserGroupAuthorizationPanel(String id) {
            super(id);
            this.add(new Component[]{new UserGroupServiceChoice("userGroupServiceName")});
        }

        @Override
        public void resetModel() {
            this.get("userGroupServiceName").setDefaultModelObject(null);
        }
    }

    abstract class AuthorizationPanel
    extends FormComponentPanel {
        public AuthorizationPanel(String id) {
            super(id, (IModel)new Model());
        }

        public abstract void resetModel();
    }
}

