/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.ldap;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.security.GeoServerAuthenticationProvider;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerSecurityProvider;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.ldap.LDAPAuthenticationProvider;
import org.geoserver.security.ldap.LDAPSecurityServiceConfig;
import org.geotools.util.logging.Logging;
import org.springframework.ldap.core.AuthenticationSource;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.ldap.core.support.DefaultTlsDirContextAuthenticationStrategy;
import org.springframework.ldap.core.support.DirContextAuthenticationStrategy;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.ldap.DefaultSpringSecurityContextSource;
import org.springframework.security.ldap.authentication.BindAuthenticator;
import org.springframework.security.ldap.authentication.LdapAuthenticationProvider;
import org.springframework.security.ldap.authentication.LdapAuthenticator;
import org.springframework.security.ldap.authentication.SpringSecurityAuthenticationSource;
import org.springframework.security.ldap.authentication.UserDetailsServiceLdapAuthoritiesPopulator;
import org.springframework.security.ldap.userdetails.DefaultLdapAuthoritiesPopulator;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;

public class LDAPSecurityProvider
extends GeoServerSecurityProvider {
    static final Logger LOGGER = Logging.getLogger((String)"org.geoserver.security.ldap");
    GeoServerSecurityManager securityManager;

    public LDAPSecurityProvider(GeoServerSecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    public void configure(XStreamPersister xp) {
        xp.getXStream().alias("ldap", LDAPSecurityServiceConfig.class);
    }

    public Class<LDAPAuthenticationProvider> getAuthenticationProviderClass() {
        return LDAPAuthenticationProvider.class;
    }

    public GeoServerAuthenticationProvider createAuthenticationProvider(SecurityNamedServiceConfig config) {
        LDAPSecurityServiceConfig ldapConfig = (LDAPSecurityServiceConfig)config;
        DefaultSpringSecurityContextSource ldapContext = new DefaultSpringSecurityContextSource(ldapConfig.getServerURL());
        ldapContext.setCacheEnvironmentProperties(false);
        ldapContext.setAuthenticationSource((AuthenticationSource)new SpringSecurityAuthenticationSource());
        if (ldapConfig.isUseTLS().booleanValue()) {
            ldapContext.setPooled(false);
            DefaultTlsDirContextAuthenticationStrategy tls = new DefaultTlsDirContextAuthenticationStrategy();
            tls.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            ldapContext.setAuthenticationStrategy((DirContextAuthenticationStrategy)tls);
        }
        BindAuthenticator authenticator = new BindAuthenticator((BaseLdapPathContextSource)ldapContext);
        authenticator.setUserDnPatterns(new String[]{ldapConfig.getUserDnPattern()});
        DefaultLdapAuthoritiesPopulator authPopulator = null;
        String ugServiceName = ldapConfig.getUserGroupServiceName();
        if (ugServiceName != null) {
            try {
                GeoServerUserGroupService ugService = this.securityManager.loadUserGroupService(ugServiceName);
                authPopulator = new UserDetailsServiceLdapAuthoritiesPopulator((UserDetailsService)ugService);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, String.format("Unable to load user group service '%s', will use LDAP server for calculating roles", ugServiceName), e);
            }
        }
        if (authPopulator == null) {
            authPopulator = new DefaultLdapAuthoritiesPopulator((ContextSource)ldapContext, ldapConfig.getGroupSearchBase());
            if (ldapConfig.getGroupSearchFilter() != null) {
                authPopulator.setGroupSearchFilter(ldapConfig.getGroupSearchFilter());
            }
        }
        return new LDAPAuthenticationProvider((AuthenticationProvider)new LdapAuthenticationProvider((LdapAuthenticator)authenticator, (LdapAuthoritiesPopulator)authPopulator));
    }
}

