/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.ldap;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.security.DelegatingAuthenticationProvider;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.impl.GeoServerRole;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class LDAPAuthenticationProvider
extends DelegatingAuthenticationProvider {
    public LDAPAuthenticationProvider(AuthenticationProvider authProvider) {
        super(authProvider);
    }

    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        super.initializeFromConfig(config);
    }

    protected Authentication doAuthenticate(Authentication authentication, HttpServletRequest request) throws AuthenticationException {
        UsernamePasswordAuthenticationToken auth = (UsernamePasswordAuthenticationToken)super.doAuthenticate(authentication, request);
        if (auth == null) {
            return null;
        }
        if (!auth.getAuthorities().contains(GeoServerRole.AUTHENTICATED_ROLE)) {
            ArrayList<GeoServerRole> roles = new ArrayList<GeoServerRole>();
            roles.addAll(auth.getAuthorities());
            roles.add(GeoServerRole.AUTHENTICATED_ROLE);
            UsernamePasswordAuthenticationToken newAuth = new UsernamePasswordAuthenticationToken(auth.getPrincipal(), auth.getCredentials(), roles);
            newAuth.setDetails(auth.getDetails());
            return newAuth;
        }
        return auth;
    }
}

