/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.response;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.TransformerException;
import net.opengis.wcs11.GetCoverageType;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.Response;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wcs.WCSInfo;
import org.geoserver.wcs.response.CoveragesTransformer;
import org.geotools.coverage.grid.GridCoverage2D;
import org.opengis.coverage.grid.GridCoverage;
import org.vfny.geoserver.global.GeoserverDataDirectory;
import org.vfny.geoserver.wcs.WcsException;
import org.vfny.geoserver.wcs.responses.CoverageResponseDelegate;
import org.vfny.geoserver.wcs.responses.CoverageResponseDelegateFactory;

public class WCSGetCoverageStoreResponse
extends Response {
    GeoServer geoServer;
    Catalog catalog;

    public WCSGetCoverageStoreResponse(GeoServer gs) {
        super(GridCoverage[].class);
        this.geoServer = gs;
        this.catalog = gs.getCatalog();
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        return "application/xml";
    }

    public boolean canHandle(Operation operation) {
        if (!(operation.getParameters()[0] instanceof GetCoverageType)) {
            return false;
        }
        GetCoverageType getCoverage = (GetCoverageType)operation.getParameters()[0];
        return getCoverage.getOutput().isStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Object value, OutputStream output, Operation operation) throws IOException, ServiceException {
        GridCoverage[] coverages = (GridCoverage[])value;
        GetCoverageType request = (GetCoverageType)operation.getParameters()[0];
        String outputFormat = request.getOutput().getFormat();
        CoverageResponseDelegate delegate = CoverageResponseDelegateFactory.encoderFor((String)outputFormat);
        if (delegate == null) {
            throw new WcsException("Could not find encoder for output format " + outputFormat);
        }
        GridCoverage2D coverage = (GridCoverage2D)coverages[0];
        CoverageInfo coverageInfo = this.catalog.getCoverageByName(request.getIdentifier().getValue());
        File wcsStore = null;
        try {
            File temp = GeoserverDataDirectory.findCreateConfigDir((String)"temp");
            wcsStore = new File(temp, "wcs");
            if (!wcsStore.exists()) {
                wcsStore.mkdir();
            }
        }
        catch (Exception e) {
            throw new WcsException("Could not create the temporary storage directory for WCS");
        }
        File coverageFile = null;
        while ((coverageFile = new File(wcsStore, coverageInfo.getName().replace(':', '_') + "_" + System.nanoTime() + "." + delegate.getFileExtension())).exists()) {
        }
        OutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(coverageFile));
            delegate.prepare(outputFormat, coverage);
            delegate.encode(os);
            os.flush();
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
        System.out.println(coverageFile);
        String coverageLocation = ResponseUtils.buildURL((String)request.getBaseUrl(), (String)ResponseUtils.appendPath((String[])new String[]{"temp/wcs", coverageFile.getName()}), null, (URLMangler.URLType)URLMangler.URLType.RESOURCE);
        WCSInfo wcs = (WCSInfo)this.geoServer.getService(WCSInfo.class);
        CoveragesTransformer tx = new CoveragesTransformer(wcs, request, coverageLocation);
        try {
            tx.transform(coverageInfo, output);
        }
        catch (TransformerException e) {
            throw new WcsException("Failure trying to encode Coverages response", (Throwable)e);
        }
    }
}

