/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.feature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureImpl;
import org.geotools.feature.type.Types;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Attribute;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.identity.FeatureId;

public class LenientFeature
extends SimpleFeatureImpl {
    static Logger LOGGER = Logging.getLogger((String)"org.geotools.data.wfs");
    boolean constructing = true;

    protected LenientFeature(List<Attribute> attributes, SimpleFeatureType schema, String featureID) throws IllegalAttributeException, NullPointerException {
        super(LenientFeature.preFix(attributes, schema), LenientFeature.checkSchema(schema), (FeatureId)SimpleFeatureBuilder.createDefaultFeatureIdentifier((String)featureID));
        List<Object> values = LenientFeature.toValues(attributes);
        this.setAttributes(values);
        this.constructing = false;
    }

    private static List<Object> preFix(List<Attribute> attributes, SimpleFeatureType schema) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Attribute att : attributes) {
            result.add(att.getValue());
        }
        while (attributes.size() < schema.getAttributeCount()) {
            AttributeDescriptor required = schema.getDescriptor(attributes.size() - 1);
            attributes.add(null);
        }
        return result;
    }

    private static SimpleFeatureType checkSchema(SimpleFeatureType schema) {
        if (schema == null) {
            throw new NullPointerException("schema");
        }
        return schema;
    }

    public void setAttribute(int position, Object val) throws IllegalAttributeException {
        AttributeDescriptor type = this.getFeatureType().getDescriptor(position);
        try {
            if (val == null && !type.isNillable()) {
                val = type.getDefaultValue();
            }
            Object parsed = LenientFeature.parse(type, val);
            try {
                Types.validate((AttributeDescriptor)type, (Object)parsed);
            }
            catch (Throwable e) {
                if (this.constructing) {
                    LOGGER.logp(Level.WARNING, "LenientFeature", "setAttribute", "Illegal Argument but ignored since we are being lenient", e);
                }
                throw new IllegalAttributeException(type, val, e);
            }
            super.setAttribute(position, val);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalAttributeException(type, val, iae);
        }
    }

    public void setAttributes(List<Object> attributes) {
        if (this.constructing) {
            super.setAttributes(this.fixed(attributes));
        } else {
            super.setAttributes(attributes);
        }
    }

    List<Object> fixed(List<Object> attributes) {
        if (attributes == null) {
            attributes = Arrays.asList(new Object[this.getFeatureType().getAttributeCount()]);
        }
        if (attributes.size() != this.getFeatureType().getAttributeCount()) {
            String msg = "Expected " + this.getFeatureType().getAttributeCount() + " attributes but " + attributes.size() + " were specified";
            throw new IllegalArgumentException(msg);
        }
        List<Object> fixed = this.assumeCorrectOrder(attributes);
        if (fixed == null) {
            fixed = this.greedyMatch(attributes);
        }
        return fixed;
    }

    static List<Object> toValues(List<Attribute> properties) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (Attribute property : properties) {
            if (property != null) {
                values.add(property.getValue());
                continue;
            }
            values.add(property);
        }
        return values;
    }

    List<Object> assumeCorrectOrder(List<Object> newAtts) {
        SimpleFeatureType schema = this.getFeatureType();
        List<Object> tmp = Arrays.asList(new Object[schema.getAttributeCount()]);
        for (int i = 0; i < newAtts.size() && i < schema.getAttributeCount(); ++i) {
            Object object = newAtts.get(i);
            AttributeDescriptor att = schema.getDescriptor(i);
            if (object == null) continue;
            try {
                Object value = LenientFeature.parse(att, object);
                tmp.set(i, value);
                continue;
            }
            catch (IllegalArgumentException cannotConvert) {
                return null;
            }
        }
        return tmp;
    }

    List<Object> greedyMatch(List<Object> newAtts) {
        SimpleFeatureType schema = this.getFeatureType();
        List<Object> relaxedAttrs = Arrays.asList(new Object[schema.getAttributeCount()]);
        boolean inValid = false;
        for (int i = 0; i < newAtts.size(); ++i) {
            Object object = newAtts.get(i);
            boolean found = false;
            if (object == null) continue;
            Class<?> realClass = object.getClass();
            for (int j = 0; j < schema.getAttributeCount(); ++j) {
                AttributeDescriptor att = schema.getDescriptor(j);
                Class requiredClass = att.getType().getBinding();
                if (relaxedAttrs.get(j) != null || !requiredClass.isAssignableFrom(realClass)) continue;
                relaxedAttrs.set(j, object);
                found = true;
                break;
            }
            if (found) continue;
            inValid = true;
        }
        newAtts = relaxedAttrs;
        if (inValid) {
            int i;
            StringBuffer buf = new StringBuffer();
            buf.append("WFSFeatureType#setAttributes(Object[]):");
            buf.append("\nAttributes were not correct for the feature Type:");
            buf.append(schema.getTypeName());
            buf.append(".  Made best guess:\n Recieved: ");
            for (i = 0; i < newAtts.size(); ++i) {
                Object object = newAtts.get(i);
                buf.append(object == null ? "null" : object.toString());
                buf.append(",");
            }
            buf.append("\nBest Guess: \n");
            for (i = 0; i < relaxedAttrs.size(); ++i) {
                Object object = relaxedAttrs.get(i);
                buf.append(object == null ? "null" : object.toString());
                buf.append(",");
            }
            LOGGER.warning(buf.toString());
        }
        return relaxedAttrs;
    }

    public Object clone() {
        try {
            LenientFeature clone = (LenientFeature)((Object)super.clone());
            for (int i = 0; i < this.getAttributeCount(); ++i) {
                clone.setAttribute(i, this.getAttribute(i));
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("The impossible has happened", e);
        }
    }

    public static Object parse(AttributeDescriptor descriptor, Object value) throws IllegalArgumentException {
        if (value == null) {
            if (descriptor.isNillable()) {
                return descriptor.getDefaultValue();
            }
        } else {
            Class target = descriptor.getType().getBinding();
            if (!target.isAssignableFrom(value.getClass())) {
                Object converted = Converters.convert(value, target);
                if (converted != null) {
                    return converted;
                }
                throw new IllegalArgumentException("Could not convert");
            }
        }
        return value;
    }
}

