/*
 * Decompiled with CFR 0.152.
 */
package org.restlet;

import java.util.ArrayList;
import java.util.List;
import org.restlet.Filter;
import org.restlet.data.CharacterSet;
import org.restlet.data.Encoding;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.resource.Representation;
import org.restlet.resource.TransformRepresentation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transformer
extends Filter {
    public static final int MODE_REQUEST = 1;
    public static final int MODE_RESPONSE = 2;
    private int mode;
    private Representation transformSheet;
    private CharacterSet resultCharacterSet;
    private List<Encoding> resultEncodings;
    private List<Language> resultLanguages;
    private MediaType resultMediaType;

    public Transformer(int mode, Representation transformSheet) {
        this.mode = mode;
        this.transformSheet = transformSheet;
        this.resultMediaType = MediaType.APPLICATION_XML;
        this.resultLanguages = null;
        this.resultCharacterSet = null;
    }

    @Override
    protected void afterHandle(Request request, Response response) {
        if (this.getMode() == 2) {
            response.setEntity(this.transform(response.getEntity()));
        }
    }

    @Override
    protected void beforeHandle(Request request, Response response) {
        if (this.getMode() == 1) {
            request.setEntity(this.transform(request.getEntity()));
        }
    }

    public int getMode() {
        return this.mode;
    }

    public CharacterSet getResultCharacterSet() {
        return this.resultCharacterSet;
    }

    public List<Encoding> getResultEncodings() {
        if (this.resultEncodings == null) {
            this.resultEncodings = new ArrayList<Encoding>();
        }
        return this.resultEncodings;
    }

    public List<Language> getResultLanguages() {
        if (this.resultLanguages == null) {
            this.resultLanguages = new ArrayList<Language>();
        }
        return this.resultLanguages;
    }

    public MediaType getResultMediaType() {
        return this.resultMediaType;
    }

    public Representation getTransformSheet() {
        return this.transformSheet;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void setResultCharacterSet(CharacterSet resultCharacterSet) {
        this.resultCharacterSet = resultCharacterSet;
    }

    public void setResultMediaType(MediaType resultMediaType) {
        this.resultMediaType = resultMediaType;
    }

    public void setTransformSheet(Representation transformSheet) {
        this.transformSheet = transformSheet;
    }

    public Representation transform(Representation source) {
        TransformRepresentation result = new TransformRepresentation(this.getContext(), source, this.getTransformSheet());
        if (this.resultLanguages != null) {
            result.getLanguages().addAll(this.getResultLanguages());
        }
        result.setCharacterSet(this.getResultCharacterSet());
        if (this.resultEncodings != null) {
            result.getEncodings().addAll(this.getResultEncodings());
        }
        result.setMediaType(this.getResultMediaType());
        return result;
    }
}

