/*
 * Decompiled with CFR 0.152.
 */
package org.restlet;

import java.lang.reflect.Constructor;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Finder;
import org.restlet.Restlet;
import org.restlet.Route;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Resource;
import org.restlet.util.RouteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Router
extends Restlet {
    public static final int BEST = 1;
    public static final int FIRST = 2;
    public static final int LAST = 3;
    public static final int NEXT = 4;
    public static final int RANDOM = 5;
    public static final int CUSTOM = 6;
    private Class<? extends Finder> finderClass = Finder.class;
    private RouteList routes = null;
    private Route defaultRoute = null;
    private int routingMode = 1;
    private float requiredScore = 0.5f;
    private int maxAttempts = 1;
    private long retryDelay = 500L;

    public Router() {
        this(null);
    }

    public Router(Context context) {
        super(context);
    }

    public Route attach(Restlet target) {
        return this.attach("", target);
    }

    public Route attach(String uriPattern, Class<? extends Resource> targetClass) {
        return this.attach(uriPattern, this.createFinder(targetClass));
    }

    private Finder createFinder(Class<? extends Resource> targetClass) {
        Finder result = null;
        if (this.getFinderClass() != null) {
            try {
                Constructor<? extends Finder> constructor = this.getFinderClass().getConstructor(Context.class, Class.class);
                if (constructor != null) {
                    result = constructor.newInstance(this.getContext(), targetClass);
                }
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, "Exception while instantiating the finder.", e);
            }
        }
        return result;
    }

    public Route attach(String uriPattern, Restlet target) {
        Route result = this.createRoute(uriPattern, target);
        this.getRoutes().add(result);
        return result;
    }

    public Route attachDefault(Class<? extends Resource> defaultTargetClass) {
        return this.attachDefault(this.createFinder(defaultTargetClass));
    }

    public Route attachDefault(Restlet defaultTarget) {
        Route result = this.createRoute("", defaultTarget);
        this.setDefaultRoute(result);
        return result;
    }

    protected Route createRoute(String uriPattern, Restlet target) {
        return new Route(this, uriPattern, target);
    }

    public void detach(Restlet target) {
        this.getRoutes().removeAll(target);
        if (this.getDefaultRoute() != null && this.getDefaultRoute().getNext() == target) {
            this.setDefaultRoute(null);
        }
    }

    protected Route getCustom(Request request, Response response) {
        return null;
    }

    public Route getDefaultRoute() {
        return this.defaultRoute;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public Restlet getNext(Request request, Response response) {
        Route result = null;
        block10: for (int i = 0; result == null && i < this.getMaxAttempts(); ++i) {
            if (i > 0) {
                try {
                    Thread.sleep(this.getRetryDelay());
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (this.routes == null) continue;
            switch (this.getRoutingMode()) {
                case 1: {
                    result = this.getRoutes().getBest(request, response, this.getRequiredScore());
                    continue block10;
                }
                case 2: {
                    result = this.getRoutes().getFirst(request, response, this.getRequiredScore());
                    continue block10;
                }
                case 3: {
                    result = this.getRoutes().getLast(request, response, this.getRequiredScore());
                    continue block10;
                }
                case 4: {
                    result = this.getRoutes().getNext(request, response, this.getRequiredScore());
                    continue block10;
                }
                case 5: {
                    result = this.getRoutes().getRandom(request, response, this.getRequiredScore());
                    continue block10;
                }
                case 6: {
                    result = this.getCustom(request, response);
                }
            }
        }
        if (result == null) {
            if (this.getDefaultRoute() != null && this.getDefaultRoute().score(request, response) >= this.getRequiredScore()) {
                result = this.getDefaultRoute();
            } else {
                response.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            }
        }
        return result;
    }

    public float getRequiredScore() {
        return this.requiredScore;
    }

    public long getRetryDelay() {
        return this.retryDelay;
    }

    public RouteList getRoutes() {
        if (this.routes == null) {
            this.routes = new RouteList();
        }
        return this.routes;
    }

    public int getRoutingMode() {
        return this.routingMode;
    }

    @Override
    public void handle(Request request, Response response) {
        this.init(request, response);
        Restlet next = this.getNext(request, response);
        if (next != null) {
            next.handle(request, response);
        } else {
            response.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
        }
    }

    public void setDefaultRoute(Route defaultRoute) {
        this.defaultRoute = defaultRoute;
    }

    public void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public void setRequiredScore(float score) {
        this.requiredScore = score;
    }

    public void setRetryDelay(long retryDelay) {
        this.retryDelay = retryDelay;
    }

    public void setRoutingMode(int routingMode) {
        this.routingMode = routingMode;
    }

    public Class<? extends Finder> getFinderClass() {
        return this.finderClass;
    }

    public void setFinderClass(Class<? extends Finder> finderClass) {
        this.finderClass = finderClass;
    }
}

