/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.SQLDialect;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.expression.Literal;

public abstract class BasicSQLDialect
extends SQLDialect {
    protected BasicSQLDialect(JDBCDataStore dataStore) {
        super(dataStore);
    }

    public void encodeValue(Object value, Class type, StringBuffer sql) {
        Literal literal = this.dataStore.getFilterFactory().literal(value);
        FilterToSQL filterToSQL = this.dataStore.createFilterToSQL(null);
        StringWriter w = new StringWriter();
        filterToSQL.setWriter(w);
        filterToSQL.visit(literal, (Object)type);
        sql.append(w.getBuffer().toString());
    }

    public abstract void encodeGeometryValue(Geometry var1, int var2, StringBuffer var3) throws IOException;

    public FilterToSQL createFilterToSQL() {
        FilterToSQL f2s = new FilterToSQL();
        f2s.setCapabilities(BASE_DBMS_CAPABILITIES);
        return f2s;
    }

    public void onSelect(Statement select, Connection cx, SimpleFeatureType featureType) throws SQLException {
    }

    public void onDelete(Statement delete, Connection cx, SimpleFeatureType featureType) throws SQLException {
    }

    public void onInsert(Statement insert, Connection cx, SimpleFeatureType featureType) throws SQLException {
    }

    public void onUpdate(Statement update, Connection cx, SimpleFeatureType featureType) throws SQLException {
    }
}

