/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.user;

import java.io.IOException;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.web.user.NewUserPage;
import org.geoserver.security.web.user.SelectionUserRemovalLink;
import org.geoserver.security.web.user.UserListProvider;
import org.geoserver.security.web.user.UserTablePanel;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.GeoServerTablePanel;

public class UserPanel
extends Panel {
    protected GeoServerTablePanel<GeoServerUser> users;
    protected GeoServerDialog dialog;
    protected SelectionUserRemovalLink removal;
    protected SelectionUserRemovalLink removalWithRoles;
    protected Link<NewUserPage> add;
    protected String serviceName;

    protected GeoServerUserGroupService getService() {
        try {
            return GeoServerApplication.get().getSecurityManager().loadUserGroupService(this.serviceName);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public UserPanel(String id, String serviceName) {
        super(id);
        this.serviceName = serviceName;
        UserListProvider provider = new UserListProvider(this.serviceName);
        Component[] componentArray = new Component[1];
        this.users = new UserTablePanel("table", serviceName, provider, true){

            protected void onSelectionUpdate(AjaxRequestTarget target) {
                UserPanel.this.removal.setEnabled(UserPanel.this.users.getSelection().size() > 0);
                target.addComponent((Component)UserPanel.this.removal);
                UserPanel.this.removalWithRoles.setEnabled(UserPanel.this.users.getSelection().size() > 0);
                target.addComponent((Component)UserPanel.this.removalWithRoles);
            }
        };
        componentArray[0] = this.users;
        this.add(componentArray);
        this.users.setOutputMarkupId(true);
        Component[] componentArray2 = new Component[1];
        this.dialog = new GeoServerDialog("dialog");
        componentArray2[0] = this.dialog;
        this.add(componentArray2);
        this.headerComponents();
    }

    public UserPanel setHeaderVisible(boolean visible) {
        this.get("header").setVisible(visible);
        return this;
    }

    public UserPanel setPagersVisible(boolean top, boolean bottom) {
        this.users.getTopPager().setVisible(top);
        this.users.getBottomPager().setVisible(bottom);
        return this;
    }

    protected void headerComponents() {
        boolean canCreateStore = this.getService().canCreateStore();
        WebMarkupContainer h = new WebMarkupContainer("header");
        this.add(new Component[]{h});
        if (!canCreateStore) {
            h.add(new Component[]{new Label("message", (IModel)new StringResourceModel("noCreateStore", (Component)this, null)).add(new IBehavior[]{new AttributeAppender("class", (IModel)new Model((Serializable)((Object)"info-link")), " ")})});
        } else {
            h.add(new Component[]{new Label("message", (IModel)new Model()).add(new IBehavior[]{new AttributeAppender("class", (IModel)new Model((Serializable)((Object)"displayNone")), " ")})});
        }
        Component[] componentArray = new Component[1];
        this.add = new Link("addNew"){

            public void onClick() {
                this.setResponsePage((Page)new NewUserPage(UserPanel.this.serviceName).setReturnPage(this.getPage()));
            }
        };
        componentArray[0] = this.add;
        h.add(componentArray);
        this.add.setVisible(canCreateStore);
        Component[] componentArray2 = new Component[1];
        this.removal = new SelectionUserRemovalLink(this.serviceName, "removeSelected", this.users, this.dialog, false);
        componentArray2[0] = this.removal;
        h.add(componentArray2);
        this.removal.setOutputMarkupId(true);
        this.removal.setEnabled(false);
        this.removal.setVisible(canCreateStore);
        Component[] componentArray3 = new Component[1];
        this.removalWithRoles = new SelectionUserRemovalLink(this.serviceName, "removeSelectedWithRoles", this.users, this.dialog, true);
        componentArray3[0] = this.removalWithRoles;
        h.add(componentArray3);
        this.removalWithRoles.setOutputMarkupId(true);
        this.removalWithRoles.setEnabled(false);
        this.removalWithRoles.setVisible(canCreateStore && GeoServerApplication.get().getSecurityManager().getActiveRoleService().canCreateStore());
    }
}

