/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.user;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.web.wicket.GeoServerDataProvider;

public class UserListProvider
extends GeoServerDataProvider<GeoServerUser> {
    public static final GeoServerDataProvider.Property<GeoServerUser> USERNAME = new GeoServerDataProvider.BeanProperty("username", "username");
    public static final GeoServerDataProvider.Property<GeoServerUser> ENABLED = new GeoServerDataProvider.BeanProperty("enabled", "enabled");
    protected String userGroupServiceName;
    public static final GeoServerDataProvider.Property<GeoServerUser> HASATTRIBUTES = new GeoServerDataProvider.Property<GeoServerUser>(){

        public String getName() {
            return "hasattributes";
        }

        public Object getPropertyValue(GeoServerUser item) {
            if (item.getProperties().size() == 0) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }

        public IModel getModel(IModel itemModel) {
            return new Model((Serializable)((Boolean)this.getPropertyValue((GeoServerUser)itemModel.getObject())));
        }

        public Comparator<GeoServerUser> getComparator() {
            return new GeoServerDataProvider.PropertyComparator((GeoServerDataProvider.Property)this);
        }

        public boolean isVisible() {
            return true;
        }

        public boolean isSearchable() {
            return true;
        }
    };

    public UserListProvider(String userGroupServiceName) {
        this.userGroupServiceName = userGroupServiceName;
    }

    protected List<GeoServerUser> getItems() {
        TreeSet users = null;
        try {
            GeoServerUserGroupService service = null;
            if (this.userGroupServiceName != null) {
                service = this.getApplication().getSecurityManager().loadUserGroupService(this.userGroupServiceName);
            }
            users = service == null ? new TreeSet() : service.getUsers();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ArrayList<GeoServerUser> userList = new ArrayList<GeoServerUser>();
        userList.addAll(users);
        return userList;
    }

    protected List<GeoServerDataProvider.Property<GeoServerUser>> getProperties() {
        ArrayList<GeoServerDataProvider.Property<GeoServerUser>> result = new ArrayList<GeoServerDataProvider.Property<GeoServerUser>>();
        result.add(USERNAME);
        result.add(ENABLED);
        result.add(HASATTRIBUTES);
        return result;
    }
}

