/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.OnChangeAjaxBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.form.validation.AbstractFormValidator;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.Service;
import org.geoserver.security.impl.ServiceAccessRule;
import org.geoserver.security.web.AbstractSecurityPage;
import org.geoserver.security.web.role.RuleRolesFormComponent;
import org.geoserver.security.web.service.ServiceAccessRulePage;
import org.geoserver.web.wicket.ParamResourceModel;

public abstract class AbstractServiceAccessRulePage
extends AbstractSecurityPage {
    protected DropDownChoice<String> serviceChoice;
    protected DropDownChoice<String> methodChoice;
    protected RuleRolesFormComponent rolesFormComponent;

    public AbstractServiceAccessRulePage(ServiceAccessRule rule) {
        Form form = new Form("form", (IModel)new CompoundPropertyModel((Object)rule));
        this.add(new Component[]{form});
        form.add((IFormValidator)new EmptyRolesValidator());
        Component[] componentArray = new Component[1];
        this.serviceChoice = new DropDownChoice("service", this.getServiceNames());
        componentArray[0] = this.serviceChoice;
        form.add(componentArray);
        this.serviceChoice.add(new IBehavior[]{new OnChangeAjaxBehavior(){

            protected void onUpdate(AjaxRequestTarget target) {
                AbstractServiceAccessRulePage.this.methodChoice.updateModel();
                target.addComponent(AbstractServiceAccessRulePage.this.methodChoice);
            }
        }});
        this.serviceChoice.setRequired(true);
        Component[] componentArray2 = new Component[1];
        this.methodChoice = new DropDownChoice("method", (IModel)new MethodsModel(rule));
        componentArray2[0] = this.methodChoice;
        form.add(componentArray2);
        this.methodChoice.setOutputMarkupId(true);
        this.methodChoice.setRequired(true);
        Component[] componentArray3 = new Component[1];
        this.rolesFormComponent = new RuleRolesFormComponent("roles", (IModel<Collection<String>>)new PropertyModel((Object)rule, "roles"));
        componentArray3[0] = this.rolesFormComponent;
        form.add(componentArray3);
        form.add(new Component[]{new SubmitLink("save"){

            public void onSubmit() {
                AbstractServiceAccessRulePage.this.onFormSubmit((ServiceAccessRule)this.getForm().getModelObject());
            }
        }});
        form.add(new Component[]{new BookmarkablePageLink("cancel", ServiceAccessRulePage.class)});
    }

    protected abstract void onFormSubmit(ServiceAccessRule var1);

    ArrayList<String> getServiceNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (Service ows : GeoServerExtensions.extensions(Service.class)) {
            if (result.contains(ows.getId())) continue;
            result.add(ows.getId());
        }
        Collections.sort(result);
        result.add(0, "*");
        return result;
    }

    protected void updateModels() {
        this.serviceChoice.updateModel();
        this.methodChoice.updateModel();
        this.rolesFormComponent.updateModel();
    }

    class MethodsModel
    implements IModel<List<String>> {
        ServiceAccessRule rule;

        MethodsModel(ServiceAccessRule rule) {
            this.rule = rule;
        }

        public List<String> getObject() {
            ArrayList<String> result = new ArrayList<String>();
            boolean flag = true;
            for (Service ows : GeoServerExtensions.extensions(Service.class)) {
                String service = this.rule.getService();
                if (!service.equals(ows.getId()) || result.contains(ows.getOperations()) || !flag) continue;
                flag = false;
                result.addAll(ows.getOperations());
            }
            Collections.sort(result);
            result.add(0, "*");
            return result;
        }

        public void setObject(List<String> object) {
            throw new UnsupportedOperationException();
        }

        public void detach() {
        }
    }

    class EmptyRolesValidator
    extends AbstractFormValidator {
        EmptyRolesValidator() {
        }

        public FormComponent<?>[] getDependentFormComponents() {
            return new FormComponent[]{AbstractServiceAccessRulePage.this.rolesFormComponent};
        }

        public void validate(Form<?> form) {
            if (form.findSubmittingButton() != form.get("save")) {
                return;
            }
            AbstractServiceAccessRulePage.this.rolesFormComponent.updateModel();
            if (AbstractServiceAccessRulePage.this.rolesFormComponent.getRolesForStoring().isEmpty()) {
                form.error((Serializable)((Object)new ParamResourceModel("emptyRoles", (Component)AbstractServiceAccessRulePage.this.getPage(), new Object[0]).getString()));
            }
        }
    }
}

