/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.role;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxCheckBox;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.web.role.RolePaletteFormComponent;
import org.geoserver.security.web.role.RuleRolesModel;
import org.geoserver.web.GeoServerApplication;

public class RuleRolesFormComponent
extends RolePaletteFormComponent {
    public RuleRolesFormComponent(String id, IModel<Collection<String>> roleNamesModel) {
        super(id, (IModel<List<GeoServerRole>>)new RolesModel(roleNamesModel), (IModel<Collection<GeoServerRole>>)new RuleRolesModel());
        this.add(new Component[]{new AjaxCheckBox("anyRole", (IModel)new Model((Serializable)Boolean.valueOf(false))){

            protected void onUpdate(AjaxRequestTarget target) {
                RuleRolesFormComponent.this.palette.setEnabled((Boolean)this.getModelObject() == false);
                target.addComponent((Component)RuleRolesFormComponent.this.palette);
            }
        }});
    }

    public RuleRolesFormComponent setHasAnyRole(boolean hasAny) {
        this.get("anyRole").setDefaultModelObject((Object)hasAny);
        this.palette.setEnabled(!hasAny);
        return this;
    }

    public boolean isHasAnyRole() {
        return (Boolean)this.get("anyRole").getDefaultModelObject();
    }

    public Set<GeoServerRole> getRolesForStoring() {
        HashSet<GeoServerRole> result = new HashSet<GeoServerRole>();
        if (this.isHasAnyRole()) {
            result.add(GeoServerRole.ANY_ROLE);
        } else {
            result.addAll(this.getSelectedRoles());
        }
        return result;
    }

    public Set<String> getRolesNamesForStoring() {
        HashSet<String> result = new HashSet<String>();
        for (GeoServerRole role : this.getRolesForStoring()) {
            result.add(role.getAuthority());
        }
        return result;
    }

    static class RolesModel
    extends LoadableDetachableModel<List<GeoServerRole>> {
        IModel<Collection<String>> roleNamesModel;

        RolesModel(IModel<Collection<String>> roleNamesModel) {
            this.roleNamesModel = roleNamesModel;
        }

        protected List<GeoServerRole> load() {
            HashMap<String, GeoServerRole> roleMap = new HashMap<String, GeoServerRole>();
            try {
                for (GeoServerRole role : GeoServerApplication.get().getSecurityManager().getRolesForAccessControl()) {
                    roleMap.put(role.getAuthority(), role);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ArrayList<GeoServerRole> roles = new ArrayList<GeoServerRole>();
            for (String roleName : (Collection)this.roleNamesModel.getObject()) {
                GeoServerRole role = (GeoServerRole)roleMap.get(roleName);
                if (role == null) continue;
                roles.add(role);
            }
            return roles;
        }

        public void setObject(List<GeoServerRole> object) {
            super.setObject(object);
            Collection roleNames = (Collection)this.roleNamesModel.getObject();
            roleNames.clear();
            for (GeoServerRole role : object) {
                roleNames.add(role.getAuthority());
            }
        }
    }
}

