/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.role;

import java.io.IOException;
import java.util.Map;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.validation.RoleStoreValidationWrapper;
import org.geoserver.security.web.role.AbstractRolePage;

public class EditRolePage
extends AbstractRolePage {
    public EditRolePage(String roleServiceName, GeoServerRole role) {
        super(roleServiceName, role);
        this.get("form:name").setEnabled(false);
        if (role.getUserName() != null) {
            this.get("form:properties").setEnabled(false);
            this.get("form:parent").setEnabled(false);
            this.get("form:save").setEnabled(false);
        }
    }

    @Override
    protected void onFormSubmit(GeoServerRole updated) throws IOException {
        if (!this.hasRoleStore(this.roleServiceName)) {
            throw new RuntimeException("Invalid workflow, cannot store in a read only role service");
        }
        RoleStoreValidationWrapper store = null;
        try {
            store = new RoleStoreValidationWrapper(this.getRoleStore(this.roleServiceName), new GeoServerUserGroupService[0]);
            GeoServerRole role = store.getRoleByName(updated.getAuthority());
            role.getProperties().clear();
            role.getProperties().putAll((Map<?, ?>)updated.getProperties());
            store.updateRole(role);
            String parentRoleName = this.get("form:parent").getDefaultModelObjectAsString();
            if (parentRoleName != null) {
                GeoServerRole parentRole = store.getRoleByName(parentRoleName);
                store.setParentRole(role, parentRole);
            }
            store.store();
        }
        catch (IOException ex) {
            try {
                store.load();
            }
            catch (IOException ex2) {
                // empty catch block
            }
            throw ex;
        }
    }
}

