/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.passwd;

import java.io.IOException;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.security.password.MasterPasswordConfig;
import org.geoserver.security.password.MasterPasswordProviderConfig;
import org.geoserver.security.web.AbstractSecurityPage;
import org.geoserver.security.web.passwd.MasterPasswordConfigModel;

public class MasterPasswordChangePage
extends AbstractSecurityPage {
    public MasterPasswordChangePage() {
        MasterPasswordConfigModel configModel = new MasterPasswordConfigModel();
        Form form = new Form("form", (IModel)new CompoundPropertyModel((Object)configModel));
        this.add(new Component[]{form});
        form.add(new Component[]{new Label("providerName")});
        MasterPasswordConfig config = (MasterPasswordConfig)configModel.getObject();
        MasterPasswordProviderConfig providerConfig = null;
        try {
            providerConfig = this.getSecurityManager().loadMasterPassswordProviderConfig(config.getProviderName());
        }
        catch (IOException e) {
            throw new WicketRuntimeException((Throwable)e);
        }
        form.add(new Component[]{new PasswordTextField("currentPassword", (IModel)new Model())});
        form.add(new Component[]{new PasswordTextField("newPassword", (IModel)new Model()).setEnabled(!providerConfig.isReadOnly())});
        form.add(new Component[]{new PasswordTextField("newPasswordConfirm", (IModel)new Model())});
        form.add(new Component[]{new SubmitLink("save", form){

            public void onSubmit() {
                Form f = this.getForm();
                String currPasswd = (String)f.get("currentPassword").getDefaultModelObject();
                String newPasswd = (String)f.get("newPassword").getDefaultModelObject();
                String newPasswdConfirm = (String)f.get("newPasswordConfirm").getDefaultModelObject();
                MasterPasswordConfig mpConfig = (MasterPasswordConfig)this.getForm().getModelObject();
                try {
                    MasterPasswordChangePage.this.getSecurityManager().saveMasterPasswordConfig(mpConfig, currPasswd.toCharArray(), newPasswd != null ? newPasswd.toCharArray() : null, newPasswdConfirm.toCharArray());
                    MasterPasswordChangePage.this.doReturn();
                }
                catch (Exception e) {
                    this.error(e);
                }
            }
        }});
        form.add(new Component[]{new AjaxLink("cancel"){

            public void onClick(AjaxRequestTarget target) {
                MasterPasswordChangePage.this.doReturn();
            }
        }});
    }
}

