/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.group;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.geoserver.web.wicket.GeoServerDataProvider;

public class GroupListProvider
extends GeoServerDataProvider<GeoServerUserGroup> {
    public static final GeoServerDataProvider.Property<GeoServerUserGroup> GROUPNAME = new GeoServerDataProvider.BeanProperty("groupname", "groupname");
    public static final GeoServerDataProvider.Property<GeoServerUserGroup> ENABLED = new GeoServerDataProvider.BeanProperty("enabled", "enabled");
    protected String userGroupServiceName;

    public GroupListProvider(String userGroupServiceName) {
        this.userGroupServiceName = userGroupServiceName;
    }

    protected List<GeoServerUserGroup> getItems() {
        TreeSet groups = null;
        try {
            GeoServerUserGroupService service = null;
            if (this.userGroupServiceName != null) {
                service = this.getApplication().getSecurityManager().loadUserGroupService(this.userGroupServiceName);
            }
            groups = service == null ? new TreeSet() : service.getUserGroups();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ArrayList<GeoServerUserGroup> groupList = new ArrayList<GeoServerUserGroup>();
        groupList.addAll(groups);
        return groupList;
    }

    protected List<GeoServerDataProvider.Property<GeoServerUserGroup>> getProperties() {
        ArrayList<GeoServerDataProvider.Property<GeoServerUserGroup>> result = new ArrayList<GeoServerDataProvider.Property<GeoServerUserGroup>>();
        result.add(GROUPNAME);
        result.add(ENABLED);
        return result;
    }
}

