/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.form.validation.AbstractFormValidator;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.security.AccessMode;
import org.geoserver.security.impl.DataAccessRule;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.web.AbstractSecurityPage;
import org.geoserver.security.web.data.DataSecurityPage;
import org.geoserver.security.web.role.RuleRolesFormComponent;
import org.geoserver.web.wicket.ParamResourceModel;

public abstract class AbstractDataAccessRulePage
extends AbstractSecurityPage {
    static List<AccessMode> MODES = Arrays.asList(AccessMode.READ, AccessMode.WRITE, AccessMode.ADMIN);
    DropDownChoice<String> workspaceChoice;
    DropDownChoice<String> layerChoice;
    DropDownChoice<AccessMode> accessModeChoice;
    RuleRolesFormComponent rolesFormComponent;

    public AbstractDataAccessRulePage(DataAccessRule rule) {
        Form form = new Form("form", (IModel)new CompoundPropertyModel((Object)rule));
        this.add(new Component[]{form});
        form.add((IFormValidator)new EmptyRolesValidator());
        Component[] componentArray = new Component[1];
        this.workspaceChoice = new DropDownChoice("workspace", this.getWorkspaceNames());
        componentArray[0] = this.workspaceChoice;
        form.add(componentArray);
        this.workspaceChoice.setRequired(true);
        this.workspaceChoice.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                AbstractDataAccessRulePage.this.layerChoice.setChoices((IModel)new Model(AbstractDataAccessRulePage.this.getLayerNames((String)AbstractDataAccessRulePage.this.workspaceChoice.getConvertedInput())));
                AbstractDataAccessRulePage.this.layerChoice.modelChanged();
                target.addComponent(AbstractDataAccessRulePage.this.layerChoice);
            }
        }});
        Component[] componentArray2 = new Component[1];
        this.layerChoice = new DropDownChoice("layer", this.getLayerNames(rule.getWorkspace()));
        componentArray2[0] = this.layerChoice;
        form.add(componentArray2);
        this.layerChoice.setRequired(true);
        this.layerChoice.setOutputMarkupId(true);
        Component[] componentArray3 = new Component[1];
        this.accessModeChoice = new DropDownChoice("accessMode", MODES, (IChoiceRenderer)new AccessModeRenderer());
        componentArray3[0] = this.accessModeChoice;
        form.add(componentArray3);
        this.accessModeChoice.setRequired(true);
        Component[] componentArray4 = new Component[1];
        this.rolesFormComponent = new RuleRolesFormComponent("roles", (IModel<Collection<String>>)new PropertyModel((Object)rule, "roles")).setHasAnyRole(rule.getRoles().contains(GeoServerRole.ANY_ROLE.getAuthority()));
        componentArray4[0] = this.rolesFormComponent;
        form.add(componentArray4);
        form.add(new Component[]{new SubmitLink("save"){

            public void onSubmit() {
                DataAccessRule rule = (DataAccessRule)this.getForm().getModelObject();
                if (AbstractDataAccessRulePage.this.rolesFormComponent.isHasAnyRole()) {
                    rule.getRoles().clear();
                    rule.getRoles().add(GeoServerRole.ANY_ROLE.getAuthority());
                }
                AbstractDataAccessRulePage.this.onFormSubmit(rule);
            }
        }});
        form.add(new Component[]{new BookmarkablePageLink("cancel", DataSecurityPage.class)});
    }

    protected abstract void onFormSubmit(DataAccessRule var1);

    ArrayList<String> getWorkspaceNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (WorkspaceInfo ws : this.getCatalog().getWorkspaces()) {
            result.add(ws.getName());
        }
        Collections.sort(result);
        result.add(0, "*");
        return result;
    }

    ArrayList<String> getLayerNames(String workspaceName) {
        ArrayList<String> result = new ArrayList<String>();
        if (!workspaceName.equals("*")) {
            for (ResourceInfo r : this.getCatalog().getResources(ResourceInfo.class)) {
                if (!r.getStore().getWorkspace().getName().equals(workspaceName)) continue;
                result.add(r.getName());
            }
            Collections.sort(result);
        }
        result.add(0, "*");
        return result;
    }

    protected void updateModels() {
        this.workspaceChoice.updateModel();
        this.layerChoice.updateModel();
        this.accessModeChoice.updateModel();
        this.rolesFormComponent.updateModel();
    }

    class EmptyRolesValidator
    extends AbstractFormValidator {
        EmptyRolesValidator() {
        }

        public FormComponent<?>[] getDependentFormComponents() {
            return new FormComponent[]{AbstractDataAccessRulePage.this.workspaceChoice, AbstractDataAccessRulePage.this.layerChoice, AbstractDataAccessRulePage.this.accessModeChoice, AbstractDataAccessRulePage.this.rolesFormComponent};
        }

        public void validate(Form<?> form) {
            if (form.findSubmittingButton() != form.get("save")) {
                return;
            }
            AbstractDataAccessRulePage.this.updateModels();
            if (AbstractDataAccessRulePage.this.rolesFormComponent.getRolesNamesForStoring().isEmpty()) {
                form.error((Serializable)((Object)new ParamResourceModel("emptyRoles", (Component)AbstractDataAccessRulePage.this.getPage(), new Object[0]).getString()));
            }
        }
    }

    class AccessModeRenderer
    implements IChoiceRenderer<AccessMode> {
        AccessModeRenderer() {
        }

        public Object getDisplayValue(AccessMode object) {
            return (String)new ParamResourceModel(object.name(), (Component)AbstractDataAccessRulePage.this.getPage(), new Object[0]).getObject();
        }

        public String getIdValue(AccessMode object, int index) {
            return object.name();
        }
    }
}

