/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.auth;

import java.util.Arrays;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.OnChangeAjaxBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.EnumChoiceRenderer;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.security.config.PreAuthenticatedUserNameFilterConfig;
import org.geoserver.security.web.auth.AuthenticationFilterPanel;
import org.geoserver.security.web.role.RoleServiceChoice;
import org.geoserver.security.web.usergroup.UserGroupServiceChoice;

public abstract class PreAuthenticatedUserNameFilterPanel<T extends PreAuthenticatedUserNameFilterConfig>
extends AuthenticationFilterPanel<T> {
    DropDownChoice<PreAuthenticatedUserNameFilterConfig.RoleSource> roleSourceChoice;

    public PreAuthenticatedUserNameFilterPanel(String id, IModel<T> model) {
        super(id, model);
        Component[] componentArray = new Component[1];
        this.roleSourceChoice = new DropDownChoice("roleSource", Arrays.asList(PreAuthenticatedUserNameFilterConfig.RoleSource.values()), (IChoiceRenderer)new EnumChoiceRenderer());
        componentArray[0] = this.roleSourceChoice;
        this.add(componentArray);
        this.roleSourceChoice.setNullValid(false);
        this.roleSourceChoice.add(new IBehavior[]{new OnChangeAjaxBehavior(){

            protected void onUpdate(AjaxRequestTarget target) {
                Panel p;
                switch ((PreAuthenticatedUserNameFilterConfig.RoleSource)PreAuthenticatedUserNameFilterPanel.this.roleSourceChoice.getModelObject()) {
                    case UserGroupService: {
                        p = new UserGroupServicePanel("panel");
                        break;
                    }
                    case RoleService: {
                        p = new RoleServicePanel("panel");
                        break;
                    }
                    default: {
                        p = new HeaderPanel("panel");
                    }
                }
                WebMarkupContainer c = (WebMarkupContainer)PreAuthenticatedUserNameFilterPanel.this.get("container");
                c.addOrReplace(new Component[]{p});
                target.addComponent((Component)c);
            }
        }});
        WebMarkupContainer container = new WebMarkupContainer("container");
        this.add(new Component[]{container.setOutputMarkupId(true)});
        PreAuthenticatedUserNameFilterConfig.RoleSource rs = ((PreAuthenticatedUserNameFilterConfig)model.getObject()).getRoleSource();
        if (PreAuthenticatedUserNameFilterConfig.RoleSource.Header.equals((Object)rs)) {
            container.addOrReplace(new Component[]{new HeaderPanel("panel")});
        }
        if (PreAuthenticatedUserNameFilterConfig.RoleSource.UserGroupService.equals((Object)rs)) {
            container.addOrReplace(new Component[]{new UserGroupServicePanel("panel")});
        }
        if (PreAuthenticatedUserNameFilterConfig.RoleSource.RoleService.equals((Object)rs)) {
            container.addOrReplace(new Component[]{new RoleServicePanel("panel")});
        }
        if (rs == null) {
            container.add(new Component[]{new UserGroupServicePanel("panel")});
        }
    }

    static class RoleServicePanel
    extends Panel {
        public RoleServicePanel(String id) {
            super(id, (IModel)new Model());
            this.add(new Component[]{new RoleServiceChoice("roleServiceName")});
        }
    }

    static class UserGroupServicePanel
    extends Panel {
        public UserGroupServicePanel(String id) {
            super(id, (IModel)new Model());
            this.add(new Component[]{new UserGroupServiceChoice("userGroupServiceName").setRequired(true)});
        }
    }

    static class HeaderPanel
    extends Panel {
        public HeaderPanel(String id) {
            super(id, (IModel)new Model());
            this.add(new Component[]{new TextField("rolesHeaderAttribute").setRequired(true)});
        }
    }
}

