/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.auth;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.OnChangeAjaxBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.geoserver.security.GeoServerSecurityFilterChain;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.RequestFilterChain;
import org.geoserver.security.config.SecurityManagerConfig;
import org.geoserver.security.filter.GeoServerAuthenticationFilter;
import org.geoserver.security.web.AbstractSecurityPage;
import org.geoserver.security.web.auth.AuthFilterChainPalette;
import org.geoserver.security.web.auth.AuthenticationChainPalette;
import org.geoserver.security.web.auth.AuthenticationFiltersPanel;
import org.geoserver.security.web.auth.AuthenticationProvidersPanel;
import org.geoserver.web.wicket.HelpLink;

public class AuthenticationPage
extends AbstractSecurityPage {
    public AuthenticationPage() {
        this.initComponents();
    }

    void initComponents() {
        Form form = new Form("form", (IModel)new CompoundPropertyModel((Object)this.getSecurityManager().getSecurityConfig()));
        this.add(new Component[]{form});
        form.add(new Component[]{new AuthenticationFiltersPanel("authFilters")});
        form.add(new Component[]{new HelpLink("authFiltersHelp").setDialog(this.dialog)});
        form.add(new Component[]{new AuthenticationProvidersPanel("authProviders")});
        form.add(new Component[]{new HelpLink("authProvidersHelp").setDialog(this.dialog)});
        form.add(new Component[]{new AuthFilterChainPanel("filterChain", (IModel<GeoServerSecurityFilterChain>)new PropertyModel((Object)form.getModel(), "filterChain"))});
        form.add(new Component[]{new HelpLink("filterChainHelp").setDialog(this.dialog)});
        form.add(new Component[]{new AuthenticationChainPanel("providerChain", form)});
        form.add(new Component[]{new HelpLink("providerChainHelp").setDialog(this.dialog)});
        form.add(new Component[]{new SubmitLink("save", form){

            public void onSubmit() {
                try {
                    AuthenticationPage.this.getSecurityManager().saveSecurityConfig((SecurityManagerConfig)this.getForm().getModelObject());
                    AuthenticationPage.this.doReturn();
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Error saving authentication config", e);
                    this.error(e);
                }
            }
        }});
        form.add(new Component[]{new Link("cancel"){

            public void onClick() {
                AuthenticationPage.this.doReturn();
            }
        }});
    }

    class AuthFilterChainPanel
    extends FormComponentPanel {
        RequestFilterChain requestChain;

        public AuthFilterChainPanel(String id, IModel<GeoServerSecurityFilterChain> model) {
            super(id, (IModel)new Model());
            this.requestChain = ((GeoServerSecurityFilterChain)model.getObject()).getRequestChainByName("web");
            this.add(new Component[]{new RequestChainDropDownChoice("requestChain", (IModel<RequestFilterChain>)new PropertyModel((Object)this, "requestChain"), (IModel<List<RequestFilterChain>>)new PropertyModel(model, "requestChains")).add(new IBehavior[]{new OnChangeAjaxBehavior(){

                protected void onUpdate(AjaxRequestTarget target) {
                    target.addComponent(AuthFilterChainPanel.this.get("authFilterChain"));
                }
            }})});
            this.add(new Component[]{new AuthFilterChainPalette("authFilterChain", new AuthFilterNamesModel(model)).setOutputMarkupId(true)});
        }

        class AuthFilterNamesModel
        implements IModel<List<String>> {
            IModel<GeoServerSecurityFilterChain> filterChainModel;

            AuthFilterNamesModel(IModel<GeoServerSecurityFilterChain> filterChainModel) {
                this.filterChainModel = filterChainModel;
            }

            public List<String> getObject() {
                GeoServerSecurityManager secMgr = AuthenticationPage.this.getSecurityManager();
                ArrayList<String> filters = new ArrayList<String>(AuthFilterChainPanel.this.requestChain.getFilterNames());
                try {
                    filters.retainAll(secMgr.listFilters(GeoServerAuthenticationFilter.class));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return filters;
            }

            public void setObject(List<String> object) {
                if (!AuthFilterChainPanel.this.requestChain.updateAuthFilters(object)) {
                    AuthFilterChainPanel.this.error((Serializable)((Object)("Unable to update filters for " + AuthFilterChainPanel.this.requestChain)));
                }
            }

            public void detach() {
                this.filterChainModel.detach();
            }
        }
    }

    class RequestChainDropDownChoice
    extends DropDownChoice<RequestFilterChain> {
        public RequestChainDropDownChoice(String id, IModel<RequestFilterChain> model, IModel<List<RequestFilterChain>> choices) {
            super(id, model, choices, (IChoiceRenderer)new ChoiceRenderer<RequestFilterChain>(){

                public Object getDisplayValue(RequestFilterChain object) {
                    String name = object.getName();
                    return new ResourceModel(RequestFilterChain.class.getSimpleName() + "." + name, name).getObject();
                }

                public String getIdValue(RequestFilterChain object, int index) {
                    return object.getName();
                }
            });
        }
    }

    class AuthenticationChainPanel
    extends FormComponentPanel {
        public AuthenticationChainPanel(String id, Form form) {
            super(id, (IModel)new Model());
            this.add(new Component[]{new AuthenticationChainPalette("authProviderNames")});
        }
    }
}

