/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.web.SecurityNamedServiceEditPage;

public abstract class SecurityNamedServicesTogglePanel<T extends SecurityNamedServiceConfig>
extends Panel {
    public SecurityNamedServicesTogglePanel(String id, IModel<List<T>> model) {
        super(id);
        Form form = new Form("form");
        this.add(new Component[]{form});
        form.add(new Component[]{new ListView<T>("services", model){

            protected void populateItem(final ListItem<T> item) {
                IModel model = item.getModel();
                AjaxLink toggle = new AjaxLink<T>("toggle", model){

                    public void onClick(AjaxRequestTarget target) {
                        if (item.get("panel") instanceof ContentPanel) {
                            item.addOrReplace(new Component[]{new WebMarkupContainer("panel")});
                            item.get("toggle").add(new IBehavior[]{new AttributeModifier("class", (IModel)new Model((Serializable)((Object)"collapsed")))});
                        } else {
                            item.addOrReplace(new Component[]{SecurityNamedServicesTogglePanel.this.createPanel("panel", item.getModel())});
                            item.get("toggle").add(new IBehavior[]{new AttributeModifier("class", (IModel)new Model((Serializable)((Object)"expanded")))});
                        }
                        target.addComponent((Component)item);
                    }
                };
                toggle.add(new Component[]{new Label("name", (IModel)new PropertyModel((Object)model, "name"))});
                boolean first = item.getIndex() == 0;
                toggle.add(new IBehavior[]{new AttributeAppender("class", (IModel)new Model((Serializable)((Object)(first ? "expanded" : "collapsed"))), " ")});
                item.add(new Component[]{toggle});
                item.add(new Component[]{first ? SecurityNamedServicesTogglePanel.this.createPanel("panel", model) : new WebMarkupContainer("panel")});
                item.setOutputMarkupId(true);
            }
        }});
    }

    protected abstract ContentPanel createPanel(String var1, IModel<T> var2);

    protected static class ContentPanel<T>
    extends Panel {
        public ContentPanel(String id, final IModel<T> model) {
            super(id);
            this.add(new Component[]{new Link("edit"){

                public void onClick() {
                    SecurityNamedServiceEditPage editPage = new SecurityNamedServiceEditPage(model);
                    editPage.setReturnPage(this.getPage());
                    this.setResponsePage((Page)editPage);
                }
            }});
        }
    }
}

