/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.password.GeoServerPasswordEncoder;
import org.geoserver.security.web.AbstractSecurityPage;
import org.geoserver.security.web.SecuritySettingsPage;
import org.geoserver.security.web.UserGroupRoleServicesPage;
import org.geoserver.security.web.passwd.MasterPasswordChangePage;
import org.geoserver.security.web.user.EditUserPage;
import org.geoserver.security.xml.XMLUserGroupService;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.GeoServerHomePageContentProvider;
import org.geotools.util.logging.Logging;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;

public class SecurityHomePageContentProvider
implements GeoServerHomePageContentProvider {
    static Logger LOGGER = Logging.getLogger(SecurityHomePageContentProvider.class);

    public Component getPageBodyComponent(String id) {
        GeoServerSecurityManager secMgr = GeoServerApplication.get().getSecurityManager();
        if (secMgr.checkAuthenticationForAdminRole()) {
            return new SecurityWarningsPanel(id);
        }
        return null;
    }

    static boolean testAuthentication(String user, String passwd, GeoServerSecurityManager secMgr) {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)user, (Object)passwd);
        try {
            token = secMgr.authenticate((Authentication)token);
        }
        catch (Exception e) {
            // empty catch block
        }
        return token.isAuthenticated();
    }

    static class SecurityWarningsPanel
    extends Panel {
        public SecurityWarningsPanel(String id) {
            super(id);
            GeoServerPasswordEncoder encoder;
            GeoServerSecurityManager manager = GeoServerApplication.get().getSecurityManager();
            File mpInfo = null;
            Label mpInfoLabel = null;
            try {
                mpInfo = new File(manager.getSecurityRoot(), "masterpw.info");
                mpInfoLabel = new Label("mpfile", (IModel)new StringResourceModel("masterPasswordFile", (Component)this, null, new Object[]{mpInfo.getCanonicalFile()}));
                mpInfoLabel.setEscapeModelStrings(false);
                this.add(new Component[]{mpInfoLabel});
                mpInfoLabel.setVisible(mpInfo.exists());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            File userprops = null;
            Label userpropsLabel = null;
            try {
                userprops = new File(manager.getSecurityRoot(), "users.properties.old");
                userpropsLabel = new Label("userpropsold", (IModel)new StringResourceModel("userPropertiesOldFile", (Component)this, null, new Object[]{userprops.getCanonicalFile()}));
                userpropsLabel.setEscapeModelStrings(false);
                this.add(new Component[]{userpropsLabel});
                userpropsLabel.setVisible(userprops.exists());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            boolean visibility = SecurityHomePageContentProvider.testAuthentication("root", "geoserver", manager);
            Label label = new Label("mpmessage", (IModel)new StringResourceModel("changeMasterPassword", (Component)this, null));
            label.setEscapeModelStrings(false);
            this.add(new Component[]{label});
            Link link = null;
            Component[] componentArray = new Component[1];
            link = new Link("mplink"){

                public void onClick() {
                    this.setResponsePage((Page)new MasterPasswordChangePage());
                }
            };
            componentArray[0] = link;
            this.add(componentArray);
            label.setVisible(visibility);
            link.setVisible(visibility);
            visibility = SecurityHomePageContentProvider.testAuthentication("admin", "geoserver", manager);
            AbstractSecurityPage changeItPage = null;
            String passwordEncoderName = null;
            try {
                GeoServerUserGroupService ugService = manager.loadUserGroupService(XMLUserGroupService.DEFAULT_NAME);
                if (ugService != null) {
                    passwordEncoderName = ugService.getPasswordEncoderName();
                    GeoServerUser user = ugService.getUserByUsername("admin");
                    if (user != null) {
                        changeItPage = new EditUserPage(ugService.getName(), user);
                    }
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Error looking up admin user", e);
            }
            if (changeItPage == null) {
                changeItPage = new UserGroupRoleServicesPage();
            }
            UserGroupRoleServicesPage linkPage = changeItPage;
            label = new Label("adminmessage", (IModel)new StringResourceModel("changeAdminPassword", (Component)this, null));
            label.setEscapeModelStrings(false);
            this.add(new Component[]{label});
            Component[] componentArray2 = new Component[1];
            link = new Link("adminlink", (Page)linkPage){
                final /* synthetic */ Page val$linkPage;
                {
                    this.val$linkPage = page;
                    super(x0);
                }

                public void onClick() {
                    this.setResponsePage(this.val$linkPage);
                }
            };
            componentArray2[0] = link;
            this.add(componentArray2);
            label.setVisible(visibility);
            link.setVisible(visibility);
            if (manager.isStrongEncryptionAvailable()) {
                this.add(new Component[]{new Label("strongEncryptionMsg", (IModel)new StringResourceModel("strongEncryption", (Component)new SecuritySettingsPage(), null)).add(new IBehavior[]{new AttributeAppender("class", (IModel)new Model((Serializable)((Object)"info-link")), " ")})});
            } else {
                this.add(new Component[]{new Label("strongEncryptionMsg", (IModel)new StringResourceModel("noStrongEncryption", (Component)new SecuritySettingsPage(), null)).add(new IBehavior[]{new AttributeAppender("class", (IModel)new Model((Serializable)((Object)"warning-link")), " ")})});
            }
            visibility = false;
            if (passwordEncoderName != null && (encoder = manager.loadPasswordEncoder(passwordEncoderName)) != null) {
                visibility = encoder.isReversible();
            }
            label = new Label("digestEncoding", (IModel)new StringResourceModel("digestEncoding", (Component)this, null));
            this.add(new Component[]{label});
            label.setVisible(visibility);
        }
    }
}

