/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.awt.Graphics;
import java.util.Timer;
import java.util.TimerTask;
import org.geotools.renderer.GTRenderer;

public class RenderingTimeoutEnforcer {
    long timeout;
    GTRenderer renderer;
    Graphics graphics;
    Timer timer;
    boolean timedOut = false;

    public RenderingTimeoutEnforcer(long timeout, GTRenderer renderer, Graphics graphics) {
        this.timeout = timeout;
        this.renderer = renderer;
        this.graphics = graphics;
    }

    public void start() {
        if (this.timer != null) {
            throw new IllegalStateException("The timeout enforcer has already been started");
        }
        if (this.timeout > 0L) {
            this.timedOut = false;
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new StopRenderingTask(), this.timeout);
        }
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
            this.timer = null;
        }
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    class StopRenderingTask
    extends TimerTask {
        StopRenderingTask() {
        }

        @Override
        public void run() {
            RenderingTimeoutEnforcer.this.timedOut = true;
            RenderingTimeoutEnforcer.this.renderer.stopRendering();
            RenderingTimeoutEnforcer.this.graphics.dispose();
        }
    }
}

