/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapProducerCapabilities;
import org.geoserver.wms.RasterCleaner;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.kvp.PaletteManager;
import org.geoserver.wms.map.AbstractMapResponse;
import org.geoserver.wms.map.ImageUtils;
import org.geoserver.wms.map.PNGMapResponse;
import org.geoserver.wms.map.RenderedImageMap;
import org.geoserver.wms.map.quantize.CachingColorIndexer;
import org.geoserver.wms.map.quantize.ColorIndexer;
import org.geoserver.wms.map.quantize.ColorIndexerDescriptor;
import org.geoserver.wms.map.quantize.LRUColorIndexer;
import org.geoserver.wms.map.quantize.Quantizer;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.image.ImageWorker;
import org.geotools.image.palette.InverseColorMapOp;
import org.springframework.util.Assert;

public abstract class RenderedImageMapResponse
extends AbstractMapResponse {
    private static final String DEFAULT_MAP_FORMAT = "image/png";
    protected final WMS wms;

    public RenderedImageMapResponse(WMS wms) {
        this(DEFAULT_MAP_FORMAT, wms);
    }

    public RenderedImageMapResponse(String mime, WMS wms) {
        super(RenderedImageMap.class, mime);
        this.wms = wms;
    }

    public RenderedImageMapResponse(String[] outputFormats, WMS wms) {
        super(RenderedImageMap.class, outputFormats);
        this.wms = wms;
    }

    public abstract void formatImageOutputStream(RenderedImage var1, OutputStream var2, WMSMapContent var3) throws ServiceException, IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(Object value, OutputStream output, Operation operation) throws IOException, ServiceException {
        Assert.isInstanceOf(RenderedImageMap.class, (Object)value);
        RenderedImageMap imageMap = (RenderedImageMap)value;
        try {
            RenderedImage image = imageMap.getImage();
            List<GridCoverage2D> renderedCoverages = imageMap.getRenderedCoverages();
            WMSMapContent mapContent = imageMap.getMapContext();
            try {
                this.formatImageOutputStream(image, output, mapContent);
                output.flush();
            }
            finally {
                for (GridCoverage2D coverage : renderedCoverages) {
                    RasterCleaner.addCoverage(coverage);
                }
                RasterCleaner.addImage(image);
            }
        }
        finally {
            imageMap.dispose();
        }
    }

    protected RenderedImage applyPalette(RenderedImage image, WMSMapContent mapContent, String palettedFormatName, boolean supportsTranslucency) {
        GetMapRequest request = mapContent.getRequest();
        PNGMapResponse.QuantizeMethod method = (PNGMapResponse.QuantizeMethod)((Object)request.getFormatOptions().get("quantizer"));
        boolean useBitmaskQuantizer = method == PNGMapResponse.QuantizeMethod.Octree || !supportsTranslucency || method == null && image.getColorModel().getTransparency() != 3;
        String format = request.getFormat();
        IndexColorModel icm = mapContent.getPalette();
        if (useBitmaskQuantizer) {
            if (icm != null) {
                image = this.forceIndexed8Bitmask(image, PaletteManager.getInverseColorMapOp(icm));
            } else if (palettedFormatName.equalsIgnoreCase(format)) {
                image = this.forceIndexed8Bitmask(image, null);
            }
        } else if (!(image.getColorModel() instanceof IndexColorModel)) {
            image = new ImageWorker(image).rescaleToBytes().forceComponentColorModel().getRenderedImage();
            ColorIndexer indexer = null;
            if (mapContent.getPalette() != null) {
                indexer = new CachingColorIndexer(new LRUColorIndexer(icm, 1024));
            } else if (palettedFormatName.equalsIgnoreCase(format)) {
                indexer = new Quantizer(256).subsample().buildColorIndexer(image);
            }
            if (indexer != null) {
                image = ColorIndexerDescriptor.create(image, indexer, null);
            }
        }
        return image;
    }

    protected RenderedImage forceIndexed8Bitmask(RenderedImage originalImage, InverseColorMapOp paletteInverter) {
        return ImageUtils.forceIndexed8Bitmask(originalImage, paletteInverter);
    }

    public abstract MapProducerCapabilities getCapabilities(String var1);
}

