/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geotools.feature.FeatureTypes;
import org.geotools.styling.AnchorPoint;
import org.geotools.styling.ChannelSelection;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.ContrastEnhancement;
import org.geotools.styling.Displacement;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.Graphic;
import org.geotools.styling.Halo;
import org.geotools.styling.ImageOutline;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.OverlapBehavior;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SelectedChannelType;
import org.geotools.styling.ShadedRelief;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.UserLayer;
import org.opengis.feature.type.FeatureType;

public class RasterSymbolizerVisitor
implements StyleVisitor {
    double scaleDenominator;
    FeatureType featureType;
    List<RasterSymbolizer> symbolizers = new ArrayList<RasterSymbolizer>();
    boolean otherSymbolizers = false;
    boolean renderingTransformations = false;

    public RasterSymbolizerVisitor(double scaleDenominator, FeatureType featureType) {
        this.scaleDenominator = scaleDenominator;
        this.featureType = featureType;
    }

    public void reset() {
        this.symbolizers.clear();
        this.otherSymbolizers = false;
        this.renderingTransformations = false;
    }

    public List<RasterSymbolizer> getRasterSymbolizers() {
        if (this.otherSymbolizers || this.renderingTransformations) {
            return Collections.emptyList();
        }
        return this.symbolizers;
    }

    public void visit(StyledLayerDescriptor sld) {
        for (StyledLayer sl : sld.getStyledLayers()) {
            if (sl instanceof UserLayer) {
                ((UserLayer)sl).accept((StyleVisitor)this);
                continue;
            }
            if (!(sl instanceof NamedLayer)) continue;
            ((NamedLayer)sl).accept((StyleVisitor)this);
        }
    }

    public void visit(NamedLayer layer) {
        for (Style s : layer.getStyles()) {
            s.accept((StyleVisitor)this);
        }
    }

    public void visit(UserLayer layer) {
        for (Style s : layer.getUserStyles()) {
            s.accept((StyleVisitor)this);
        }
    }

    public void visit(FeatureTypeConstraint ftc) {
    }

    public void visit(Style style) {
        for (FeatureTypeStyle fts : style.featureTypeStyles()) {
            if (fts.getTransformation() != null) {
                this.renderingTransformations = true;
            }
            fts.accept((StyleVisitor)this);
        }
    }

    public void visit(Rule rule) {
        if (rule.getMinScaleDenominator() < this.scaleDenominator && rule.getMaxScaleDenominator() > this.scaleDenominator) {
            for (Symbolizer s : rule.symbolizers()) {
                s.accept((StyleVisitor)this);
            }
        }
    }

    public void visit(FeatureTypeStyle fts) {
        if (this.featureType.getName().getLocalPart() != null && (this.featureType.getName().getLocalPart().equalsIgnoreCase(fts.getFeatureTypeName()) || FeatureTypes.isDecendedFrom((FeatureType)this.featureType, null, (String)fts.getFeatureTypeName()))) {
            for (Rule r : fts.rules()) {
                r.accept((StyleVisitor)this);
            }
        }
    }

    public void visit(Fill fill) {
    }

    public void visit(Stroke stroke) {
    }

    public void visit(Symbolizer sym) {
        if (sym instanceof RasterSymbolizer) {
            this.visit((RasterSymbolizer)sym);
        } else {
            this.otherSymbolizers = true;
        }
    }

    public void visit(PointSymbolizer ps) {
        this.otherSymbolizers = true;
    }

    public void visit(LineSymbolizer line) {
        this.otherSymbolizers = true;
    }

    public void visit(PolygonSymbolizer poly) {
        this.otherSymbolizers = true;
    }

    public void visit(TextSymbolizer text) {
        this.otherSymbolizers = true;
    }

    public void visit(RasterSymbolizer raster) {
        this.symbolizers.add(raster);
    }

    public void visit(Graphic gr) {
    }

    public void visit(Mark mark) {
    }

    public void visit(ExternalGraphic exgr) {
    }

    public void visit(PointPlacement pp) {
    }

    public void visit(AnchorPoint ap) {
    }

    public void visit(Displacement dis) {
    }

    public void visit(LinePlacement lp) {
    }

    public void visit(Halo halo) {
    }

    public void visit(ColorMap colorMap) {
    }

    public void visit(ColorMapEntry colorMapEntry) {
    }

    public void visit(ContrastEnhancement contrastEnhancement) {
    }

    public void visit(ImageOutline outline) {
    }

    public void visit(ChannelSelection cs) {
    }

    public void visit(OverlapBehavior ob) {
    }

    public void visit(SelectedChannelType sct) {
    }

    public void visit(ShadedRelief sr) {
    }
}

